/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.solr.servlet;

import java.io.ByteArrayInputStream;
import java.io.IOException;
import java.io.InputStream;
import java.nio.charset.Charset;
import java.security.cert.CertificateException;
import java.security.cert.CertificateFactory;
import java.security.cert.X509Certificate;
import java.util.ArrayList;
import java.util.Collections;
import java.util.HashSet;
import javax.servlet.FilterChain;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.Cookie;
import org.apache.commons.io.IOUtils;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.auth.CertificateManager;
import org.dataone.cn.servlet.http.ProxyServletRequestWrapper;
import org.dataone.portal.PortalCertificateManager;
import org.dataone.service.cn.impl.v2.CNIdentityLDAPImpl;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;
import org.dataone.service.types.v1.util.AuthUtils;

public class SessionAuthorizationUtil {
    protected static Log logger = LogFactory.getLog(SessionAuthorizationUtil.class);
    private static final CNIdentityLDAPImpl identityService = new CNIdentityLDAPImpl();
    private static final String CERTIFICATES_ATTR = "javax.servlet.request.X509Certificate";
    private static final String SSL_CLIENT_CERT_HEADER = "SSL_CLIENT_CERT";
    private static final String CIPHER_SUITE_ATTR = "javax.servlet.request.cipher_suite";
    private static final String SSL_CIPHER_HEADER = "SSL_CIPHER";
    private static final String SSL_SESSION_ID_ATTR = "javax.servlet.request.ssl_session";
    private static final String SSL_SESSIONID_HEADER = "SSL_SESSION_ID";
    private static final String KEY_SIZE_ATTR = "javax.servlet.request.key_size";
    private static final String SSL_CIPHER_USER_KEYSIZE_HEADER = "SSL_CIPHER_USEKEYSIZE";
    private static final String SSL_CLIENT_VERIFY_HEADER = "SSL_CLIENT_VERIFY";
    private static final String MOD_HEADER_NULL = "(null)";
    private static final String D1_AUTHORIZATION_TOKEN_HEADER = "Authorization";

    private SessionAuthorizationUtil() {
    }

    public static void handleNoCertificateManagerSession(ProxyServletRequestWrapper proxyRequest, ServletResponse response, FilterChain fc) throws ServletException, IOException, NotAuthorized {
        logger.debug("session is null: default to public");
        fc.doFilter((ServletRequest)proxyRequest, response);
    }

    public static void addAuthenticatedSubjectsToRequest(ProxyServletRequestWrapper proxyRequest, Session session, Subject authorizedSubject) throws ServiceFailure, NotAuthorized, NotImplemented {
        ArrayList<String> authorizedSubjects = new ArrayList<String>();
        authorizedSubjects.add("public");
        authorizedSubjects.add("authenticatedUser");
        SubjectInfo authorizedSubjectInfo = null;
        try {
            authorizedSubjectInfo = identityService.getSubjectInfo(session, authorizedSubject);
        }
        catch (NotFound e2) {
            authorizedSubjectInfo = session.getSubjectInfo();
        }
        if (authorizedSubjectInfo == null) {
            String standardizedName = authorizedSubject.getValue();
            try {
                standardizedName = CertificateManager.getInstance().standardizeDN(standardizedName);
            }
            catch (Exception exception) {
                // empty catch block
            }
            authorizedSubjects.add(standardizedName);
        } else {
            HashSet<Subject> subjectSet = new HashSet<Subject>();
            AuthUtils.findPersonsSubjects(subjectSet, authorizedSubjectInfo, authorizedSubject);
            for (Subject subject : subjectSet) {
                if (subject == null) continue;
                if ("verifiedUser".equals(subject.getValue())) {
                    authorizedSubjects.add("verifiedUser");
                    continue;
                }
                String standardizedName = subject.getValue();
                try {
                    standardizedName = CertificateManager.getInstance().standardizeDN(subject.getValue());
                }
                catch (Exception e3) {
                    logger.warn("Could not standardize DN for: " + standardizedName, e3);
                }
                authorizedSubjects.add(standardizedName);
            }
        }
        if (!authorizedSubjects.isEmpty()) {
            proxyRequest.setParameterValues("authorizedSubjects", authorizedSubjects.toArray(new String[0]));
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public static boolean validateSSLAttributes(ProxyServletRequestWrapper request) {
        ArrayList attributeNames = Collections.list(request.getAttributeNames());
        boolean rtn = false;
        Cookie portalCookie = PortalCertificateManager.getInstance().getCookie(request);
        if (attributeNames.contains(CERTIFICATES_ATTR)) {
            rtn = true;
        } else {
            ArrayList<String> headerNames = Collections.list(request.getHeaderNames());
            if (logger.isDebugEnabled()) {
                for (String header : headerNames) {
                    logger.debug(header + ": " + request.getHeader(header));
                }
            }
            if (headerNames.contains(SSL_CLIENT_VERIFY_HEADER)) {
                String verify = request.getHeader(SSL_CLIENT_VERIFY_HEADER);
                if (verify != null && verify.equals("SUCCESS")) {
                    String x509ClientRequest = request.getHeader(SSL_CLIENT_CERT_HEADER);
                    if (x509ClientRequest != null && !x509ClientRequest.equals(MOD_HEADER_NULL) && x509ClientRequest.length() > 28) {
                        ByteArrayInputStream bais = null;
                        try {
                            String sslCipherUserKeySizeHeader;
                            String sslSessionIdHeader;
                            x509ClientRequest = x509ClientRequest.replace(' ', '\n');
                            StringBuilder rebuildX509ClientRequest = new StringBuilder();
                            rebuildX509ClientRequest.append("-----BEGIN CERTIFICATE-----\n");
                            rebuildX509ClientRequest.append(x509ClientRequest.substring(28, x509ClientRequest.length() - 26));
                            rebuildX509ClientRequest.append("\n-----END CERTIFICATE-----\n");
                            x509ClientRequest = rebuildX509ClientRequest.toString();
                            bais = new ByteArrayInputStream(x509ClientRequest.getBytes(Charset.defaultCharset()));
                            X509Certificate[] jsseCerts = null;
                            CertificateFactory cf = CertificateFactory.getInstance("X.509");
                            X509Certificate cert = (X509Certificate)cf.generateCertificate(bais);
                            jsseCerts = new X509Certificate[]{cert};
                            request.setAttribute(CERTIFICATES_ATTR, jsseCerts);
                            String sslCipherHeader = request.getHeader(SSL_CLIENT_CERT_HEADER);
                            if (sslCipherHeader != null && !sslCipherHeader.equals(MOD_HEADER_NULL)) {
                                request.setAttribute(CIPHER_SUITE_ATTR, sslCipherHeader);
                            }
                            if ((sslSessionIdHeader = request.getHeader(SSL_SESSIONID_HEADER)) != null && !sslSessionIdHeader.equals(MOD_HEADER_NULL)) {
                                request.setAttribute(SSL_SESSION_ID_ATTR, sslSessionIdHeader);
                            }
                            if ((sslCipherUserKeySizeHeader = request.getHeader(SSL_CIPHER_USER_KEYSIZE_HEADER)) != null && !sslCipherUserKeySizeHeader.equals(MOD_HEADER_NULL)) {
                                request.setAttribute(KEY_SIZE_ATTR, Integer.valueOf(sslCipherUserKeySizeHeader));
                            }
                            rtn = true;
                            IOUtils.closeQuietly((InputStream)bais);
                        }
                        catch (CertificateException e2) {
                            logger.warn("sslValve.certError", e2);
                        }
                        finally {
                            IOUtils.closeQuietly(bais);
                        }
                    }
                } else if (headerNames.contains(D1_AUTHORIZATION_TOKEN_HEADER) && !request.getHeader(D1_AUTHORIZATION_TOKEN_HEADER).equals(MOD_HEADER_NULL)) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("session passed via token: Authorization: " + request.getHeader(D1_AUTHORIZATION_TOKEN_HEADER));
                    }
                    rtn = true;
                } else if (portalCookie != null) {
                    if (logger.isDebugEnabled()) {
                        logger.debug("portal cookie found: " + portalCookie.getName() + ": " + portalCookie.getValue());
                    }
                    rtn = true;
                }
            } else if (headerNames.contains(D1_AUTHORIZATION_TOKEN_HEADER) && !request.getHeader(D1_AUTHORIZATION_TOKEN_HEADER).equals(MOD_HEADER_NULL)) {
                if (logger.isDebugEnabled()) {
                    logger.debug("session passed via token: Authorization: " + request.getHeader(D1_AUTHORIZATION_TOKEN_HEADER));
                }
                rtn = true;
            } else if (portalCookie != null) {
                if (logger.isDebugEnabled()) {
                    logger.debug("portal cookie found: " + portalCookie.getName() + ": " + portalCookie.getValue());
                }
                rtn = true;
            }
        }
        return rtn;
    }
}

