/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.solr.servlet;

import java.io.IOException;
import java.util.ArrayList;
import java.util.Date;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import javax.servlet.Filter;
import javax.servlet.FilterChain;
import javax.servlet.FilterConfig;
import javax.servlet.ServletException;
import javax.servlet.ServletRequest;
import javax.servlet.ServletResponse;
import javax.servlet.http.HttpServletRequest;
import javax.servlet.http.HttpServletResponse;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.cn.servlet.http.ProxyServletRequestWrapper;
import org.dataone.configuration.Settings;
import org.dataone.portal.PortalCertificateManager;
import org.dataone.service.cn.v2.NodeRegistryService;
import org.dataone.service.cn.v2.impl.NodeRegistryServiceImpl;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.NodeState;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.Service;
import org.dataone.service.types.v1.ServiceMethodRestriction;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v2.Node;
import org.dataone.solr.servlet.SessionAuthorizationUtil;

public abstract class SessionAuthorizationFilterStrategy
implements Filter {
    protected static Log logger = LogFactory.getLog(SessionAuthorizationFilterStrategy.class);
    private static NodeRegistryService nodeRegistryService = new NodeRegistryServiceImpl();
    private static String adminToken = Settings.getConfiguration().getString("cn.solrAdministrator.token");
    private List<Subject> cnAdministrativeSubjects = new ArrayList<Subject>();
    private List<Subject> mnAdministrativeSubjects = new ArrayList<Subject>();
    private List<Subject> serviceMethodRestrictionSubjects = new ArrayList<Subject>();
    private Map<String, List<Subject>> mnNodeNameToSubjectsMap = new HashMap<String, List<Subject>>();
    private long lastRefreshTimeMS = 0L;
    private long nodelistRefreshIntervalSeconds = 300000L;

    protected abstract void handleNoCertificateManagerSession(ProxyServletRequestWrapper var1, ServletResponse var2, FilterChain var3) throws ServletException, IOException, NotAuthorized;

    protected abstract void addAuthenticatedSubjectsToRequest(ProxyServletRequestWrapper var1, Session var2, Subject var3) throws ServiceFailure, NotAuthorized, NotImplemented;

    protected abstract String getServiceMethodName();

    public void init(FilterConfig fc) throws ServletException {
        try {
            logger.debug("about to cache admin");
            this.cacheAdministrativeSubjectList();
        }
        catch (NotImplemented ex) {
            logger.error(ex.serialize(0));
        }
        catch (ServiceFailure ex) {
            logger.error(ex.serialize(0));
        }
        this.lastRefreshTimeMS = new Date().getTime();
        logger.debug("init SessionAuthorizationFilter: " + this.getClass().getName());
    }

    public void doFilter(ServletRequest request, ServletResponse response, FilterChain fc) throws IOException, ServletException {
        block23: {
            logger.debug("SessionAuthorizationFilterStrategy doFilter invoked by: " + this.getClass().getName());
            try {
                if (request instanceof HttpServletRequest) {
                    String[] emptyValues = new String[]{};
                    ProxyServletRequestWrapper proxyRequest = new ProxyServletRequestWrapper((HttpServletRequest)request);
                    Map proxyMap = proxyRequest.getParameterMap();
                    if (proxyMap.containsKey("authorizedSubjects")) {
                        logger.debug("removing attempt at supplying authorized user by client");
                        proxyRequest.setParameterValues("authorizedSubjects", emptyValues);
                    }
                    if (proxyMap.containsKey("isCnAdministrator")) {
                        logger.debug("removing attempt at supplying authorized administrative user by client");
                        proxyRequest.setParameterValues("isCnAdministrator", emptyValues);
                    }
                    if (proxyMap.containsKey("isMnAdministrator")) {
                        logger.debug("removing attempt at supplying authorized administrative user by client");
                        proxyRequest.setParameterValues("isMnAdministrator", emptyValues);
                    }
                    boolean hasValidSSL = SessionAuthorizationUtil.validateSSLAttributes(proxyRequest);
                    logger.debug("valid SSL: " + hasValidSSL);
                    if (hasValidSSL) {
                        Session session = PortalCertificateManager.getInstance().getSession((HttpServletRequest)request);
                        if (session != null) {
                            if (this.isTimeForRefresh().booleanValue()) {
                                this.cacheAdministrativeSubjectList();
                            }
                            Subject authorizedSubject = session.getSubject();
                            logger.debug("Solr Session Auth found subject: " + authorizedSubject.getValue());
                            if (this.cnAdministrativeSubjects.contains(authorizedSubject)) {
                                logger.debug(authorizedSubject.getValue() + " is a cn administrator");
                                String[] isAdministrativeSubjectValue = new String[]{adminToken};
                                proxyRequest.setParameterValues("isCnAdministrator", isAdministrativeSubjectValue);
                            } else if (this.mnAdministrativeSubjects.contains(authorizedSubject)) {
                                for (String mnIdentifier : this.mnNodeNameToSubjectsMap.keySet()) {
                                    List<Subject> mnSubjectList = this.mnNodeNameToSubjectsMap.get(mnIdentifier);
                                    if (mnSubjectList == null || !mnSubjectList.contains(authorizedSubject)) continue;
                                    String[] mnAdministratorParamValue = new String[]{mnIdentifier};
                                    logger.debug(authorizedSubject.getValue() + " is a mn administrator");
                                    proxyRequest.setParameterValues("isMnAdministrator", mnAdministratorParamValue);
                                }
                            } else if (!this.serviceMethodRestrictionSubjects.isEmpty()) {
                                if (this.serviceMethodRestrictionSubjects.contains(authorizedSubject)) {
                                    this.addAuthenticatedSubjectsToRequest(proxyRequest, session, authorizedSubject);
                                } else {
                                    logger.debug("Solr Session auth - " + authorizedSubject.getValue() + " not found in restricted list");
                                    this.handleNoCertificateManagerSession(proxyRequest, response, fc);
                                }
                            } else {
                                logger.debug(authorizedSubject.getValue() + " is authorized");
                                this.addAuthenticatedSubjectsToRequest(proxyRequest, session, authorizedSubject);
                            }
                            fc.doFilter((ServletRequest)proxyRequest, response);
                        } else {
                            logger.debug("Solr Session auth - NO SESSION");
                            this.handleNoCertificateManagerSession(proxyRequest, response, fc);
                        }
                    } else {
                        logger.debug("Invalidate SSL Attributes");
                        this.handleNoCertificateManagerSession(proxyRequest, response, fc);
                    }
                    break block23;
                }
                throw new NotImplemented("1461", "ServletRequest is not a HttpServletRequest!?");
            }
            catch (ServiceFailure ex) {
                ex.setDetail_code("1490");
                String failure = ex.serialize(0);
                ((HttpServletResponse)response).setStatus(500);
                response.getOutputStream().write(failure.getBytes());
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (NotAuthorized ex) {
                ex.setDetail_code("1460");
                String failure = ex.serialize(0);
                ((HttpServletResponse)response).setStatus(401);
                response.getOutputStream().write(failure.getBytes());
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (NotImplemented ex) {
                ex.setDetail_code("1461");
                String failure = ex.serialize(0);
                ((HttpServletResponse)response).setStatus(400);
                response.getOutputStream().write(failure.getBytes());
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
            catch (Exception ex) {
                logger.error(ex.getMessage(), ex);
                ServiceFailure sfe = new ServiceFailure("1490", ex.getClass() + ": " + ex.getMessage());
                sfe.setStackTrace(ex.getStackTrace());
                String failure = sfe.serialize(0);
                ((HttpServletResponse)response).setStatus(500);
                response.getOutputStream().write(failure.getBytes());
                response.getOutputStream().flush();
                response.getOutputStream().close();
            }
        }
    }

    private void cacheAdministrativeSubjectList() throws NotImplemented, ServiceFailure {
        this.cnAdministrativeSubjects.clear();
        this.mnAdministrativeSubjects.clear();
        this.serviceMethodRestrictionSubjects.clear();
        List nodeAdministrators = Settings.getConfiguration().getList("cn.administrators");
        if (nodeAdministrators != null) {
            for (String administrator : nodeAdministrators) {
                logger.debug("AdminList property entry " + administrator);
                Subject adminSubject = new Subject();
                adminSubject.setValue(administrator);
                this.cnAdministrativeSubjects.add(adminSubject);
            }
        }
        List<Node> nodeList = nodeRegistryService.listNodes().getNodeList();
        for (Node node : nodeList) {
            if (node.getType().equals(NodeType.CN) && node.getState().equals(NodeState.UP)) {
                for (Subject subject : node.getSubjectList()) {
                    logger.debug("AdminList entry CN subject: " + subject.getValue());
                }
                this.cnAdministrativeSubjects.addAll(node.getSubjectList());
                List<Service> cnServices = node.getServices().getServiceList();
                for (Service service : cnServices) {
                    if (!service.getName().equalsIgnoreCase("CNCore") || service.getRestrictionList() == null || service.getRestrictionList().isEmpty()) continue;
                    List<ServiceMethodRestriction> serviceMethodRestrictionList = service.getRestrictionList();
                    for (ServiceMethodRestriction serviceMethodRestriction : serviceMethodRestrictionList) {
                        if (!serviceMethodRestriction.getMethodName().equalsIgnoreCase(this.getServiceMethodName()) || serviceMethodRestriction.getSubjectList() == null) continue;
                        this.serviceMethodRestrictionSubjects.addAll(serviceMethodRestriction.getSubjectList());
                        for (Subject subject3 : serviceMethodRestriction.getSubjectList()) {
                            logger.debug("AdminList entry CN subject: " + subject3.getValue());
                        }
                    }
                }
            }
            if (!node.getType().equals(NodeType.MN) || !node.getState().equals(NodeState.UP) || node.getSubjectList() == null || node.getSubjectList().isEmpty()) continue;
            this.mnAdministrativeSubjects.addAll(node.getSubjectList());
            this.mnNodeNameToSubjectsMap.put(node.getIdentifier().getValue(), node.getSubjectList());
            for (Subject subject : node.getSubjectList()) {
                logger.debug("AdminList entry CN subject: " + subject.getValue());
            }
        }
    }

    private Boolean isTimeForRefresh() {
        long nowMS = System.currentTimeMillis();
        if (nowMS - this.lastRefreshTimeMS > this.nodelistRefreshIntervalSeconds) {
            this.lastRefreshTimeMS = nowMS;
            logger.info("nodelist refreshed");
            return true;
        }
        return false;
    }

    public void destroy() {
        logger.info("destroy SessionAuthorizationFilter");
    }
}

