/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.solr.response;

import java.io.ByteArrayOutputStream;
import java.io.IOException;
import java.io.Writer;
import org.apache.solr.common.util.NamedList;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.QueryResponseWriter;
import org.apache.solr.response.SolrQueryResponse;
import org.dataone.exceptions.MarshallingException;
import org.dataone.service.types.v1_1.QueryEngineDescription;
import org.dataone.service.util.TypeMarshaller;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryEngineDescriptionResponseWriter
implements QueryResponseWriter {
    private String D1_XSLT = null;
    private String responseKey;
    private static Logger logger = LoggerFactory.getLogger(QueryEngineDescriptionResponseWriter.class);

    protected void setD1_XSLT(String D1_XSLT) {
        this.D1_XSLT = D1_XSLT;
    }

    protected void setResponseKey(String responseKey) {
        this.responseKey = responseKey;
    }

    public void write(Writer writer, SolrQueryRequest request, SolrQueryResponse response) throws IOException {
        QueryEngineDescription qed = (QueryEngineDescription)response.getValues().get(this.responseKey);
        this.writeQueryEngineDescription(qed, writer);
    }

    private void writeQueryEngineDescription(QueryEngineDescription qed, Writer writer) {
        ByteArrayOutputStream os = new ByteArrayOutputStream();
        try {
            TypeMarshaller.marshalTypeToOutputStream(qed, os, this.D1_XSLT);
        }
        catch (MarshallingException jibxEx) {
            logger.error(jibxEx.getMessage(), jibxEx);
        }
        catch (IOException ioEx) {
            logger.error(ioEx.getMessage(), ioEx);
        }
        try {
            writer.write(os.toString("UTF-8"));
        }
        catch (IOException e2) {
            logger.error(e2.getMessage(), e2);
        }
    }

    public void init(NamedList args) {
    }

    public String getContentType(SolrQueryRequest request, SolrQueryResponse response) {
        return "application/xml; charset=UTF-8";
    }
}

