/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.solr.handler;

import java.io.File;
import java.io.IOException;
import java.io.StringWriter;
import java.io.Writer;
import java.net.MalformedURLException;
import java.net.URL;
import java.util.ArrayList;
import java.util.Collections;
import java.util.Comparator;
import java.util.HashMap;
import java.util.List;
import java.util.Map;
import org.apache.commons.io.FileUtils;
import org.apache.commons.lang3.StringUtils;
import org.apache.solr.common.util.XML;
import org.apache.solr.core.SolrCore;
import org.apache.solr.handler.RequestHandlerBase;
import org.apache.solr.request.SolrQueryRequest;
import org.apache.solr.response.SolrQueryResponse;
import org.apache.solr.schema.IndexSchema;
import org.apache.solr.schema.SchemaField;
import org.apache.solr.util.plugin.SolrCoreAware;
import org.dataone.service.types.v1_1.QueryEngineDescription;
import org.dataone.service.types.v1_1.QueryField;
import org.dataone.solr.handler.SolrQueryEngineDescriptionHandler;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

public abstract class QueryEngineDescriptionHandler
extends RequestHandlerBase
implements SolrCoreAware {
    private String additionalInfo = null;
    private String queryEngineName = null;
    private String schemaVersion = null;
    private String solrVersion = "";
    private String descriptionPath = null;
    private String schemaVersionProperty = null;
    private String responseKey = null;
    private String schemaPropertiesPath = null;
    private QueryEngineDescription qed = null;
    private Map<String, String> fieldDescriptions = null;
    private static Logger logger = LoggerFactory.getLogger(SolrQueryEngineDescriptionHandler.class);

    public void handleRequestBody(SolrQueryRequest req, SolrQueryResponse rsp) {
        rsp.add(this.responseKey, (Object)this.qed);
    }

    public void inform(SolrCore core) {
        this.loadSchemaFieldDescriptions();
        this.qed = new QueryEngineDescription();
        this.qed.setName(this.queryEngineName);
        this.setSchemaVersionFromPropertiesFile(this.qed);
        this.setSolrVersion(this.qed);
        this.setAdditionalInfo(this.qed);
        IndexSchema schema = core.getLatestSchema();
        Map fieldMap = schema.getFields();
        for (SchemaField schemaField : fieldMap.values()) {
            this.qed.addQueryField(this.createQueryFieldFromSchemaField(schemaField, this.fieldDescriptions));
        }
        Collections.sort(this.qed.getQueryFieldList(), new QueryFieldAlphaComparator());
    }

    protected void setAdditionalInfo(QueryEngineDescription qed) {
        ArrayList<String> info = new ArrayList<String>();
        info.add(this.additionalInfo);
        qed.setAdditionalInfoList(info);
    }

    protected void setSolrVersion(QueryEngineDescription qed) {
        String solrSpecVersion = "";
        Package p = SolrCore.class.getPackage();
        StringWriter tmp = new StringWriter();
        solrSpecVersion = p.getSpecificationVersion();
        if (null != solrSpecVersion) {
            try {
                XML.escapeCharData((String)solrSpecVersion, (Writer)tmp);
            }
            catch (IOException e2) {
                e2.printStackTrace();
            }
            solrSpecVersion = tmp.toString();
        }
        if (StringUtils.isNotBlank(solrSpecVersion)) {
            this.solrVersion = solrSpecVersion;
        }
        qed.setQueryEngineVersion(this.solrVersion);
    }

    protected void setSchemaVersionFromPropertiesFile(QueryEngineDescription qed) {
        File file = new File(this.schemaPropertiesPath);
        if (file.exists()) {
            try {
                List lines = FileUtils.readLines((File)file, (String)"UTF-8");
                for (Object object : lines) {
                    String version2;
                    String line = (String)object;
                    if (!line.startsWith(this.schemaVersionProperty) || !StringUtils.isNotBlank(version2 = StringUtils.substringAfter(line, this.schemaVersionProperty))) continue;
                    this.schemaVersion = version2;
                }
            }
            catch (IOException e2) {
                logger.error(e2.getMessage(), e2);
            }
        }
        qed.setQuerySchemaVersion(this.schemaVersion);
    }

    protected void loadSchemaFieldDescriptions() {
        this.fieldDescriptions = new HashMap<String, String>();
        File file = new File(this.descriptionPath);
        if (file.exists()) {
            try {
                List lines = FileUtils.readLines((File)file, (String)"UTF-8");
                for (Object object : lines) {
                    String line = (String)object;
                    String[] tokens = StringUtils.split(line, "=");
                    if (tokens.length != 2) continue;
                    String name = tokens[0].trim();
                    String description = tokens[1].trim();
                    this.fieldDescriptions.put(name, description);
                }
            }
            catch (IOException e2) {
                logger.error(e2.getMessage(), e2);
            }
        }
    }

    protected void setAdditionalInfo(String additionalInfo) {
        this.additionalInfo = additionalInfo;
    }

    protected void setDescriptionPath(String descriptionPath) {
        this.descriptionPath = descriptionPath;
    }

    protected void setSchemaProperitesPath(String schemaPropertiesPath) {
        this.schemaPropertiesPath = schemaPropertiesPath;
    }

    protected void setSchemaVersionProperty(String schemaVersionProperty) {
        this.schemaVersionProperty = schemaVersionProperty;
    }

    protected void setResponseKey(String responseKey) {
        this.responseKey = responseKey;
    }

    protected void setQueryEngineName(String queryEngineName) {
        this.queryEngineName = queryEngineName;
    }

    public String getDescription() {
        return "Solr Query Engine Description Handler.";
    }

    public String getVersion() {
        return "Version 1.0";
    }

    public String getSource() {
        return "https://repository.dataone.org/";
    }

    public URL[] getDocs() {
        try {
            return new URL[]{new URL("http://mule1.dataone.org/ArchitectureDocs-current/")};
        }
        catch (MalformedURLException ex) {
            return null;
        }
    }

    private QueryField createQueryFieldFromSchemaField(SchemaField field, Map<String, String> fieldDescriptions) {
        QueryField queryField = new QueryField();
        queryField.setName(field.getName());
        queryField.setType(field.getType().getTypeName());
        if (StringUtils.isNotBlank(fieldDescriptions.get(field.getName()))) {
            queryField.addDescription(fieldDescriptions.get(field.getName()));
        }
        queryField.setSearchable(field.indexed());
        queryField.setReturnable(field.stored());
        queryField.setMultivalued(field.multiValued());
        queryField.setSortable(this.isSortable(field));
        return queryField;
    }

    private boolean isSortable(SchemaField field) {
        String type = field.getType().getTypeName();
        return !"int".equals(type) && !"long".equals(type) && !"float".equals(type) && !"double".equals(type);
    }

    private class QueryFieldAlphaComparator
    implements Comparator<QueryField> {
        private QueryFieldAlphaComparator() {
        }

        @Override
        public int compare(QueryField arg0, QueryField arg1) {
            String field1Name = arg0.getName();
            String field2Name = arg1.getName();
            return field1Name.compareToIgnoreCase(field2Name);
        }
    }
}

