/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.impl.v2;

import java.text.ParseException;
import java.text.SimpleDateFormat;
import java.util.ArrayList;
import java.util.Calendar;
import java.util.Date;
import java.util.List;
import java.util.Timer;
import java.util.TimerTask;
import java.util.UUID;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.cn.hazelcast.HazelcastClientFactory;
import org.dataone.cn.ldap.DirContextProvider;
import org.dataone.cn.ldap.LDAPService;
import org.dataone.configuration.Settings;
import org.dataone.service.cn.impl.v2.CNIdentityLDAPImpl;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Group;
import org.dataone.service.types.v1.Identifier;
import org.dataone.service.types.v1.ObjectList;
import org.dataone.service.types.v1.Person;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;
import org.dataone.service.types.v2.SystemMetadata;

public class ReserveIdentifierService
extends LDAPService {
    public static Log log = LogFactory.getLog(ReserveIdentifierService.class);
    private static SimpleDateFormat dateFormat = new SimpleDateFormat("yyyyMMddHHmmss'Z'");
    private static Timer timer = null;
    private static CNIdentityLDAPImpl identityService = null;
    private static DirContextProvider dirContextProvider = DirContextProvider.getInstance();
    private static final String UUID_ID = "UUID";
    private static final String DOI = "DOI";
    private static final String ARK = "ARK";
    private static final int MAX_RETRY = 10;

    public ReserveIdentifierService() {
        this.setBase(Settings.getConfiguration().getString("reserveIdentifier.ldap.base"));
        identityService = new CNIdentityLDAPImpl();
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public Identifier reserveIdentifier(Session session, Identifier pid) throws IdentifierNotUnique, NotAuthorized, ServiceFailure {
        if (session == null) {
            throw new NotAuthorized("4180", "Session is required to reserve identifiers");
        }
        try {
            this.expireEntries(1);
        }
        catch (NamingException ne) {
            throw new ServiceFailure("4921", "Could not remove expired entries before checking reservation status");
        }
        Subject subject = session.getSubject();
        boolean ownedBySubject = false;
        SystemMetadata sysMeta = HazelcastClientFactory.getSystemMetadataMap().get(pid);
        if (sysMeta != null) {
            throw new IdentifierNotUnique("4210", "The given pid is already in use: " + pid.getValue());
        }
        ObjectList objects = null;
        try {
            objects = D1Client.getCN().listObjects(null, null, null, null, null, pid, null, null);
        }
        catch (BaseException e2) {
            log.warn("Exception looking up SID (may or may not be an issue): " + pid.getValue(), e2);
        }
        if (objects != null && objects.getTotal() > 0) {
            throw new IdentifierNotUnique("4210", "The given identifier is already in use: " + pid.getValue());
        }
        DirContext dirContext = null;
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new ServiceFailure("2490", ex.getMessage());
        }
        if (dirContext == null) {
            throw new ServiceFailure("2490", "Context is null. Unable to retrieve LDAP Directory Context from pool. Please try again.");
        }
        try {
            String dn = this.lookupDN(dirContext, pid);
            if (dn != null) {
                ownedBySubject = this.checkAttribute(dirContext, dn, "subject", subject.getValue());
                if (!ownedBySubject) {
                    String msg = "Identifier (" + pid.getValue() + ") is reserved and not owned by subject, " + subject.getValue();
                    log.warn(msg);
                    throw new NotAuthorized("4180", msg);
                }
                String msg = "The given pid: " + pid.getValue() + " has already been reserved by: " + subject.getValue();
                throw new IdentifierNotUnique("4210", msg);
            }
            boolean bl = this.addEntry(dirContext, subject, pid);
        }
        finally {
            dirContextProvider.returnDirContext(dirContext);
        }
        return pid;
    }

    public Identifier generateIdentifier(Session session, String scheme, String fragment) throws InvalidRequest, ServiceFailure, NotAuthorized {
        Identifier pid = new Identifier();
        boolean unique = false;
        if (null == scheme) {
            throw new InvalidRequest("4191", "The scheme parameter must be provided.");
        }
        int count = 0;
        while (!unique && count < 10) {
            ++count;
            if (!scheme.equals(UUID_ID)) {
                if (scheme.equals(DOI)) {
                    throw new InvalidRequest("4191", "Identifier scheme not supported.");
                }
                if (scheme.equals(ARK)) {
                    throw new InvalidRequest("4191", "Identifier scheme not supported.");
                }
                throw new InvalidRequest("4191", "Identifier scheme not supported.");
            }
            UUID uuid = UUID.randomUUID();
            pid.setValue("urn:uuid:" + uuid.toString());
            try {
                Identifier reservedID = this.reserveIdentifier(session, pid);
                unique = true;
            }
            catch (IdentifierNotUnique e2) {
                unique = false;
            }
        }
        if (!unique) {
            pid = null;
            throw new ServiceFailure("4210", "Unique identifier could not be generated.");
        }
        return pid;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean removeReservation(Session session, Identifier pid) throws NotAuthorized, NotFound, IdentifierNotUnique, InvalidToken, ServiceFailure, NotImplemented, InvalidRequest {
        Subject subject = session.getSubject();
        if (this.hasReservation(session, subject, pid)) {
            DirContext dirContext = null;
            try {
                dirContext = dirContextProvider.borrowDirContext();
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), ex);
                throw new ServiceFailure("2490", ex.getMessage());
            }
            if (dirContext == null) {
                throw new ServiceFailure("2490", "Context is null. Unable to retrieve LDAP Directory Context from pool. Please try again.");
            }
            try {
                String dn = this.lookupDN(dirContext, pid);
                if (dn != null) {
                    boolean result;
                    boolean bl = result = this.removeEntry(dirContext, dn);
                    return bl;
                }
            }
            finally {
                dirContextProvider.returnDirContext(dirContext);
            }
        }
        return false;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public boolean hasReservation(Session session, Subject subject, Identifier pid) throws NotFound, NotAuthorized, InvalidRequest, ServiceFailure {
        if (subject == null) {
            throw new InvalidRequest("4926", "subject parameter cannot be null");
        }
        if (pid == null) {
            throw new InvalidRequest("4926", "pid parameter cannot be null");
        }
        log.debug("hasReservation for Subject:" + subject.getValue() + " with pid: " + pid.getValue());
        try {
            this.expireEntries(1);
        }
        catch (NamingException ne) {
            throw new ServiceFailure("4921", "Could not remove expired entries before checking reservation status");
        }
        SubjectInfo subjectInfo = null;
        try {
            subjectInfo = identityService.getSubjectInfo(session, subject);
        }
        catch (Exception e2) {
            log.warn("Could not look up SubjectInfo for: " + subject.getValue());
        }
        log.debug("SubjectInfo retrieved");
        ArrayList<Subject> subjects = new ArrayList<Subject>();
        if (subjectInfo != null) {
            if (subjectInfo.getPersonList() != null) {
                for (Person p : subjectInfo.getPersonList()) {
                    subjects.add(p.getSubject());
                }
            }
            if (subjectInfo.getGroupList() != null) {
                for (Group g : subjectInfo.getGroupList()) {
                    subjects.add(g.getSubject());
                }
            }
        } else {
            subjects.add(subject);
        }
        boolean ownedBySubject = false;
        DirContext dirContext = null;
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new ServiceFailure("4921", ex.getMessage());
        }
        if (dirContext == null) {
            throw new ServiceFailure("4921", "Context is null. Unable to retrieve LDAP Directory Context from pool. Please try again.");
        }
        try {
            Subject s;
            String dn = this.lookupDN(dirContext, pid);
            log.debug("Looked up DN");
            if (dn == null) {
                String msg = "No reservation found for pid: " + pid.getValue();
                throw new NotFound("4923", msg);
            }
            Object msg = subjects.iterator();
            while (msg.hasNext() && !(ownedBySubject = this.checkAttribute(dirContext, dn, "subject", (s = (Subject)msg.next()).getValue()))) {
            }
            if (!ownedBySubject) {
                msg = "Reserved Identifier (" + pid.getValue() + ") is not owned by given subject[s]";
                throw new NotAuthorized("4924", (String)msg);
            }
        }
        finally {
            dirContextProvider.returnDirContext(dirContext);
        }
        return true;
    }

    private boolean addEntry(DirContext dirContext, Subject subject, Identifier pid) throws IdentifierNotUnique {
        BasicAttribute objClasses = new BasicAttribute("objectclass");
        objClasses.add("d1Reservation");
        Calendar now2 = Calendar.getInstance();
        String reservationId = "reservedIdentifier." + now2.getTimeInMillis();
        String dn = "reservationId=" + reservationId + "," + this.getBase();
        String created = dateFormat.format(now2.getTime());
        BasicAttribute idAttribute = new BasicAttribute("reservationId", reservationId);
        BasicAttribute subjectAttribute = new BasicAttribute("subject", subject.getValue());
        BasicAttribute identifierAttribute = new BasicAttribute("identifier", pid.getValue());
        BasicAttribute createdAttribute = new BasicAttribute("created", created);
        try {
            BasicAttributes orig = new BasicAttributes();
            orig.put(objClasses);
            orig.put(idAttribute);
            orig.put(subjectAttribute);
            orig.put(identifierAttribute);
            orig.put(createdAttribute);
            dirContext.createSubcontext(dn, (Attributes)orig);
            log.debug("Added entry " + dn);
        }
        catch (NameAlreadyBoundException e2) {
            String msg = "Entry " + dn + " already exists, no need to add";
            log.warn(msg, e2);
            throw new IdentifierNotUnique("0000", msg);
        }
        catch (NamingException e3) {
            log.error("Problem adding entry: " + dn, e3);
            return false;
        }
        return true;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public void expireEntries(int numberOfDays) throws NamingException, ServiceFailure {
        DirContext dirContext = null;
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new ServiceFailure("4921", ex.getMessage());
        }
        if (dirContext == null) {
            throw new ServiceFailure("4921", "Context is null. Unable to retrieve LDAP Directory Context from pool. Please try again.");
        }
        try {
            List<Identifier> identifiers = this.lookupReservedIdentifiers(dirContext);
            for (Identifier pid : identifiers) {
                String dn = this.lookupDN(dirContext, pid);
                String createdObj = (String)this.getAttributeValues(dirContext, dn, "created").get(0);
                Date created = null;
                try {
                    created = dateFormat.parse(createdObj);
                }
                catch (ParseException e2) {
                    log.error("(skipping) Could not parse created date for entry: " + dn, e2);
                    continue;
                }
                Calendar expires = Calendar.getInstance();
                expires.setTime(created);
                expires.add(5, numberOfDays);
                Calendar today = Calendar.getInstance();
                if (!expires.before(today)) continue;
                this.removeEntry(dirContext, dn);
            }
        }
        finally {
            dirContextProvider.returnDirContext(dirContext);
        }
    }

    public static void schedule(final ReserveIdentifierService service) {
        if (timer != null) {
            timer.cancel();
        }
        timer = new Timer(true);
        TimerTask task = new TimerTask(){

            @Override
            public void run() {
                try {
                    service.expireEntries(1);
                }
                catch (NamingException | ServiceFailure e2) {
                    log.error(e2.getMessage(), e2);
                }
            }
        };
        long period = 3600000L;
        timer.scheduleAtFixedRate(task, Calendar.getInstance().getTime(), period);
    }

    private List<Identifier> lookupReservedIdentifiers(DirContext dirContext) {
        ArrayList<Identifier> identifiers = new ArrayList<Identifier>();
        try {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            String searchCriteria = "(objectClass=d1Reservation)";
            NamingEnumeration<SearchResult> results = dirContext.search(this.getBase(), searchCriteria, ctls);
            while (results != null && results.hasMore()) {
                SearchResult si = results.next();
                String dn = si.getNameInNamespace();
                log.debug("Search result found for: " + dn);
                Attributes attributes = si.getAttributes();
                NamingEnumeration<? extends Attribute> values = attributes.getAll();
                while (values.hasMore()) {
                    Attribute attribute = values.next();
                    String attributeName = attribute.getID();
                    if (!attributeName.equalsIgnoreCase("identifier")) continue;
                    String attributeValue = (String)attribute.get();
                    Identifier pid = new Identifier();
                    pid.setValue(attributeValue);
                    identifiers.add(pid);
                }
            }
        }
        catch (Exception e2) {
            log.error("problem looking up identifiers", e2);
        }
        return identifiers;
    }

    private String lookupDN(DirContext dirContext, Identifier pid) {
        String dn = null;
        try {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            String escapedPid = pid.getValue();
            escapedPid = escapedPid.replace("\\", "\\5c");
            escapedPid = escapedPid.replace("*", "\\2a");
            escapedPid = escapedPid.replace("(", "\\28");
            escapedPid = escapedPid.replace(")", "\\29");
            escapedPid = escapedPid.replace("\u0000", "\\00");
            String searchCriteria = "(&(objectClass=d1Reservation)(identifier=" + escapedPid + "))";
            NamingEnumeration<SearchResult> results = dirContext.search(this.getBase(), searchCriteria, ctls);
            while (results != null && results.hasMore()) {
                SearchResult si = results.next();
                dn = si.getNameInNamespace();
                log.debug("Search result found for: " + dn);
                Attributes attributes = si.getAttributes();
                NamingEnumeration<? extends Attribute> values = attributes.getAll();
                while (values.hasMore()) {
                    Attribute attribute = values.next();
                    String attributeName = attribute.getID();
                    if (!attributeName.equalsIgnoreCase("identifier")) continue;
                    String attributeValue = (String)attribute.get();
                    if (!pid.getValue().equals(attributeValue)) continue;
                    results.close();
                    return dn;
                }
            }
        }
        catch (Exception e2) {
            log.error("problem looking up DN for identifier: " + pid.getValue(), e2);
        }
        return dn;
    }
}

