/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.service.cn.impl.v2;

import java.util.ArrayList;
import java.util.List;
import java.util.Set;
import javax.naming.InvalidNameException;
import javax.naming.NameAlreadyBoundException;
import javax.naming.NameNotFoundException;
import javax.naming.NamingEnumeration;
import javax.naming.NamingException;
import javax.naming.directory.Attribute;
import javax.naming.directory.Attributes;
import javax.naming.directory.BasicAttribute;
import javax.naming.directory.BasicAttributes;
import javax.naming.directory.DirContext;
import javax.naming.directory.ModificationItem;
import javax.naming.directory.SearchControls;
import javax.naming.directory.SearchResult;
import javax.naming.ldap.LdapName;
import org.apache.commons.logging.Log;
import org.apache.commons.logging.LogFactory;
import org.dataone.client.auth.CertificateManager;
import org.dataone.client.v2.itk.D1Client;
import org.dataone.cn.ldap.DirContextProvider;
import org.dataone.cn.ldap.LDAPService;
import org.dataone.configuration.Settings;
import org.dataone.service.cn.v2.CNIdentity;
import org.dataone.service.cn.v2.impl.NodeRegistryServiceImpl;
import org.dataone.service.exceptions.BaseException;
import org.dataone.service.exceptions.IdentifierNotUnique;
import org.dataone.service.exceptions.InvalidCredentials;
import org.dataone.service.exceptions.InvalidRequest;
import org.dataone.service.exceptions.InvalidToken;
import org.dataone.service.exceptions.NotAuthorized;
import org.dataone.service.exceptions.NotFound;
import org.dataone.service.exceptions.NotImplemented;
import org.dataone.service.exceptions.ServiceFailure;
import org.dataone.service.types.v1.Group;
import org.dataone.service.types.v1.NodeType;
import org.dataone.service.types.v1.Person;
import org.dataone.service.types.v1.Session;
import org.dataone.service.types.v1.Subject;
import org.dataone.service.types.v1.SubjectInfo;
import org.dataone.service.types.v1.util.AuthUtils;
import org.dataone.service.types.v2.Node;
import org.dataone.service.types.v2.NodeList;
import org.dataone.service.types.v2.util.ServiceMethodRestrictionUtil;

public class CNIdentityLDAPImpl
extends LDAPService
implements CNIdentity {
    public static Log log = LogFactory.getLog(CNIdentityLDAPImpl.class);
    private static final Integer DEFAULT_COUNT = new Integer(100);
    private String subtree = Settings.getConfiguration().getString("identity.ldap.subtree", "dc=dataone");
    private static DirContextProvider dirContextProvider = DirContextProvider.getInstance();
    private NodeRegistryServiceImpl nodeRegistryService = new NodeRegistryServiceImpl();

    public CNIdentityLDAPImpl() {
        this.setBase(Settings.getConfiguration().getString("identity.ldap.base"));
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subject createGroup(Session session, Group group) throws ServiceFailure, InvalidToken, NotAuthorized, NotImplemented, IdentifierNotUnique, InvalidRequest {
        Subject groupSubject = null;
        DirContext dirContext = null;
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new ServiceFailure("2490", ex.getMessage());
        }
        if (dirContext == null) {
            throw new ServiceFailure("2490", "Context is null. Unable to retrieve LDAP Directory Context from pool. Please try again.");
        }
        try {
            groupSubject = group.getSubject();
            String groupName = group.getGroupName();
            Subject groupAdmin = session.getSubject();
            String dn = groupSubject.getValue();
            dn = this.constructDn(dn);
            BasicAttribute objClasses = new BasicAttribute("objectclass");
            objClasses.add("top");
            objClasses.add("groupOfUniqueNames");
            objClasses.add("uidObject");
            String commonName = this.parseAttribute(dn, "cn");
            if (commonName == null) {
                commonName = groupName;
            }
            BasicAttribute cn = new BasicAttribute("cn", commonName);
            BasicAttribute uid = new BasicAttribute("uid", groupSubject.getValue());
            BasicAttribute desc = new BasicAttribute("description", groupName);
            BasicAttribute owners = new BasicAttribute("owner");
            String groupAdminDn = this.constructDn(groupAdmin.getValue());
            owners.add(groupAdminDn);
            if (group.getRightsHolderList() != null) {
                for (Subject rightsHolder : group.getRightsHolderList()) {
                    String ownerDn = this.constructDn(rightsHolder.getValue());
                    owners.add(ownerDn);
                }
            }
            BasicAttribute uniqueMembers = new BasicAttribute("uniqueMember");
            String adminDn = this.constructDn(groupAdmin.getValue());
            uniqueMembers.add(adminDn);
            if (group.getHasMemberList() != null) {
                for (Subject member : group.getHasMemberList()) {
                    String memberValue = member.getValue();
                    if (memberValue == null || memberValue.length() == 0) {
                        throw new InvalidRequest("2542", "Group member cannot be blank");
                    }
                    String memberDn = this.constructDn(memberValue);
                    boolean memberIsGroup = false;
                    try {
                        List<Object> values = this.getAttributeValues(dirContext, memberDn, "uniqueMember");
                        if (!values.isEmpty()) {
                            memberIsGroup = true;
                        }
                    }
                    catch (Exception e2) {
                        log.warn("Could not check whether member subject is a group: " + e2.getMessage());
                    }
                    if (memberIsGroup) {
                        throw new InvalidRequest("0000", "Group member: " + member.getValue() + " cannot be another Group");
                    }
                    uniqueMembers.add(memberDn);
                }
            }
            try {
                BasicAttributes orig = new BasicAttributes();
                orig.put(objClasses);
                orig.put(uid);
                orig.put(cn);
                orig.put(desc);
                orig.put(uniqueMembers);
                orig.put(owners);
                dirContext.createSubcontext(new LdapName(dn), (Attributes)orig);
                log.debug("Created group " + dn + ".");
            }
            catch (NameAlreadyBoundException e3) {
                String msg = "Group " + dn + " already exists";
                log.warn(msg);
                throw new IdentifierNotUnique("2400", msg);
            }
            catch (NamingException e4) {
                log.error(e4.getMessage(), e4);
                throw new ServiceFailure("2490", "Could not create group: " + e4.getMessage());
            }
        }
        finally {
            log.info("1 returning DirContext");
            dirContextProvider.returnDirContext(dirContext);
        }
        return groupSubject;
    }

    @Override
    public boolean updateGroup(Session session, Group group) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest {
        Subject groupSubject = group.getSubject();
        SubjectInfo originalGroup = this.getSubjectInfo(session, groupSubject);
        DirContext dirContext = null;
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new ServiceFailure("2490", ex.getMessage());
        }
        if (dirContext == null) {
            throw new ServiceFailure("2490", "Context is null. Unable to retrieve LDAP Directory Context from pool. Please try again.");
        }
        try {
            boolean canEdit = this.canEditGroup(dirContext, session, groupSubject);
            this.removeSubject(dirContext, groupSubject);
        }
        catch (NamingException e2) {
            log.error(e2.getMessage(), e2);
            ServiceFailure sf = new ServiceFailure("2490", "Could not update group: " + e2.getMessage());
            sf.initCause(e2);
            throw sf;
        }
        finally {
            log.info("2 returning DirContext");
            dirContextProvider.returnDirContext(dirContext);
        }
        BaseException createException = null;
        try {
            this.createGroup(session, group);
        }
        catch (IdentifierNotUnique e3) {
            createException = e3;
        }
        catch (InvalidRequest e4) {
            createException = e4;
        }
        if (createException != null) {
            try {
                this.createGroup(session, originalGroup.getGroup(0));
            }
            catch (IdentifierNotUnique e5) {
                ServiceFailure sf = new ServiceFailure("2490", "Could not recreate original group after update failed: " + e5.getMessage());
                sf.initCause(e5);
                throw sf;
            }
            if (createException instanceof InvalidRequest) {
                throw (InvalidRequest)createException;
            }
            ServiceFailure sf = new ServiceFailure("2490", "Could not update group: " + createException.getMessage());
            sf.initCause(createException);
            throw sf;
        }
        return true;
    }

    private boolean canEditGroup(DirContext dirContext, Session session, Subject groupSubject) throws NamingException, NotAuthorized {
        boolean canEdit = false;
        Set<Subject> sessionSubjects = AuthUtils.authorizedClientSubjects(session);
        String dn = this.constructDn(groupSubject.getValue());
        List<Object> owners = this.getAttributeValues(dirContext, dn, "owner");
        log.debug("owners.size=" + owners.size());
        block4: for (Subject user : sessionSubjects) {
            String sessionSubject = user.getValue();
            try {
                sessionSubject = CertificateManager.getInstance().standardizeDN(sessionSubject);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            log.debug("sessionSubject=" + sessionSubject);
            for (Object ownerObj : owners) {
                String owner = (String)ownerObj;
                log.debug("1. owner=" + owner);
                List<Object> uids = this.getAttributeValues(dirContext, owner, "uid");
                if (uids != null && uids.size() > 0) {
                    owner = uids.get(0).toString();
                }
                log.debug("2. owner=" + owner);
                try {
                    owner = CertificateManager.getInstance().standardizeDN(owner);
                }
                catch (IllegalArgumentException illegalArgumentException) {
                    // empty catch block
                }
                log.debug("3. owner=" + owner);
                log.debug(sessionSubject + " == " + owner + " ?: " + sessionSubject.equals(owner));
                if (!sessionSubject.equals(owner)) continue;
                canEdit = true;
                break block4;
            }
        }
        log.debug("canEdit=" + canEdit);
        if (!canEdit) {
            throw new NotAuthorized("2560", "Subject not in owner list for group");
        }
        return canEdit;
    }

    private boolean canEditPerson(Session session, Subject personSubject) throws NotAuthorized {
        boolean canEdit = false;
        Set<Subject> sessionSubjects = null;
        sessionSubjects = AuthUtils.authorizedClientSubjects(session);
        for (Subject user : sessionSubjects) {
            String sessionSubject = user.getValue();
            try {
                sessionSubject = CertificateManager.getInstance().standardizeDN(sessionSubject);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            String listedSubject = personSubject.getValue();
            try {
                listedSubject = CertificateManager.getInstance().standardizeDN(listedSubject);
            }
            catch (IllegalArgumentException illegalArgumentException) {
                // empty catch block
            }
            if (!sessionSubject.equals(listedSubject)) continue;
            canEdit = true;
            break;
        }
        if (!canEdit) {
            throw new NotAuthorized("4534", "Subject not allowed to edit subject");
        }
        return canEdit;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean mapIdentity(Session session, Subject primarySubject, Subject secondarySubject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest {
        int failureCount = 0;
        boolean isAllowed = false;
        Subject sessionSubject = null;
        DirContext dirContext = null;
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new ServiceFailure("2490", ex.getMessage());
        }
        if (dirContext == null) {
            throw new ServiceFailure("2490", "Context is null. Unable to retrieve LDAP Directory Context from pool. Please try again.");
        }
        try {
            List<Node> nodeList = null;
            try {
                nodeList = this.nodeRegistryService.listNodes().getNodeList();
            }
            catch (Exception e2) {
                log.warn("Using D1Client to look up nodeList from CN");
                nodeList = D1Client.getCN().listNodes().getNodeList();
            }
            sessionSubject = session.getSubject();
            isAllowed = ServiceMethodRestrictionUtil.isMethodAllowed(sessionSubject, nodeList, "CNIdentity", "mapIdentity");
            if (!isAllowed) {
                String sessionSubjectValue = null;
                if (sessionSubject != null) {
                    sessionSubjectValue = sessionSubject.getValue();
                }
                throw new NotAuthorized("2360", sessionSubjectValue + " is not allowed to map identities");
            }
            String dn = this.constructDn(primarySubject.getValue());
            String dn2 = this.constructDn(secondarySubject.getValue());
            try {
                dn = new LdapName(dn).toString();
                dn2 = new LdapName(dn2).toString();
            }
            catch (InvalidNameException e3) {
                throw new ServiceFailure("2390", "Could not properly escape DN: " + e3.getMessage());
            }
            boolean mappingExists = this.checkAttribute(dirContext, dn, "equivalentIdentity", secondarySubject.getValue());
            if (mappingExists) {
                throw new InvalidRequest("", "Account mapping already exists");
            }
            try {
                ModificationItem[] mods = null;
                BasicAttribute mod0 = null;
                String primaryId = primarySubject.getValue();
                String secondaryId = secondarySubject.getValue();
                try {
                    mods = new ModificationItem[1];
                    mod0 = new BasicAttribute("equivalentIdentity", secondaryId);
                    mods[0] = new ModificationItem(1, mod0);
                    dirContext.modifyAttributes(new LdapName(dn), mods);
                    log.debug("Successfully set equivalentIdentity on: " + primaryId + " for " + secondaryId);
                }
                catch (Exception e4) {
                    log.warn("Could not set equivalentIdentity on: " + primaryId + " for " + secondaryId, e4);
                    ++failureCount;
                }
                try {
                    mods = new ModificationItem[1];
                    mod0 = new BasicAttribute("equivalentIdentity", primaryId);
                    mods[0] = new ModificationItem(1, mod0);
                    dirContext.modifyAttributes(new LdapName(dn2), mods);
                    log.debug("Successfully set equivalentIdentity on: " + secondaryId + " for " + primaryId);
                }
                catch (Exception e5) {
                    log.warn("Could not set equivalentIdentity on: " + secondaryId + " for " + primaryId, e5);
                    ++failureCount;
                }
            }
            catch (Exception e6) {
                log.error(e6.getMessage(), e6);
                throw new ServiceFailure("2390", "Could not map identity: " + e6.getMessage());
            }
            if (failureCount > 1) {
                throw new ServiceFailure("2390", "Could not map identity, neither account could be edited.");
            }
        }
        finally {
            log.info("3 returning DirContext");
            dirContextProvider.returnDirContext(dirContext);
        }
        return true;
    }

    @Override
    public boolean requestMapIdentity(Session session, Subject secondarySubject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented, InvalidRequest {
        DirContext dirContext = null;
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new ServiceFailure("2490", ex.getMessage());
        }
        if (dirContext == null) {
            throw new ServiceFailure("2490", "Context is null. Unable to retrieve LDAP Directory Context from pool. Please try again.");
        }
        try {
            Subject primarySubject = session.getSubject();
            String dn = this.constructDn(primarySubject.getValue());
            String dn2 = this.constructDn(secondarySubject.getValue());
            boolean subjectExists = false;
            boolean confirmationRequested = false;
            try {
                subjectExists = this.checkAttribute(dirContext, dn, "cn", "*");
            }
            catch (Exception e2) {
                subjectExists = false;
            }
            if (subjectExists && (confirmationRequested = this.checkAttribute(dirContext, dn, "equivalentIdentityRequest", secondarySubject.getValue()))) {
                throw new InvalidRequest("", "Request already issued for: " + primarySubject.getValue() + " = " + secondarySubject.getValue());
            }
            confirmationRequested = this.checkAttribute(dirContext, dn2, "equivalentIdentityRequest", primarySubject.getValue());
            if (confirmationRequested) {
                throw new InvalidRequest("", "Request already issued for: " + secondarySubject.getValue() + " = " + primarySubject.getValue());
            }
            ModificationItem[] mods = null;
            BasicAttribute mod0 = null;
            mods = new ModificationItem[1];
            mod0 = new BasicAttribute("equivalentIdentityRequest", primarySubject.getValue());
            mods[0] = new ModificationItem(1, mod0);
            dirContext.modifyAttributes(new LdapName(dn2), mods);
            log.debug("Successfully set equivalentIdentityRequest on: " + secondarySubject.getValue() + " for " + primarySubject.getValue());
        }
        catch (Exception e3) {
            log.error(e3.getMessage(), e3);
            throw new ServiceFailure("2390", "Could not request map identity: " + e3.getMessage());
        }
        finally {
            log.info("4 returning DirContext");
            dirContextProvider.returnDirContext(dirContext);
        }
        return true;
    }

    @Override
    public boolean confirmMapIdentity(Session session, Subject secondarySubject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        block12: {
            DirContext dirContext = null;
            try {
                dirContext = dirContextProvider.borrowDirContext();
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), ex);
                throw new ServiceFailure("2490", ex.getMessage());
            }
            if (dirContext == null) {
                throw new ServiceFailure("2490", "Context is null. Unable to retrieve LDAP Directory Context from pool. Please try again.");
            }
            try {
                Subject primarySubject = session.getSubject();
                String dn = this.constructDn(primarySubject.getValue());
                String dn2 = this.constructDn(secondarySubject.getValue());
                boolean confirmationRequest = this.checkAttribute(dirContext, dn, "equivalentIdentityRequest", secondarySubject.getValue());
                ModificationItem[] mods = null;
                BasicAttribute mod0 = null;
                if (confirmationRequest) {
                    mods = new ModificationItem[2];
                    mod0 = new BasicAttribute("equivalentIdentity", secondarySubject.getValue());
                    mods[0] = new ModificationItem(1, mod0);
                    BasicAttribute mod1 = new BasicAttribute("equivalentIdentityRequest", secondarySubject.getValue());
                    mods[1] = new ModificationItem(3, mod1);
                    dirContext.modifyAttributes(new LdapName(dn), mods);
                    log.debug("Successfully set equivalentIdentity: " + primarySubject.getValue() + " = " + secondarySubject.getValue());
                    boolean subjectExists = false;
                    try {
                        subjectExists = this.checkAttribute(dirContext, dn2, "cn", "*");
                    }
                    catch (Exception e2) {
                        subjectExists = false;
                    }
                    if (subjectExists) {
                        mods = new ModificationItem[1];
                        mod0 = new BasicAttribute("equivalentIdentity", primarySubject.getValue());
                        mods[0] = new ModificationItem(1, mod0);
                        dirContext.modifyAttributes(new LdapName(dn2), mods);
                        log.debug("Successfully set reciprocal equivalentIdentity: " + secondarySubject.getValue() + " = " + primarySubject.getValue());
                    }
                    break block12;
                }
                throw new InvalidRequest("", "There is no identity mapping request to confim on: " + secondarySubject.getValue() + " for " + primarySubject.getValue());
            }
            catch (Exception e3) {
                log.error(e3.getMessage(), e3);
                throw new ServiceFailure("2390", "Could not confirm identity mapping: " + e3.getMessage());
            }
            finally {
                log.info("5 returning DirContext");
                dirContextProvider.returnDirContext(dirContext);
            }
        }
        return true;
    }

    @Override
    public Subject updateAccount(Session session, Person p) throws ServiceFailure, InvalidCredentials, NotImplemented, InvalidRequest, NotAuthorized {
        Subject subject = p.getSubject();
        this.canEditPerson(session, subject);
        DirContext dirContext = null;
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new ServiceFailure("2490", ex.getMessage());
        }
        if (dirContext == null) {
            throw new ServiceFailure("2490", "Context is null. Unable to retrieve LDAP Directory Context from pool. Please try again.");
        }
        try {
            String uidValue = subject.getValue();
            String dn = this.constructDn(uidValue);
            String commonName = this.parseAttribute(dn, "cn");
            if (commonName == null) {
                commonName = "";
                if (p.getGivenNameList() != null && !p.getGivenNameList().isEmpty()) {
                    commonName = commonName + p.getGivenName(0) + " ";
                }
                commonName = commonName + p.getFamilyName();
            }
            BasicAttribute uid = new BasicAttribute("uid", uidValue);
            BasicAttribute cn = new BasicAttribute("cn", commonName);
            BasicAttribute sn = new BasicAttribute("sn", p.getFamilyName());
            BasicAttribute givenNames = new BasicAttribute("givenName");
            for (String string : p.getGivenNameList()) {
                givenNames.add(string);
            }
            BasicAttribute mail = new BasicAttribute("mail");
            for (String email : p.getEmailList()) {
                mail.add(email);
            }
            BasicAttribute basicAttribute = new BasicAttribute("isVerified", Boolean.FALSE.toString().toUpperCase());
            ModificationItem[] mods = new ModificationItem[]{new ModificationItem(2, uid), new ModificationItem(2, cn), new ModificationItem(2, sn), new ModificationItem(2, givenNames), new ModificationItem(2, mail), new ModificationItem(2, basicAttribute)};
            dirContext.modifyAttributes(new LdapName(dn), mods);
            log.debug("Updated entry: " + subject.getValue());
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), e2);
            throw new ServiceFailure("4530", "Could not update account: " + e2.getMessage());
        }
        finally {
            log.info("6 returning DirContext");
            dirContextProvider.returnDirContext(dirContext);
        }
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public boolean verifyAccount(Session session, Subject subject) throws ServiceFailure, NotAuthorized, NotImplemented, InvalidToken, InvalidRequest {
        List<Node> nodeList = null;
        try {
            nodeList = this.nodeRegistryService.listNodes().getNodeList();
        }
        catch (Exception e2) {
            log.warn("Using D1Client to look up nodeList from CN");
            nodeList = D1Client.getCN().listNodes().getNodeList();
        }
        DirContext dirContext = null;
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new ServiceFailure("2490", ex.getMessage());
        }
        if (dirContext == null) {
            throw new ServiceFailure("2490", "Context is null. Unable to retrieve LDAP Directory Context from pool. Please try again.");
        }
        try {
            boolean isAllowed = false;
            Subject sessionSubject = null;
            if (session != null) {
                sessionSubject = session.getSubject();
                isAllowed = ServiceMethodRestrictionUtil.isMethodAllowed(sessionSubject, nodeList, "CNIdentity", "verifyAccount");
            }
            if (!isAllowed) {
                String sessionSubjectValue = null;
                if (sessionSubject != null) {
                    sessionSubjectValue = sessionSubject.getValue();
                }
                throw new NotAuthorized("4541", sessionSubjectValue + " is not allowed to verify identities");
            }
            try {
                String dn = this.constructDn(subject.getValue());
                ModificationItem[] mods = new ModificationItem[1];
                BasicAttribute isVerified = new BasicAttribute("isVerified", Boolean.TRUE.toString().toUpperCase());
                mods[0] = new ModificationItem(2, isVerified);
                dirContext.modifyAttributes(new LdapName(dn), mods);
                log.debug("Verified subject: " + subject.getValue());
            }
            catch (NamingException e3) {
                log.error(e3, e3);
                throw new ServiceFailure("4540", "Could not verify account: " + e3.getMessage());
            }
        }
        finally {
            log.info("7 returning DirContext");
            dirContextProvider.returnDirContext(dirContext);
        }
        return true;
    }

    public String constructDn(String subject) {
        String dn = subject;
        LdapName ldapName = null;
        try {
            ldapName = new LdapName(subject);
        }
        catch (InvalidNameException e2) {
            log.warn("Subject not a valid DN: " + subject);
            dn = "uid=" + subject + "," + this.subtree + "," + this.getBase();
            log.info("Created DN from subject: " + dn);
        }
        return dn;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public Subject registerAccount(Session session, Person p) throws ServiceFailure, IdentifierNotUnique, InvalidCredentials, NotImplemented, InvalidRequest {
        Subject subject = null;
        DirContext dirContext = null;
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new ServiceFailure("2490", ex.getMessage());
        }
        if (dirContext == null) {
            throw new ServiceFailure("2490", "Context is null. Unable to retrieve LDAP Directory Context from pool. Please try again.");
        }
        try {
            BasicAttribute objClasses = new BasicAttribute("objectclass");
            objClasses.add("top");
            objClasses.add("person");
            objClasses.add("organizationalPerson");
            objClasses.add("inetOrgPerson");
            objClasses.add("d1Principal");
            subject = p.getSubject();
            String uidValue = subject.getValue();
            String dn = this.constructDn(uidValue);
            try {
                this.constructTree(dirContext, dn);
            }
            catch (NamingException e2) {
                log.error(e2, e2);
                throw new ServiceFailure("4520", "Could not construct partial tree: " + e2.getMessage());
            }
            String commonName = this.parseAttribute(dn, "cn");
            if (commonName == null) {
                commonName = "";
                if (p.getGivenNameList() != null && !p.getGivenNameList().isEmpty()) {
                    commonName = commonName + p.getGivenName(0) + " ";
                }
                commonName = commonName + p.getFamilyName();
            }
            BasicAttribute uid = new BasicAttribute("uid", uidValue);
            BasicAttribute cn = new BasicAttribute("cn", commonName);
            BasicAttribute sn = new BasicAttribute("sn", p.getFamilyName());
            BasicAttribute givenNames = new BasicAttribute("givenName");
            for (String string : p.getGivenNameList()) {
                givenNames.add(string);
            }
            BasicAttribute mail = new BasicAttribute("mail");
            if (p.getEmailList() != null) {
                for (String email : p.getEmailList()) {
                    mail.add(email);
                }
            }
            BasicAttribute basicAttribute = new BasicAttribute("isVerified", Boolean.FALSE.toString().toUpperCase());
            try {
                BasicAttributes orig = new BasicAttributes();
                orig.put(objClasses);
                if (uid.getAll().hasMore()) {
                    orig.put(uid);
                }
                if (cn.getAll().hasMore()) {
                    orig.put(cn);
                }
                if (sn.getAll().hasMore()) {
                    orig.put(sn);
                }
                if (givenNames.getAll().hasMore()) {
                    orig.put(givenNames);
                }
                if (mail.getAll().hasMore()) {
                    orig.put(mail);
                }
                orig.put(basicAttribute);
                dirContext.createSubcontext(new LdapName(dn), (Attributes)orig);
                log.debug("Added entry " + dn);
            }
            catch (NameAlreadyBoundException e3) {
                String msg = "Entry " + dn + " already exists";
                log.warn(msg, e3);
                throw new IdentifierNotUnique("4521", msg);
            }
            catch (NamingException e4) {
                log.error(e4, e4);
                throw new ServiceFailure("4520", "Could not register account: " + e4.getMessage());
            }
        }
        finally {
            log.info("8 returning DirContext");
            dirContextProvider.returnDirContext(dirContext);
        }
        return subject;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    @Override
    public SubjectInfo getSubjectInfo(Session session, Subject subject) throws ServiceFailure, NotAuthorized, NotImplemented, NotFound {
        SubjectInfo subjectInfo;
        DirContext dirContext = null;
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new ServiceFailure("2490", ex.getMessage());
        }
        if (dirContext == null) {
            throw new ServiceFailure("2490", "Context is null. Unable to retrieve LDAP Directory Context from pool. Please try again.");
        }
        try {
            ArrayList<String> visitedSubjects = new ArrayList<String>();
            visitedSubjects.add(subject.getValue());
            subjectInfo = this.getSubjectInfo(dirContext, session, subject, true, visitedSubjects);
        }
        finally {
            log.info("9 returning DirContext");
            dirContextProvider.returnDirContext(dirContext);
        }
        return subjectInfo;
    }

    private SubjectInfo getSubjectInfo(DirContext dirContext, Session session, Subject subject, boolean recurse, List<String> visitedSubjects) throws ServiceFailure, NotAuthorized, NotImplemented, NotFound {
        boolean redact = this.shouldRedact(session);
        if (redact) {
            if (log.isDebugEnabled()) {
                if (session != null) {
                    log.debug("subjectInfo requested for: '" + subject.getValue() + "'");
                    log.debug("checking if redaction holds for the calling user: '" + session.getSubject().getValue() + "'");
                } else {
                    log.debug("session is null, we will redact email");
                }
            }
            if (session != null && session.getSubject().equals(subject)) {
                if (log.isDebugEnabled()) {
                    log.debug("subject MATCH. lifting redaction for the calling user: '" + session.getSubject().getValue() + "'");
                }
                redact = false;
            }
        }
        SubjectInfo subjectInfo = new SubjectInfo();
        String uidValue = subject.getValue();
        String dn = this.constructDn(uidValue);
        try {
            Attributes attributes = dirContext.getAttributes(new LdapName(dn));
            subjectInfo = this.processAttributes(dirContext, dn, attributes, recurse, false, redact, visitedSubjects);
            if (log.isDebugEnabled()) {
                log.debug("Retrieved SubjectList for: " + dn);
            }
        }
        catch (NameNotFoundException ex) {
            log.warn("Could not find: " + dn + " : in Ldap: " + ex.getMessage());
            throw new NotFound("4564", ex.getMessage());
        }
        catch (Exception e2) {
            String msg = "Problem looking up entry: " + dn + " : " + e2.getMessage();
            log.error(msg, e2);
            throw new ServiceFailure("4561", msg);
        }
        return subjectInfo;
    }

    protected List<Group> lookupGroups(DirContext dirContext, String personDn) throws ServiceFailure {
        boolean redact = false;
        SubjectInfo pList = new SubjectInfo();
        try {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            String searchCriteria = "(&(objectClass=groupOfUniqueNames)(uniqueMember=" + personDn + "))";
            NamingEnumeration<SearchResult> results = dirContext.search(this.getBase(), searchCriteria, ctls);
            ArrayList<String> visitedSubjects = new ArrayList<String>();
            while (results != null && results.hasMore()) {
                SearchResult si = results.next();
                String dn = si.getNameInNamespace();
                log.debug("Search result found for: " + dn);
                Attributes attrs = si.getAttributes();
                visitedSubjects.add(dn);
                SubjectInfo resultList = this.processAttributes(dirContext, dn, attrs, false, false, redact, visitedSubjects);
                if (resultList == null) continue;
                for (Group group : resultList.getGroupList()) {
                    pList.addGroup(group);
                }
            }
        }
        catch (Exception e2) {
            String msg = "Problem looking up group membership at base: " + this.getBase() + " : " + e2.getMessage();
            log.error(msg, e2);
            throw new ServiceFailure("2290", msg);
        }
        return pList.getGroupList();
    }

    @Override
    public SubjectInfo listSubjects(Session session, String query2, String status, Integer start, Integer count) throws ServiceFailure, InvalidToken, NotAuthorized, NotImplemented {
        boolean redact = this.shouldRedact(session);
        if (start == null || start < 0) {
            start = 0;
        }
        log.info("The start index is " + start);
        if (count == null || count <= 0) {
            log.info("The count is null or equal or less than 0===================");
            count = DEFAULT_COUNT;
            log.info("the count value is ===============" + count);
        } else {
            log.info("The count is not null or a positive number===================");
            log.info("the count value is ===============" + count);
        }
        SubjectInfo pList = new SubjectInfo();
        DirContext dirContext = null;
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new ServiceFailure("2490", ex.getMessage());
        }
        if (dirContext == null) {
            throw new ServiceFailure("2490", "Context is null. Unable to retrieve LDAP Directory Context from pool. Please try again.");
        }
        try {
            SearchControls ctls = new SearchControls();
            ctls.setSearchScope(2);
            String searchCriteria = "(|(objectClass=d1Principal)(objectClass=groupOfUniqueNames))";
            if (query2 != null && query2.length() > 0) {
                String queryCriteria = "(|(dn=*" + query2 + "*)(cn=*" + query2 + "*)(sn=*" + query2 + "*)(uid=*" + query2 + "*)(givenName=*" + query2 + "*)(mail=*" + query2 + "*))";
                searchCriteria = "(&" + queryCriteria + searchCriteria + ")";
            }
            if (status != null) {
                Boolean isVerified = new Boolean(status.equalsIgnoreCase("verified"));
                String statusCriteria = "(isVerified=" + isVerified.toString().toUpperCase() + ")";
                searchCriteria = "(&" + statusCriteria + searchCriteria + ")";
            }
            NamingEnumeration<SearchResult> results = dirContext.search(this.getBase(), searchCriteria, ctls);
            int index = 0;
            while (results != null && results.hasMore()) {
                SearchResult si = results.next();
                String dn = si.getNameInNamespace();
                log.debug("Search result found for: " + dn);
                Attributes attrs = si.getAttributes();
                ArrayList<String> visitedSubjects = new ArrayList<String>();
                visitedSubjects.add(dn);
                SubjectInfo resultList = this.processAttributes(dirContext, dn, attrs, false, false, redact, visitedSubjects);
                if (resultList == null) continue;
                for (Group group : resultList.getGroupList()) {
                    if (CNIdentityLDAPImpl.contains(pList.getGroupList(), group)) continue;
                    if (index >= start && index < count + start) {
                        pList.addGroup(group);
                    }
                    ++index;
                }
                for (Person person : resultList.getPersonList()) {
                    if (CNIdentityLDAPImpl.contains(pList.getPersonList(), person)) continue;
                    if (index >= start && index < count + start) {
                        pList.addPerson(person);
                    }
                    ++index;
                }
            }
        }
        catch (Exception e2) {
            String msg = "Problem listing entries at base: " + this.getBase() + " : " + e2.getMessage();
            log.error(msg, e2);
            throw new ServiceFailure("2290", msg);
        }
        finally {
            log.info("11 returning DirContext");
            dirContextProvider.returnDirContext(dirContext);
        }
        return pList;
    }

    private SubjectInfo processAttributes(DirContext dirContext, String name, Attributes attributes, boolean recurse, boolean equivalentIdentityRequestsOnly, boolean redact, List<String> visitedSubjects) throws Exception {
        SubjectInfo pList = new SubjectInfo();
        try {
            name = CertificateManager.getInstance().standardizeDN(name);
        }
        catch (IllegalArgumentException illegalArgumentException) {
            // empty catch block
        }
        if (!visitedSubjects.contains(name)) {
            visitedSubjects.add(name);
        }
        if (attributes == null) {
            return pList;
        }
        NamingEnumeration<?> objectClasses = attributes.get("objectClass").getAll();
        boolean isGroup = true;
        while (objectClasses.hasMore()) {
            String objectClass = (String)objectClasses.next();
            if (!objectClass.equalsIgnoreCase("d1Principal")) continue;
            isGroup = false;
            break;
        }
        NamingEnumeration<? extends Attribute> values = attributes.getAll();
        NamingEnumeration<?> items = null;
        if (isGroup) {
            Group group = new Group();
            Subject subject = new Subject();
            subject.setValue(name);
            group.setSubject(subject);
            while (values.hasMore()) {
                List<Object> uids;
                String subjectId;
                Attribute attribute = values.next();
                String attributeName = attribute.getID();
                String attributeValue = null;
                if (attributeName.equalsIgnoreCase("uid")) {
                    attributeValue = (String)attribute.get();
                    group.getSubject().setValue(attributeValue);
                    if (log.isDebugEnabled()) {
                        log.debug("Found attribute: " + attributeName + "=" + attributeValue);
                    }
                }
                if (attributeName.equalsIgnoreCase("cn")) {
                    if (log.isDebugEnabled()) {
                        log.debug("Found attribute: " + attributeName + "=" + attributeValue);
                    }
                    attributeValue = (String)attribute.get();
                    if (group.getGroupName() == null) {
                        group.setGroupName(attributeValue);
                    }
                }
                if (attributeName.equalsIgnoreCase("description")) {
                    attributeValue = (String)attribute.get();
                    group.setGroupName(attributeValue);
                    if (log.isDebugEnabled()) {
                        log.debug("Found attribute: " + attributeName + "=" + attributeValue);
                    }
                }
                if (attributeName.equalsIgnoreCase("owner")) {
                    items = attribute.getAll();
                    while (items.hasMore()) {
                        attributeValue = (String)items.next();
                        if (log.isDebugEnabled()) {
                            log.debug("Found attribute: " + attributeName + "=" + attributeValue);
                        }
                        subjectId = attributeValue;
                        uids = this.getAttributeValues(dirContext, attributeValue, "uid");
                        subjectId = uids != null && uids.size() > 0 ? uids.get(0).toString() : CertificateManager.getInstance().standardizeDN(attributeValue);
                        Subject owner = new Subject();
                        owner.setValue(subjectId);
                        group.addRightsHolder(owner);
                    }
                }
                if (!attributeName.equalsIgnoreCase("uniqueMember")) continue;
                items = attribute.getAll();
                while (items.hasMore()) {
                    SubjectInfo subjectInfo;
                    subjectId = attributeValue = (String)items.next();
                    uids = this.getAttributeValues(dirContext, attributeValue, "uid");
                    subjectId = uids != null && uids.size() > 0 ? uids.get(0).toString() : CertificateManager.getInstance().standardizeDN(attributeValue);
                    Subject member = new Subject();
                    member.setValue(subjectId);
                    group.addHasMember(member);
                    if (!recurse) continue;
                    Object var21_34 = null;
                    try {
                        subjectInfo = this.getSubjectInfo(dirContext, null, member, false, visitedSubjects);
                    }
                    catch (NotFound nf) {
                        log.warn("could not find member DN: " + subjectId);
                        continue;
                    }
                    if (subjectInfo.getPersonList() != null) {
                        for (Person p : subjectInfo.getPersonList()) {
                            if (CNIdentityLDAPImpl.contains(pList.getPersonList(), p)) continue;
                            pList.addPerson(p);
                        }
                    }
                    if (subjectInfo.getGroupList() == null) continue;
                    for (Group g : subjectInfo.getGroupList()) {
                        if (CNIdentityLDAPImpl.contains(pList.getGroupList(), g)) continue;
                        pList.addGroup(g);
                    }
                }
            }
            if (!CNIdentityLDAPImpl.contains(pList.getGroupList(), group)) {
                pList.getGroupList().add(0, group);
            }
        } else {
            Person person = new Person();
            Subject subject = new Subject();
            subject.setValue(name);
            person.setSubject(subject);
            while (values.hasMore()) {
                Attribute attribute = values.next();
                String attributeName = attribute.getID();
                String attributeValue = null;
                if (attributeName.equalsIgnoreCase("uid")) {
                    attributeValue = (String)attribute.get();
                    if (log.isDebugEnabled()) {
                        log.debug("Found attribute: " + attributeName + "=" + attributeValue);
                    }
                    person.getSubject().setValue(attributeValue);
                }
                if (attributeName.equalsIgnoreCase("cn")) {
                    attributeValue = (String)attribute.get();
                    if (log.isDebugEnabled()) {
                        log.debug("Found attribute: " + attributeName + "=" + attributeValue);
                    }
                }
                if (attributeName.equalsIgnoreCase("sn")) {
                    attributeValue = (String)attribute.get();
                    person.setFamilyName(attributeValue);
                    if (log.isDebugEnabled()) {
                        log.debug("Found attribute: " + attributeName + "=" + attributeValue);
                    }
                }
                if (attributeName.equalsIgnoreCase("mail") && !redact) {
                    items = attribute.getAll();
                    while (items.hasMore()) {
                        attributeValue = (String)items.next();
                        person.addEmail(attributeValue);
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Found attribute: " + attributeName + "=" + attributeValue);
                    }
                }
                if (attributeName.equalsIgnoreCase("givenName")) {
                    items = attribute.getAll();
                    while (items.hasMore()) {
                        attributeValue = (String)items.next();
                        person.addGivenName(attributeValue);
                        if (!log.isDebugEnabled()) continue;
                        log.debug("Found attribute: " + attributeName + "=" + attributeValue);
                    }
                }
                if (attributeName.equalsIgnoreCase("isVerified")) {
                    attributeValue = (String)attribute.get();
                    person.setVerified(Boolean.parseBoolean(attributeValue));
                    if (log.isDebugEnabled()) {
                        log.debug("Found attribute: " + attributeName + "=" + attributeValue);
                    }
                }
                if (equivalentIdentityRequestsOnly) {
                    if (!attributeName.equalsIgnoreCase("equivalentIdentityRequest")) continue;
                    items = attribute.getAll();
                    while (items.hasMore()) {
                        attributeValue = (String)items.next();
                        Subject equivalentIdentityRequest = new Subject();
                        equivalentIdentityRequest.setValue(attributeValue);
                        if (log.isDebugEnabled()) {
                            log.debug("Found attribute: " + attributeName + "=" + attributeValue);
                        }
                        if (!recurse || visitedSubjects != null && visitedSubjects.contains(equivalentIdentityRequest.getValue())) continue;
                        try {
                            SubjectInfo equivalentIdentityRequestInfo = this.getSubjectInfo(dirContext, null, equivalentIdentityRequest, false, visitedSubjects);
                            if (equivalentIdentityRequestInfo.getPersonList() != null) {
                                for (Person person2 : equivalentIdentityRequestInfo.getPersonList()) {
                                    if (CNIdentityLDAPImpl.contains(pList.getPersonList(), person2)) continue;
                                    pList.addPerson(person2);
                                }
                            }
                            if (equivalentIdentityRequestInfo.getGroupList() == null) continue;
                            for (Group group : equivalentIdentityRequestInfo.getGroupList()) {
                                if (CNIdentityLDAPImpl.contains(pList.getGroupList(), group)) continue;
                                pList.addGroup(group);
                            }
                        }
                        catch (NotFound e2) {
                            log.warn("No account found for equivalentIdentityRequest entry: " + equivalentIdentityRequest.getValue(), e2);
                            Person placeholderPerson = new Person();
                            placeholderPerson.setSubject(equivalentIdentityRequest);
                            placeholderPerson.addEmail("NA");
                            placeholderPerson.addGivenName("NA");
                            placeholderPerson.setFamilyName("NA");
                            if (CNIdentityLDAPImpl.contains(pList.getPersonList(), placeholderPerson)) continue;
                            pList.addPerson(placeholderPerson);
                        }
                    }
                    continue;
                }
                if (!attributeName.equalsIgnoreCase("equivalentIdentity")) continue;
                items = attribute.getAll();
                while (items.hasMore()) {
                    String equivalentIdentityName = attributeValue = (String)items.next();
                    try {
                        equivalentIdentityName = CertificateManager.getInstance().standardizeDN(equivalentIdentityName);
                    }
                    catch (IllegalArgumentException e2) {
                        // empty catch block
                    }
                    if (log.isDebugEnabled()) {
                        log.debug("Found attribute: " + attributeName + "=" + equivalentIdentityName);
                    }
                    Subject equivalentIdentity = new Subject();
                    equivalentIdentity.setValue(equivalentIdentityName);
                    person.addEquivalentIdentity(equivalentIdentity);
                    if (!recurse || visitedSubjects != null && visitedSubjects.contains(equivalentIdentity.getValue())) continue;
                    try {
                        SubjectInfo equivalentIdentityInfo = this.getSubjectInfo(dirContext, null, equivalentIdentity, true, visitedSubjects);
                        if (equivalentIdentityInfo.getPersonList() != null) {
                            for (Person p : equivalentIdentityInfo.getPersonList()) {
                                if (CNIdentityLDAPImpl.contains(pList.getPersonList(), p)) continue;
                                pList.addPerson(p);
                            }
                        }
                        if (equivalentIdentityInfo.getGroupList() == null) continue;
                        for (Group g2 : equivalentIdentityInfo.getGroupList()) {
                            if (CNIdentityLDAPImpl.contains(pList.getGroupList(), g2)) continue;
                            pList.addGroup(g2);
                        }
                    }
                    catch (NotFound e3) {
                        log.warn("No account found for equivalentIdentity entry: " + equivalentIdentity.getValue(), e3);
                        Person person3 = new Person();
                        person3.setSubject(equivalentIdentity);
                        person3.addEmail("NA");
                        person3.addGivenName("NA");
                        person3.setFamilyName("NA");
                        if (CNIdentityLDAPImpl.contains(pList.getPersonList(), person3)) continue;
                        pList.addPerson(person3);
                    }
                }
            }
            List<Group> groups = this.lookupGroups(dirContext, name);
            for (Group g : groups) {
                person.addIsMemberOf(g.getSubject());
                if (CNIdentityLDAPImpl.contains(pList.getGroupList(), g)) continue;
                pList.getGroupList().add(g);
            }
            if (!CNIdentityLDAPImpl.contains(pList.getPersonList(), person)) {
                pList.getPersonList().add(0, person);
            }
        }
        return pList;
    }

    protected boolean removeSubject(DirContext dirContext, Subject p) {
        String dn = this.constructDn(p.getValue());
        return super.removeEntry(dirContext, dn);
    }

    @Override
    public boolean denyMapIdentity(Session session, Subject secondarySubject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        DirContext dirContext = null;
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new ServiceFailure("2490", ex.getMessage());
        }
        if (dirContext == null) {
            throw new ServiceFailure("2490", "Context is null. Unable to retrieve LDAP Directory Context from pool. Please try again.");
        }
        try {
            Subject primarySubject = session.getSubject();
            String dn = this.constructDn(primarySubject.getValue());
            boolean confirmationRequest = this.checkAttribute(dirContext, dn, "equivalentIdentityRequest", secondarySubject.getValue());
            ModificationItem[] mods = null;
            BasicAttribute mod0 = null;
            if (!confirmationRequest) {
                throw new InvalidRequest("", "Identity mapping request has not been issued for: " + primarySubject.getValue() + " = " + secondarySubject.getValue());
            }
            mods = new ModificationItem[1];
            mod0 = new BasicAttribute("equivalentIdentityRequest", secondarySubject.getValue());
            mods[0] = new ModificationItem(3, mod0);
            dirContext.modifyAttributes(new LdapName(dn), mods);
            if (log.isDebugEnabled()) {
                log.debug("Successfully removed equivalentIdentityRequest on: " + primarySubject.getValue() + " for " + secondarySubject.getValue());
            }
        }
        catch (Exception e2) {
            log.error(e2.getMessage(), e2);
            throw new ServiceFailure("2390", "Could not deny the identity mapping: " + e2.getMessage());
        }
        finally {
            log.info("12 returning DirContext");
            dirContextProvider.returnDirContext(dirContext);
        }
        return true;
    }

    @Override
    public SubjectInfo getPendingMapIdentity(Session session, Subject subject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        boolean redact = this.shouldRedact(session);
        if (redact) {
            if (log.isDebugEnabled()) {
                if (session != null) {
                    log.debug("subjectInfo requested for: '" + subject.getValue() + "'");
                    log.debug("checking if redaction holds for the calling user: '" + session.getSubject().getValue() + "'");
                } else {
                    log.debug("session is null, we will redact email");
                }
            }
            if (session != null && session.getSubject().equals(subject)) {
                if (log.isDebugEnabled()) {
                    log.debug("subject MATCH. lifting redaction for the calling user: '" + session.getSubject().getValue() + "'");
                }
                redact = false;
            }
        }
        SubjectInfo subjectInfo = new SubjectInfo();
        String dn = subject.getValue();
        dn = this.constructDn(dn);
        DirContext dirContext = null;
        try {
            dirContext = dirContextProvider.borrowDirContext();
        }
        catch (Exception ex) {
            log.error(ex.getMessage(), ex);
            throw new ServiceFailure("2490", ex.getMessage());
        }
        if (dirContext == null) {
            throw new ServiceFailure("2490", "Context is null. Unable to retrieve LDAP Directory Context from pool. Please try again.");
        }
        try {
            Attributes attributes = dirContext.getAttributes(new LdapName(dn));
            ArrayList<String> visitedSubjects = new ArrayList<String>();
            visitedSubjects.add(dn);
            subjectInfo = this.processAttributes(dirContext, dn, attributes, true, true, redact, visitedSubjects);
            if (log.isDebugEnabled()) {
                log.debug("Retrieved SubjectList for: " + dn);
            }
        }
        catch (Exception e2) {
            String msg = "Problem looking up entry: " + dn + " : " + e2.getMessage();
            log.error(msg, e2);
            throw new ServiceFailure("4561", msg);
        }
        finally {
            log.info("13 returning DirContext");
            dirContextProvider.returnDirContext(dirContext);
        }
        return subjectInfo;
    }

    @Override
    public boolean removeMapIdentity(Session session, Subject secondarySubject) throws ServiceFailure, InvalidToken, NotAuthorized, NotFound, NotImplemented {
        block13: {
            DirContext dirContext = null;
            try {
                dirContext = dirContextProvider.borrowDirContext();
            }
            catch (Exception ex) {
                log.error(ex.getMessage(), ex);
                throw new ServiceFailure("2490", ex.getMessage());
            }
            if (dirContext == null) {
                throw new ServiceFailure("2490", "Context is null. Unable to retrieve LDAP Directory Context from pool. Please try again.");
            }
            try {
                Subject primarySubject = session.getSubject();
                String dn = this.constructDn(primarySubject.getValue());
                String dn2 = this.constructDn(secondarySubject.getValue());
                boolean mappingExists = this.checkAttribute(dirContext, dn, "equivalentIdentity", secondarySubject.getValue());
                boolean reciprocolMappingExists = this.checkAttribute(dirContext, dn2, "equivalentIdentity", primarySubject.getValue());
                ModificationItem[] mods = null;
                BasicAttribute mod0 = null;
                if (mappingExists || reciprocolMappingExists) {
                    if (mappingExists) {
                        mods = new ModificationItem[1];
                        mod0 = new BasicAttribute("equivalentIdentity", secondarySubject.getValue());
                        mods[0] = new ModificationItem(3, mod0);
                        dirContext.modifyAttributes(new LdapName(dn), mods);
                        if (log.isDebugEnabled()) {
                            log.debug("Successfully removed equivalentIdentity: " + primarySubject.getValue() + " = " + secondarySubject.getValue());
                        }
                    }
                    if (reciprocolMappingExists) {
                        mods = new ModificationItem[1];
                        mod0 = new BasicAttribute("equivalentIdentity", primarySubject.getValue());
                        mods[0] = new ModificationItem(3, mod0);
                        dirContext.modifyAttributes(new LdapName(dn2), mods);
                        if (log.isDebugEnabled()) {
                            log.debug("Successfully removed reciprocal equivalentIdentity: " + secondarySubject.getValue() + " = " + primarySubject.getValue());
                        }
                    }
                    break block13;
                }
                throw new InvalidRequest("", "There is no identity mapping between: " + primarySubject.getValue() + " and " + secondarySubject.getValue());
            }
            catch (Exception e2) {
                log.error(e2, e2);
                throw new ServiceFailure("2390", "Could not remove identity mapping: " + e2.getMessage());
            }
            finally {
                log.info("14 returning DirContext");
                dirContextProvider.returnDirContext(dirContext);
            }
        }
        return true;
    }

    private boolean shouldRedact(Session session) throws NotImplemented, ServiceFailure {
        if (session != null) {
            NodeList nodeList = null;
            try {
                nodeList = this.nodeRegistryService.listNodes();
            }
            catch (Exception e2) {
                log.warn("Using D1Client to look up nodeList from CN");
                nodeList = D1Client.getCN().listNodes();
            }
            for (Node node : nodeList.getNodeList()) {
                if (!node.getType().equals(NodeType.CN)) continue;
                for (Subject subject : node.getSubjectList()) {
                    if (!subject.getValue().equals(session.getSubject().getValue())) continue;
                    return false;
                }
            }
        }
        return true;
    }

    private static boolean contains(List<Person> personList, Person person) {
        for (Person p : personList) {
            if (!p.getSubject().equals(person.getSubject())) continue;
            return true;
        }
        return false;
    }

    private static boolean contains(List<Group> groupList, Group group) {
        for (Group g : groupList) {
            if (!g.getSubject().equals(group.getSubject())) continue;
            return true;
        }
        return false;
    }

    public static void main(String[] args) {
        try {
            Subject p = new Subject();
            p.setValue("cn=testGroup2,dc=cilogon,dc=org");
            CNIdentityLDAPImpl cNIdentityLDAPImpl = new CNIdentityLDAPImpl();
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }
}

