/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client.utils;

import java.io.Closeable;
import java.util.Map;
import java.util.WeakHashMap;
import java.util.concurrent.TimeUnit;
import org.apache.commons.io.IOUtils;
import org.apache.http.client.HttpClient;
import org.apache.http.conn.HttpClientConnectionManager;
import org.apache.log4j.Logger;

public class HttpConnectionMonitorService
extends Thread {
    WeakHashMap<HttpClientConnectionManager, String> connManStateMap = new WeakHashMap();
    WeakHashMap<HttpClient, String> clientStateMap = new WeakHashMap();
    private volatile boolean shutdown;
    static final Logger logger = Logger.getLogger(HttpConnectionMonitorService.class);

    public static HttpConnectionMonitorService getInstance() {
        return SingletonHolder.INSTANCE;
    }

    private HttpConnectionMonitorService() {
    }

    public void addMonitor(HttpClientConnectionManager cMan) {
        logger.warn("registering ConnectionManager...");
        this.connManStateMap.put(cMan, "REGISTERED");
    }

    public void addHttpClientMonitor(HttpClient client) {
        this.clientStateMap.put(client, "REGISTERED");
    }

    public void removeMonitor(HttpClientConnectionManager cMan) {
        this.connManStateMap.put(cMan, "REMOVED");
    }

    WeakHashMap<HttpClientConnectionManager, String> getMonitors() {
        return this.connManStateMap;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     * Enabled aggressive block sorting
     * Enabled unnecessary exception pruning
     * Enabled aggressive exception aggregation
     */
    @Override
    public void run() {
        logger.warn("Starting monitoring...");
        try {
            while (!this.shutdown) {
                HttpConnectionMonitorService httpConnectionMonitorService = this;
                synchronized (httpConnectionMonitorService) {
                    this.wait(5000L);
                    for (Map.Entry<HttpClientConnectionManager, String> n : this.connManStateMap.entrySet()) {
                        logger.debug("...calling closeExpire/IdleConnections...");
                        try {
                            n.getKey().closeExpiredConnections();
                            n.getKey().closeIdleConnections(30L, TimeUnit.SECONDS);
                        }
                        catch (NullPointerException e2) {
                            logger.info("ConnectionManager went out of scope.");
                        }
                    }
                }
            }
            return;
        }
        catch (InterruptedException ex) {
            this.shutdownConnectionManagers();
            Thread.currentThread().interrupt();
            return;
        }
        finally {
            logger.warn("Exiting HttpConnectionsMonitorService...");
        }
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    protected void shutdownConnectionManagers() {
        this.shutdown = true;
        HttpConnectionMonitorService httpConnectionMonitorService = this;
        synchronized (httpConnectionMonitorService) {
            logger.warn(String.format("Found %d registered ConnectionManagers to shutdown.", this.connManStateMap.size()));
            logger.warn("Shutting down all registered ConnectionManagers!!");
            for (Map.Entry<HttpClientConnectionManager, String> entry : this.connManStateMap.entrySet()) {
                entry.getKey().shutdown();
            }
            logger.warn("Shutting down all registered HttpClients!!");
            for (Map.Entry<Object, String> entry : this.clientStateMap.entrySet()) {
                if (!(entry.getKey() instanceof Closeable)) continue;
                IOUtils.closeQuietly((Closeable)((Closeable)entry.getKey()));
            }
            this.notifyAll();
        }
    }

    private static class SingletonHolder {
        public static final HttpConnectionMonitorService INSTANCE = new HttpConnectionMonitorService();
        public static final Thread theMonitorThread = new Thread(INSTANCE);

        private SingletonHolder() {
        }

        static {
            theMonitorThread.start();
            logger.warn("Starting monitor thread");
        }
    }
}

