/*
 * Decompiled with CFR 0.152.
 */
package org.dataone.client;

import java.util.Map;
import java.util.Set;
import java.util.TreeMap;
import java.util.TreeSet;
import org.dataone.client.D1Node;
import org.dataone.client.exception.ClientSideException;
import org.dataone.service.types.v1.NodeReference;
import org.dataone.service.types.v1.NodeType;

public abstract class NodeLocator {
    protected Map<NodeReference, D1Node> nodeMap = new TreeMap<NodeReference, D1Node>();

    public void putNode(NodeReference nodeRef, D1Node node) {
        if (node.getNodeId() == null) {
            node.setNodeId(nodeRef);
        }
        this.nodeMap.put(nodeRef, node);
    }

    public D1Node getNode(NodeReference nodeReference) throws ClientSideException {
        D1Node d1n = this.nodeMap.get(nodeReference);
        if (d1n == null) {
            throw new ClientSideException("No node found for " + nodeReference.getValue(), null);
        }
        return this.nodeMap.get(nodeReference);
    }

    public D1Node getNode(String baseUrl) throws ClientSideException {
        for (Map.Entry<NodeReference, D1Node> en : this.nodeMap.entrySet()) {
            if (!baseUrl.equals(en.getValue().getNodeBaseServiceUrl())) continue;
            return en.getValue();
        }
        throw new ClientSideException("No node found for " + baseUrl);
    }

    public Set<NodeReference> listD1Nodes() {
        return this.nodeMap.keySet();
    }

    public Set<NodeReference> listD1Nodes(NodeType nodeType) {
        TreeSet<NodeReference> resultSet = new TreeSet<NodeReference>();
        for (Map.Entry<NodeReference, D1Node> n : this.nodeMap.entrySet()) {
            if (n.getValue().getNodeType() != nodeType) continue;
            resultSet.add(n.getKey());
        }
        return resultSet;
    }

    public abstract D1Node getCNode() throws ClientSideException;
}

