/*
 * Decompiled with CFR 0.152.
 */
package org.apache.maven.artifact.transform;

import java.util.List;
import org.apache.maven.artifact.Artifact;
import org.apache.maven.artifact.repository.ArtifactRepository;
import org.apache.maven.artifact.repository.metadata.RepositoryMetadataResolutionException;
import org.apache.maven.artifact.repository.metadata.Versioning;
import org.apache.maven.artifact.resolver.ArtifactNotFoundException;
import org.apache.maven.artifact.resolver.ArtifactResolutionException;
import org.apache.maven.artifact.transform.AbstractVersionTransformation;

public class LatestArtifactTransformation
extends AbstractVersionTransformation {
    public void transformForResolve(Artifact artifact, List remoteRepositories, ArtifactRepository localRepository) throws ArtifactResolutionException, ArtifactNotFoundException {
        if ("LATEST".equals(artifact.getVersion())) {
            try {
                String version2 = this.resolveVersion(artifact, localRepository, remoteRepositories);
                if ("LATEST".equals(version2)) {
                    throw new ArtifactNotFoundException("Unable to determine the latest version", artifact);
                }
                artifact.setBaseVersion(version2);
                artifact.updateVersion(version2, localRepository);
            }
            catch (RepositoryMetadataResolutionException e2) {
                throw new ArtifactResolutionException(e2.getMessage(), artifact, e2);
            }
        }
    }

    public void transformForInstall(Artifact artifact, ArtifactRepository localRepository) {
    }

    public void transformForDeployment(Artifact artifact, ArtifactRepository remoteRepository, ArtifactRepository localRepository) {
    }

    protected String constructVersion(Versioning versioning, String baseVersion) {
        return versioning.getLatest();
    }
}

