/*
 * Decompiled with CFR 0.152.
 */
package net.oauth.client;

import java.io.BufferedInputStream;
import java.io.IOException;
import java.io.InputStream;
import net.oauth.OAuth;

public class ExcerptInputStream
extends BufferedInputStream {
    public static final byte[] ELLIPSIS = OAuth.encodeCharacters(" ...");
    private static final int LIMIT = 1024;
    private byte[] excerpt = new byte[1024 + ELLIPSIS.length];

    public ExcerptInputStream(InputStream in) throws IOException {
        super(in);
        int read;
        this.mark(1024);
        int total = 0;
        while ((read = this.read(this.excerpt, total, 1024 - total)) != -1 && (total += read) < 1024) {
        }
        if (total == 1024) {
            System.arraycopy(ELLIPSIS, 0, this.excerpt, total, ELLIPSIS.length);
        } else {
            byte[] tmp = new byte[total];
            System.arraycopy(this.excerpt, 0, tmp, 0, total);
            this.excerpt = tmp;
        }
        this.reset();
    }

    public byte[] getExcerpt() {
        return this.excerpt;
    }
}

