/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.mail;

import edu.uiuc.ncsa.security.core.Logable;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import java.io.BufferedReader;
import java.io.FileReader;
import java.io.IOException;
import java.util.Arrays;
import java.util.Map;
import java.util.Properties;
import javax.mail.Message;
import javax.mail.MessagingException;
import javax.mail.Service;
import javax.mail.Session;
import javax.mail.Transport;
import javax.mail.internet.AddressException;
import javax.mail.internet.InternetAddress;
import javax.mail.internet.MimeMessage;
import javax.naming.NamingException;

public class MailUtil
implements Logable {
    public static String LEFT_DELIMITER = "${";
    public static String REGEX_LEFT_DELIMITER = "\\$\\{";
    public static String RIGHT_DELIMITER = "}";
    public static String REGEX_RIGHT_DELIMITER = "\\}";
    public static String ADDRESS_SEPARATOR = ";";
    MailEnvironment mailEnvironment;
    String messageTemplate;
    String subjectTemplate;
    MyLoggingFacade myLogger;

    public Session getSession(Properties props) throws NamingException {
        return Session.getDefaultInstance(props);
    }

    public MailUtil(MyLoggingFacade myLogger) {
        this.myLogger = myLogger;
    }

    public MailUtil() {
        try {
            this.mailEnvironment = new MailEnvironment(false, null, -1, null, null, null, null, null, false, false);
        }
        catch (Throwable x) {
            this.warn("Error: could not create mail environment:" + x);
        }
    }

    public MailUtil(MailEnvironment me) {
        this.mailEnvironment = me;
    }

    public boolean isEnabled() {
        return this.getMailEnvironment().mailEnabled;
    }

    public MailEnvironment getMailEnvironment() {
        return this.mailEnvironment;
    }

    /*
     * WARNING - Removed try catching itself - possible behaviour change.
     */
    public synchronized boolean sendMessage(Map replacements) {
        Service tr = null;
        try {
            String protocol;
            this.info("Preparing to send mail notification");
            Properties props = new Properties();
            if (this.getMailEnvironment().isDebugOn()) {
                props.put("mail.debug", "true");
            }
            int defaultPort = this.getMailEnvironment().port;
            if (this.getMailEnvironment().useSSL) {
                protocol = "smtps";
                if (this.getMailEnvironment().starttls) {
                    props.put("mail.smtp.starttls.enable", "true");
                }
                defaultPort = defaultPort == -1 ? 465 : defaultPort;
            } else {
                protocol = "smtp";
                defaultPort = defaultPort == -1 ? 25 : defaultPort;
            }
            this.debug("preparing message with protocol=" + protocol + " on server=" + this.getMailEnvironment().server);
            props.put("mail.transport.protocol", protocol);
            props.put("mail." + protocol + ".host", this.getMailEnvironment().server);
            if (protocol.equals("smtp") && this.getMailEnvironment().from == null) {
                props.put("mail." + protocol + ".auth", "false");
            } else {
                this.debug("Using authorization for user " + this.getMailEnvironment().from);
                props.put("mail." + protocol + ".auth", "true");
            }
            Session session = this.getSession(props);
            tr = session.getTransport(protocol);
            tr.connect(this.getMailEnvironment().server, defaultPort, this.getMailEnvironment().from == null ? null : this.getMailEnvironment().from.toString(), this.getMailEnvironment().password);
            MimeMessage message = new MimeMessage(session);
            ((Message)message).setFrom(this.getMailEnvironment().from);
            ((Message)message).setRecipients(Message.RecipientType.TO, this.getMailEnvironment().recipients);
            ((Message)message).setSubject(this.replaceAll(this.getSubjectTemplate(), replacements));
            message.setContent(this.replaceAll(this.getMessageTemplate(), replacements), "text/plain");
            ((Transport)tr).sendMessage(message, this.getMailEnvironment().recipients);
            this.info("Mail notification sent to " + Arrays.toString(this.getMailEnvironment().recipients));
            boolean bl = true;
            return bl;
        }
        catch (Throwable throwable) {
            this.info("got exception sending message:");
            for (Object key : replacements.keySet()) {
                this.info("(" + key + "," + replacements.get(key.toString()) + ")");
            }
            throwable.printStackTrace();
            this.error("Sending mail failed. Continuing & message reads \"" + throwable.getMessage() + "\"");
            boolean bl = false;
            return bl;
        }
        finally {
            if (tr != null) {
                try {
                    tr.close();
                }
                catch (MessagingException e2) {
                    throw new GeneralException("Error: could not close java mail transport", e2);
                }
            }
        }
    }

    public String getMessageTemplate() throws IOException {
        if (this.messageTemplate == null) {
            this.messageTemplate = this.readTemplate(this.getMailEnvironment().messageTemplate);
        }
        return this.messageTemplate;
    }

    public void setMessageTemplate(String messageTemplate) {
        this.messageTemplate = messageTemplate;
    }

    public void setSubjectTemplate(String subjectTemplate) {
        this.subjectTemplate = subjectTemplate;
    }

    public String getSubjectTemplate() throws IOException {
        if (this.subjectTemplate == null) {
            this.subjectTemplate = this.readTemplate(this.getMailEnvironment().subjectTemplate);
        }
        return this.subjectTemplate;
    }

    protected String replaceAll(String template, Map replacements) {
        String out = template;
        if (out == null || out.length() == 0) {
            this.warn("Empty email template found, no message body or subject.");
        }
        int count = 0;
        for (Object key : replacements.keySet()) {
            ++count;
            String newKey = REGEX_LEFT_DELIMITER + key.toString() + REGEX_RIGHT_DELIMITER;
            if (!replacements.containsKey(key) || replacements.get(key) == null) continue;
            out = out.replaceAll(newKey, replacements.get(key).toString());
        }
        this.debug("made " + count + " replacements in the template");
        return out;
    }

    protected String readTemplate(String fileName) throws IOException {
        this.debug("reading in template file \"" + fileName + "\"");
        BufferedReader br = new BufferedReader(new FileReader(fileName));
        String out = null;
        String inLine = br.readLine();
        boolean isFirst = true;
        while (inLine != null) {
            if (!inLine.startsWith("#")) {
                if (isFirst) {
                    isFirst = false;
                    out = inLine;
                } else {
                    out = out + "\n" + inLine;
                }
            }
            inLine = br.readLine();
        }
        br.close();
        return out;
    }

    public MyLoggingFacade getMyLogger() {
        if (this.myLogger == null) {
            this.myLogger = new MyLoggingFacade(this.getClass().getName());
        }
        return this.myLogger;
    }

    public void setMyLogger(MyLoggingFacade myLogger) {
        this.myLogger = myLogger;
    }

    @Override
    public void debug(String x) {
        this.getMyLogger().debug(x);
    }

    @Override
    public void setDebugOn(boolean debugOn) {
        this.getMyLogger().setDebugOn(debugOn);
    }

    @Override
    public boolean isDebugOn() {
        return this.getMyLogger().isDebugOn();
    }

    @Override
    public void info(String x) {
        this.getMyLogger().info(x);
    }

    @Override
    public void warn(String x) {
        this.getMyLogger().warn(x);
    }

    @Override
    public void error(String x) {
        this.getMyLogger().error(x);
    }

    public static class MailEnvironment
    extends AbstractEnvironment {
        boolean starttls = false;
        boolean mailEnabled;
        boolean useSSL;
        InternetAddress from = null;
        String password;
        String server;
        int port = -1;
        String messageTemplate;
        String subjectTemplate;
        public InternetAddress[] recipients;

        public MailEnvironment(boolean mailEnabled) {
            this.mailEnabled = mailEnabled;
        }

        public MailEnvironment(boolean mailEnabled, String server, int port, String password, String from, String recipients, String messageTemplate, String subjectTemplate, boolean useSSL, boolean starttls) throws Exception {
            if (from != null) {
                this.from = new InternetAddress(from);
            }
            this.mailEnabled = mailEnabled;
            this.messageTemplate = messageTemplate;
            this.password = password;
            this.port = port;
            this.recipients = this.parseRecipients(recipients);
            this.server = server;
            this.subjectTemplate = subjectTemplate;
            this.useSSL = useSSL;
            this.starttls = starttls;
        }

        protected void init(boolean mailEnabled, String server, int port, String password, String from, String recipients, String messageTemplate, String subjectTemplate, boolean useSSL, boolean starttls) throws AddressException {
            this.mailEnabled = mailEnabled;
            this.info("Mail notifications " + (mailEnabled ? "en" : "dis") + "abled");
            this.useSSL = useSSL;
            this.starttls = starttls;
            if (from != null) {
                this.from = new InternetAddress(from);
            }
            if (subjectTemplate == null) {
                this.warn("Email: No subject template found, using default");
                subjectTemplate = "Something happened on the server.";
            } else {
                this.subjectTemplate = subjectTemplate;
            }
            this.server = server;
            if (messageTemplate == null) {
                this.warn("Email: No message template found, using default");
                messageTemplate = "Something happened on the server.";
            } else {
                this.messageTemplate = messageTemplate;
            }
            this.port = port;
            this.password = password;
            this.recipients = this.parseRecipients(recipients);
            this.debug("Email uses ssl: " + (useSSL ? "y" : "n") + ", server=" + server + ", sender=" + from);
        }

        protected InternetAddress[] parseRecipients(String x) throws AddressException {
            InternetAddress[] z = null;
            if (x != null) {
                String[] addresses = x.split(ADDRESS_SEPARATOR);
                z = new InternetAddress[addresses.length];
                int i = 0;
                for (String y : addresses) {
                    z[i++] = new InternetAddress(y);
                }
            }
            if (z == null) {
                this.warn("Warning: No recipients found for email notification");
                z = new InternetAddress[]{};
            }
            return z;
        }
    }
}

