/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.cli;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.ConfigurationLoader;
import edu.uiuc.ncsa.security.core.util.LoggerProvider;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.util.cli.Commands;
import edu.uiuc.ncsa.security.util.cli.InputLine;
import edu.uiuc.ncsa.security.util.configuration.ConfigUtil;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.configuration.tree.ConfigurationNode;
import org.apache.commons.lang.StringUtils;

public abstract class ConfigurableCommandsImpl
implements Commands {
    AbstractEnvironment environment;
    ConfigurationNode configurationNode;
    ConfigurationLoader<? extends AbstractEnvironment> loader;
    public static final String VERBOSE_OPTION = "v";
    public static final String VERBOSE_LONG_OPTION = "verbose";
    public static final String DEBUG_OPTION = "d";
    public static final String DEBUG_LONG_OPTION = "debug";
    public static final String LOG_FILE_OPTION = "log";
    public static final String LOG_FILE_LONG_OPTION = "logFile";
    public static final String HELP_OPTION = "h";
    public static final String HELP_LONG_OPTION = "help";
    public static final String CONFIG_FILE_OPTION = "cfg";
    public static final String CONFIG_FILE_LONG_OPTION = "configFile";
    public static final String USE_COMPONENT_OPTION = "use";
    public static final String USE_COMPONENT_LONG_OPTION = "use";
    public static final String DEFAULT_LOG_FILE = "log.xml";
    public static final String CONFIG_NAME_OPTION = "name";
    public static final String CONFIG_NAME_LONG_OPTION = "name";
    String configFile;
    CommandLine cmd = null;
    boolean debugOn = true;
    MyLoggingFacade logger;
    String logfileName;
    boolean verbose;

    protected ConfigurableCommandsImpl(MyLoggingFacade logger) {
        this.logger = logger;
    }

    protected boolean showHelp(InputLine inputLine) {
        return 1 < inputLine.size() && inputLine.getArg(1).equals("--help");
    }

    protected void say(String x) {
        System.out.println(x);
    }

    public void load(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.showLoadHelp();
            return;
        }
        String fileName = null;
        String configName = inputLine.getArg(1);
        fileName = 2 < inputLine.size() ? inputLine.getArg(2) : this.getConfigFile();
        this.say("loading configuration from " + fileName + ", named " + configName);
        this.info("loading configuration from " + fileName + ", named " + configName);
        this.loadConfig(fileName, configName);
        this.say("done!");
    }

    protected void showLoadHelp() {
        this.say("loads a configuration from the file. The options are");
        this.say("   load configName - Loads the named configuration from the currently active configuration file.");
        this.say("   load configName fileName - loads the configuration named \"configName\" from the fully qualified name of the file and sets it active");
        this.say("\nExample\n");
        this.say("   load default /var/www/config/config.xml \n");
        this.say("loads the configuration named \"default\" from the file named \"config.xml\" in the directory \"/var/www/config\"\n");
        this.say("Note that after a oad, any new configuration file becomes the default for future store operations.");
    }

    public AbstractEnvironment getEnvironment() throws Exception {
        if (this.environment == null) {
            this.environment = this.getLoader().load();
        }
        return this.environment;
    }

    public void setEnvironment(AbstractEnvironment environment) {
        this.environment = environment;
    }

    public abstract String getComponentName();

    public abstract ConfigurationLoader<? extends AbstractEnvironment> getLoader();

    public ConfigurationNode getConfigurationNode() {
        return this.configurationNode;
    }

    public void setConfigurationNode(ConfigurationNode configurationNode) {
        this.configurationNode = configurationNode;
    }

    public void initialize() {
        if (this.getConfigFile() == null || this.getConfigFile().length() == 0) {
            this.say("Warning: no configuration file specified. type in 'load --help' to see how to load one.");
            return;
        }
        String cfgName = null;
        if (this.hasOption("name", "name")) {
            cfgName = this.getCommandLine().getOptionValue("name");
        }
        LoggerProvider loggerProvider = null;
        loggerProvider = this.hasOption(LOG_FILE_OPTION, LOG_FILE_LONG_OPTION) ? new LoggerProvider(this.getLogfileName(), "cli logger", 1, 1000000, false, true, true) : new LoggerProvider(DEFAULT_LOG_FILE, "cli logger", 1, 1000000, false, true, true);
        this.logger = loggerProvider.get();
        this.info("Config name = " + cfgName);
        if (cfgName == null) {
            this.info("no named for a configuration given");
        } else {
            this.info("getting named configuration \"" + cfgName + "\"");
        }
        try {
            this.loadConfig(this.getConfigFile(), cfgName);
        }
        catch (Exception x) {
            if (x instanceof RuntimeException) {
                throw (RuntimeException)x;
            }
            throw new GeneralException("Error initializing CLI:" + x.getMessage(), x);
        }
    }

    protected void loadConfig(String filename, String configName) throws Exception {
        if (filename == null) {
            throw new MyConfigurationException("Error: no configuration file specified");
        }
        this.setConfigurationNode(ConfigUtil.findConfiguration(filename, configName, this.getComponentName()));
        this.setEnvironment(null);
        this.getEnvironment();
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    protected void parseCommandLine(String[] args) throws UnrecognizedOptionException, ParseException {
        BasicParser clp = new BasicParser();
        try {
            this.cmd = clp.parse(this.getOptions(), args);
        }
        catch (UnrecognizedOptionException ux) {
            this.say("Error: unrecognized option  + " + ux.getMessage());
            this.say("Invoke with -help for more");
            if (this.isVerbose()) {
                ux.printStackTrace();
            }
            throw ux;
        }
        catch (ParseException e2) {
            this.say("Error: could not parse a command line argument:" + e2.getMessage());
            if (this.isVerbose()) {
                e2.printStackTrace();
            }
            throw e2;
        }
    }

    public CommandLine getCommandLine() {
        return this.cmd;
    }

    protected boolean getOptions(String[] args) throws Exception {
        this.getOptions();
        if (args.length == 0) {
            return false;
        }
        for (String z : args) {
            if (!z.toLowerCase().endsWith(HELP_LONG_OPTION)) continue;
            return false;
        }
        this.parseCommandLine(args);
        if (this.hasOption(HELP_OPTION, HELP_LONG_OPTION)) {
            return false;
        }
        this.setVerbose(false);
        if (this.hasOption(VERBOSE_OPTION, VERBOSE_LONG_OPTION)) {
            this.setVerbose(true);
        }
        this.setDebugOn(false);
        if (this.hasOption(DEBUG_OPTION, DEBUG_LONG_OPTION)) {
            this.setDebugOn(true);
        }
        if (this.hasOption(LOG_FILE_OPTION, LOG_FILE_LONG_OPTION)) {
            this.setLogfileName(this.getCommandLine().getOptionValue(LOG_FILE_LONG_OPTION));
        }
        if (this.hasOption(CONFIG_FILE_OPTION, CONFIG_FILE_LONG_OPTION)) {
            this.setConfigFile(this.getCommandLine().getOptionValue(CONFIG_FILE_OPTION));
        }
        return true;
    }

    @Override
    public boolean isDebugOn() {
        return this.debugOn;
    }

    @Override
    public void setDebugOn(boolean setOn) {
        this.debugOn = setOn;
    }

    protected boolean hasOption(String shortForm, String longForm) {
        return this.getCommandLine().hasOption(shortForm) || this.getCommandLine().hasOption(longForm);
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(HELP_OPTION, HELP_LONG_OPTION, false, "Display the help message.");
        options.addOption(DEBUG_OPTION, DEBUG_LONG_OPTION, false, "Enable/disable debug mode.");
        options.addOption(VERBOSE_OPTION, VERBOSE_LONG_OPTION, false, "Set verbose mode on");
        options.addOption(CONFIG_FILE_OPTION, CONFIG_FILE_LONG_OPTION, true, "Set the configuration file");
        options.addOption("name", "name", true, "Set the name of the configuration");
        options.addOption(LOG_FILE_OPTION, LOG_FILE_LONG_OPTION, true, "Set the log file");
        options.addOption("use", "use", true, "Specify the component to use.");
        return options;
    }

    public void setMyLogger(MyLoggingFacade myLoggingFacade) {
        this.logger = myLoggingFacade;
    }

    public MyLoggingFacade getMyLogger() {
        if (this.logger == null) {
            LoggerProvider loggerProvider = new LoggerProvider(DEFAULT_LOG_FILE, "cli logger", 1, 1000000, false, true, true);
            this.logger = loggerProvider.get();
        }
        return this.logger;
    }

    @Override
    public void debug(String x) {
        if (this.isDebugOn()) {
            this.say(x);
        }
        this.getMyLogger().debug(x);
    }

    @Override
    public void info(String x) {
        if (this.isVerbose()) {
            this.say(x);
        }
        this.getMyLogger().info(x);
    }

    @Override
    public void warn(String x) {
        if (this.isVerbose()) {
            this.say(x);
        }
        this.getMyLogger().warn(x);
    }

    @Override
    public void error(String x) {
        if (this.isVerbose()) {
            this.say(x);
        }
        this.getMyLogger().error(x);
    }

    public String getLogfileName() {
        return this.logfileName;
    }

    public void setLogfileName(String logfileName) {
        this.logfileName = logfileName;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected String padLineWithBlanks(String x, int width) {
        String xx = StringUtils.rightPad(x, width, " ");
        return xx;
    }

    public abstract void useHelp();

    public boolean use(InputLine inputLine) throws Exception {
        if (this.showHelp(inputLine)) {
            this.useHelp();
            return true;
        }
        if (1 == inputLine.size()) {
            this.say("Sorry, you need to give the name of the component to invoke it.");
            return true;
        }
        return false;
    }
}

