/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.cli;

import edu.uiuc.ncsa.security.util.cli.MalformedCommandException;
import java.util.Vector;

public final class CommandLineTokenizer {
    public static void main(String[] args) {
        CommandLineTokenizer clt = new CommandLineTokenizer();
        String[] test = new String[]{"     ", "hash 1024k", "GEt blarf.txt warf.txt", "put \"wo of\" \"blar g\""};
        try {
            for (int i = 0; i < test.length; ++i) {
                Vector v = clt.tokenize(test[i]);
                System.out.println("elements for argument " + i);
                for (int j = 0; j < v.size(); ++j) {
                    System.out.println("   " + v.elementAt(j));
                }
                System.out.println("-------------------");
            }
        }
        catch (Exception e2) {
            e2.printStackTrace();
        }
    }

    Vector tokenize(String cl) throws MalformedCommandException {
        boolean isQuotePending = false;
        String cl2 = cl.trim();
        Vector<String> outV = new Vector<String>();
        char[] c = cl2.toCharArray();
        StringBuffer currentArg = new StringBuffer();
        for (int i = 0; i < c.length; ++i) {
            if (isQuotePending) {
                if (c[i] == '\"') {
                    outV.addElement(currentArg.toString());
                    currentArg = new StringBuffer();
                    isQuotePending = false;
                    continue;
                }
                currentArg.append(c[i]);
                continue;
            }
            if (c[i] == ' ' || c[i] == '\"') {
                outV.addElement(currentArg.toString());
                currentArg = new StringBuffer();
                isQuotePending = c[i] == '\"';
                continue;
            }
            currentArg.append(c[i]);
        }
        outV.addElement(currentArg.toString());
        if (outV.size() > 0) {
            String temp = (String)outV.elementAt(0);
            temp = temp.toLowerCase();
            outV.setElementAt(temp, 0);
            for (int j = 0; j < outV.size(); ++j) {
                temp = (String)outV.elementAt(j);
                if (temp != null && temp.length() != 0) continue;
                outV.removeElementAt(j);
                --j;
            }
        }
        isQuotePending = false;
        return outV;
    }
}

