/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.util.cli;

import edu.uiuc.ncsa.security.core.Logable;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.MyConfigurationException;
import edu.uiuc.ncsa.security.core.util.AbstractEnvironment;
import edu.uiuc.ncsa.security.core.util.ConfigurationLoader;
import edu.uiuc.ncsa.security.core.util.LoggerProvider;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.util.configuration.ConfigUtil;
import java.io.BufferedReader;
import java.io.IOException;
import java.io.InputStreamReader;
import org.apache.commons.cli.BasicParser;
import org.apache.commons.cli.CommandLine;
import org.apache.commons.cli.Options;
import org.apache.commons.cli.ParseException;
import org.apache.commons.cli.UnrecognizedOptionException;
import org.apache.commons.configuration.tree.ConfigurationNode;

public abstract class CLITool
implements Logable {
    public static final String VERBOSE_OPTION = "v";
    public static final String VERBOSE_LONG_OPTION = "verbose";
    public static final String DEBUG_OPTION = "d";
    public static final String DEBUG_LONG_OPTION = "debug";
    public static final String LOG_FILE_OPTION = "log";
    public static final String LOG_FILE_LONG_OPTION = "logFile";
    public static final String HELP_OPTION = "h";
    public static final String HELP_LONG_OPTION = "help";
    public static final String CONFIG_FILE_OPTION = "cfg";
    public static final String CONFIG_FILE_LONG_OPTION = "configFile";
    public static final String DEFAULT_LOG_FILE = "log.xml";
    public static final String CONFIG_NAME_OPTION = "name";
    public static final String CONFIG_NAME_LONG_OPTION = "name";
    public static final int CONFIG_NAME_ACTION = 100;
    public static final int NO_ACTION = 0;
    boolean verbose = false;
    boolean debugOn = true;
    String logfileName = "log.xml";
    AbstractEnvironment environment;
    BufferedReader bufferedReader;
    ConfigurationNode configurationNode;
    String configFile;
    CommandLine cmd = null;
    int action;
    MyLoggingFacade logger;

    public AbstractEnvironment getEnvironment() throws Exception {
        if (this.environment == null) {
            this.environment = this.getLoader().load();
        }
        return this.environment;
    }

    public void setEnvironment(AbstractEnvironment environment) {
        this.environment = environment;
    }

    public abstract String getComponentName();

    public abstract ConfigurationLoader<? extends AbstractEnvironment> getLoader() throws Exception;

    public BufferedReader getBufferedReader() {
        if (this.bufferedReader == null) {
            this.bufferedReader = new BufferedReader(new InputStreamReader(System.in));
        }
        return this.bufferedReader;
    }

    public void setBufferedReader(BufferedReader bufferedReader) {
        this.bufferedReader = bufferedReader;
    }

    protected String readline() throws IOException {
        return this.getBufferedReader().readLine();
    }

    public abstract void doIt() throws Exception;

    protected ConfigurationNode getConfigurationNode() {
        return this.configurationNode;
    }

    protected void setConfigurationNode(ConfigurationNode configurationNode) {
        this.configurationNode = configurationNode;
    }

    public void initialize() throws Exception {
        if (this.getConfigFile() == null) {
            throw new MyConfigurationException("Error: no configuration file");
        }
        if (this.getConfigFile().length() == 0) {
            throw new MyConfigurationException("Error:No configuration found.");
        }
        String cfgName = null;
        if (this.hasOption("name", "name")) {
            cfgName = this.getCommandLine().getOptionValue("name");
        }
        this.setConfigurationNode(ConfigUtil.findConfiguration(this.getConfigFile(), cfgName, this.getComponentName()));
    }

    public abstract void help();

    public static void defaultHelp(boolean printHeader) {
        if (printHeader) {
            CLITool.say("Standard options are:");
        }
        CLITool.say("  -log (-logFile) -- set the name of the log file. Default is \"log.xml\" in the invocation directory.");
        CLITool.say("  -cfg (-configFile) -- the configuration file for this application.");
        CLITool.say("  -v (-verbose) -- set verbose on. This sends output to the console.");
        CLITool.say("  -d (-debug) -- set debug on. This will print out extra messages \n\t\t\tduring execution to the log file (and console, if verbose is enabled)");
        CLITool.say("  -h (-help) -- this message");
    }

    public String getConfigFile() {
        return this.configFile;
    }

    public void setConfigFile(String configFile) {
        this.configFile = configFile;
    }

    public String getLogfileName() {
        return this.logfileName;
    }

    public void setLogfileName(String logfileName) {
        this.logfileName = logfileName;
    }

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    protected boolean getOptions(String[] args) throws Exception {
        this.getOptions();
        if (args.length == 0) {
            this.help();
            return false;
        }
        for (String z : args) {
            if (!z.toLowerCase().endsWith(HELP_LONG_OPTION)) continue;
            this.help();
            return false;
        }
        this.parseCommandLine(args);
        if (this.hasOption(HELP_OPTION, HELP_LONG_OPTION)) {
            this.help();
            return false;
        }
        this.setVerbose(false);
        if (this.hasOption(VERBOSE_OPTION, VERBOSE_LONG_OPTION)) {
            this.setVerbose(true);
        }
        this.setDebugOn(false);
        if (this.hasOption(DEBUG_OPTION, DEBUG_LONG_OPTION)) {
            this.setDebugOn(true);
        }
        if (this.hasOption(LOG_FILE_OPTION, LOG_FILE_LONG_OPTION)) {
            this.setLogfileName(this.getCommandLine().getOptionValue(LOG_FILE_LONG_OPTION));
        }
        if (this.hasOption(CONFIG_FILE_OPTION, CONFIG_FILE_LONG_OPTION)) {
            this.setConfigFile(this.getCommandLine().getOptionValue(CONFIG_FILE_OPTION));
        }
        return true;
    }

    protected boolean hasOption(String shortForm, String longForm) {
        return this.getCommandLine().hasOption(shortForm) || this.getCommandLine().hasOption(longForm);
    }

    protected void parseCommandLine(String[] args) {
        BasicParser clp = new BasicParser();
        try {
            this.cmd = clp.parse(this.getOptions(), args);
        }
        catch (UnrecognizedOptionException ux) {
            String err = "Error: unrecognized option  + " + ux.getMessage();
            CLITool.say(err);
            CLITool.say("Invoke with -help for more");
            if (this.isVerbose()) {
                ux.printStackTrace();
            }
            throw new GeneralException(err, ux);
        }
        catch (ParseException e2) {
            String err = "Error: could not parse a command line argument:" + e2.getMessage();
            CLITool.say(err);
            if (this.isVerbose()) {
                e2.printStackTrace();
            }
            throw new GeneralException(err, e2);
        }
    }

    public void setCommandLine(String[] args) {
        this.parseCommandLine(args);
    }

    public CommandLine getCommandLine() {
        return this.cmd;
    }

    public int getAction() {
        return this.action;
    }

    public void setAction(int action) {
        this.action = action;
    }

    protected void checkAction(String flag, String longFlag, int action) {
        if (this.getCommandLine().hasOption(flag) || this.getCommandLine().hasOption(longFlag)) {
            if (this.getAction() != 0) {
                throw new RuntimeException("Error: attempted to reset the action");
            }
            this.setAction(action);
        }
    }

    protected Options getOptions() {
        Options options = new Options();
        options.addOption(HELP_OPTION, HELP_LONG_OPTION, false, "Display the help message.");
        options.addOption(DEBUG_OPTION, DEBUG_LONG_OPTION, false, "Enable/disable debug mode.");
        options.addOption(VERBOSE_OPTION, VERBOSE_LONG_OPTION, false, "Set verbose mode on");
        options.addOption(CONFIG_FILE_OPTION, CONFIG_FILE_LONG_OPTION, true, "Set the configuration file");
        options.addOption("name", "name", true, "Set the name of the configuration");
        options.addOption(LOG_FILE_OPTION, LOG_FILE_LONG_OPTION, true, "Set the log file");
        return options;
    }

    public void sayv(String x) {
        this.info(x);
    }

    public static void say(String x) {
        System.out.println(x);
    }

    public void say2(String x) {
        System.out.print(x);
    }

    public void setMyLogger(MyLoggingFacade myLoggingFacade) {
        this.logger = myLoggingFacade;
    }

    public MyLoggingFacade getMyLogger() {
        if (this.logger == null) {
            LoggerProvider loggerProvider = new LoggerProvider(this.getLogfileName(), "cli logger", 1, 1000000, true, this.isDebugOn(), true);
            this.logger = loggerProvider.get();
        }
        return this.logger;
    }

    @Override
    public void debug(String x) {
        if (this.isVerbose() && this.isDebugOn()) {
            CLITool.say(x);
        }
        this.getMyLogger().debug(x);
    }

    @Override
    public boolean isDebugOn() {
        return this.debugOn;
    }

    @Override
    public void setDebugOn(boolean setOn) {
        this.debugOn = setOn;
    }

    @Override
    public void info(String x) {
        if (this.isVerbose()) {
            CLITool.say(x);
        }
        this.getMyLogger().info(x);
    }

    @Override
    public void warn(String x) {
        if (this.isVerbose()) {
            CLITool.say(x);
        }
        this.getMyLogger().warn(x);
    }

    @Override
    public void error(String x) {
        if (this.isVerbose()) {
            CLITool.say(x);
        }
        this.getMyLogger().error(x);
    }

    public void error(String x, Throwable t) {
        if (this.isVerbose()) {
            CLITool.say(x);
        }
        this.getMyLogger().error(x, t);
    }

    public void run() throws Throwable {
        this.initialize();
        this.doIt();
    }

    public void run(String[] args) throws Throwable {
        if (!this.getOptions(args)) {
            return;
        }
        this.run();
    }
}

