/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage.sql.postgres;

import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPoolProvider;
import edu.uiuc.ncsa.security.storage.sql.postgres.PostgresConnectionParameters;

public class PGConnectionPoolProvider
extends ConnectionPoolProvider<ConnectionPool> {
    ConnectionPool cp;

    public PGConnectionPoolProvider(String database, String schema) {
        super(database, schema);
        this.driver = "org.postgresql.Driver";
        this.port = 5432;
        this.host = "localhost";
    }

    public PGConnectionPoolProvider(String database, String schema, String host, int port, String driver, boolean useSSL) {
        super(database, schema, host, port, driver, useSSL);
    }

    @Override
    protected boolean checkEvent(CfgEvent cfgEvent) {
        return true;
    }

    @Override
    public Object componentFound(CfgEvent configurationEvent) {
        return null;
    }

    @Override
    public ConnectionPool get() {
        if (this.cp == null) {
            PostgresConnectionParameters x = new PostgresConnectionParameters(this.checkValue("username"), this.checkValue("password"), this.checkValue("database", this.database), this.checkValue("schema", this.schema), this.checkValue("host", this.host), this.checkValue("port", this.port), this.checkValue("driver", this.driver), this.checkValue("useSSL", this.useSSL));
            this.cp = new ConnectionPool(x);
        }
        return this.cp;
    }
}

