/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage.sql.mariadb;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.PoolException;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.SQLConnectionImpl;
import java.sql.Connection;
import java.sql.SQLException;

public class MariaDBConnectionPool
extends ConnectionPool {
    public static int IS_VALID_TIMEOUT = 100;
    public static int MAX_RETRIES = 10;

    public MariaDBConnectionPool(SQLConnectionImpl connectionParameters) {
        super(connectionParameters);
    }

    protected synchronized Connection pop(int retries) {
        if (retries <= 0) {
            throw new GeneralException("Error: Max retries exceeded");
        }
        Connection c = (Connection)super.pop();
        try {
            if (!c.isClosed() && c.isValid(IS_VALID_TIMEOUT)) {
                return c;
            }
            this.destroy(c);
        }
        catch (SQLException e2) {
            e2.printStackTrace();
        }
        return this.pop(retries - 1);
    }

    @Override
    public Connection pop() throws PoolException {
        return this.pop(MAX_RETRIES);
    }
}

