/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage.sql.h2;

import edu.uiuc.ncsa.security.core.configuration.provider.CfgEvent;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPool;
import edu.uiuc.ncsa.security.storage.sql.ConnectionPoolProvider;
import edu.uiuc.ncsa.security.storage.sql.h2.H2ConnectionParameters;

public class H2ConnectionPoolProvider
extends ConnectionPoolProvider<ConnectionPool> {
    public H2ConnectionPoolProvider(String database, String schema, String host, int port, String driver, boolean useSSL) {
        super(database, schema, host, port, driver, useSSL);
    }

    public H2ConnectionPoolProvider(String database, String schema) {
        super(database, schema);
        this.driver = "org.h2.Driver";
        this.port = 8084;
        this.host = "localhost";
    }

    @Override
    protected boolean checkEvent(CfgEvent cfgEvent) {
        return false;
    }

    @Override
    public Object componentFound(CfgEvent configurationEvent) {
        return null;
    }

    @Override
    public ConnectionPool get() {
        H2ConnectionParameters x = new H2ConnectionParameters(this.checkValue("username"), this.checkValue("password"), this.checkValue("database", this.database), this.checkValue("schema", this.schema), this.checkValue("host", this.host), this.checkValue("port", this.port), this.checkValue("driver", this.driver), this.checkValue("useSSL", this.useSSL));
        return new ConnectionPool(x);
    }
}

