/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage.sql;

import edu.uiuc.ncsa.security.core.util.Pool;
import edu.uiuc.ncsa.security.core.util.PoolException;
import edu.uiuc.ncsa.security.storage.sql.ConnectionParameters;
import edu.uiuc.ncsa.security.storage.sql.SQLConnectionImpl;
import java.sql.Connection;
import java.sql.DriverManager;
import java.sql.SQLException;

public class ConnectionPool
extends Pool<Connection> {
    ConnectionParameters connectionParameters;

    public ConnectionParameters getConnectionParameters() {
        return this.connectionParameters;
    }

    public ConnectionPool(SQLConnectionImpl connectionParameters) {
        this.connectionParameters = connectionParameters;
    }

    @Override
    public Connection create() throws PoolException {
        try {
            Connection con = DriverManager.getConnection(this.getConnectionParameters().getJdbcUrl());
            return con;
        }
        catch (Exception x) {
            x.printStackTrace();
            throw new PoolException(x);
        }
    }

    @Override
    public void destroy(Connection c) throws PoolException {
        try {
            if (!c.isClosed()) {
                c.close();
            }
        }
        catch (SQLException x) {
            throw new PoolException(x);
        }
    }
}

