/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage.cli;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.util.cli.CLITool;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.util.LinkedList;
import java.util.Set;

public abstract class StoreUtil
extends CLITool {
    public static final int ACTION_CREATE = 100;
    public static final int ACTION_READ = 200;
    public static final int ACTION_UPDATE = 300;
    public static final int ACTION_DELETE = 400;
    public static final int ACTION_EXIT = 0;
    public static final int ACTION_UNKNOWN = -1;
    public static final String ACTION_KEY_CREATE = "C";
    public static final String ACTION_KEY_READ = "L";
    public static final String ACTION_KEY_UPDATE = "U";
    public static final String ACTION_KEY_DELETE = "D";
    public static final String ACTION_KEY_EXIT = "X";

    protected abstract Store getStore() throws Exception;

    @Override
    public void doIt() throws Exception {
        boolean keepAsking = true;
        BufferedReader in = new BufferedReader(new InputStreamReader(System.in));
        String inString = null;
        while (keepAsking) {
            StoreUtil.say("Enter the operation you want, create(C), list(L), update(U) delete(D) or exit(X)");
            inString = this.readline();
            switch (this.getAction(inString)) {
                case 100: {
                    this.create();
                    break;
                }
                case 200: {
                    this.show();
                    break;
                }
                case 300: {
                    this.update();
                    break;
                }
                case 400: {
                    this.delete();
                    break;
                }
                case 0: {
                    StoreUtil.say("exiting...");
                    keepAsking = false;
                    break;
                }
                case -1: {
                    StoreUtil.say("Unknown command, try again");
                }
            }
        }
    }

    protected void show() throws Exception {
        StoreUtil.say("Listing entries, hit X to return to main menu, L to show entries again.");
        boolean keepAsking = true;
        boolean listEntries = true;
        LinkedList<Object> linkedList = new LinkedList();
        block6: while (keepAsking) {
            if (listEntries) {
                linkedList = this.listAll();
                listEntries = false;
            }
            if (linkedList.isEmpty()) {
                keepAsking = false;
                continue;
            }
            String inLine = this.readline();
            if (inLine != null && inLine.toUpperCase().equals(ACTION_KEY_EXIT)) {
                keepAsking = false;
                StoreUtil.say("returning to main menu");
                continue;
            }
            int choice = -1;
            try {
                choice = Integer.parseInt(inLine);
            }
            catch (NumberFormatException nfx) {
                // empty catch block
            }
            if (choice == -1) {
                switch (this.getAction(inLine)) {
                    case 200: {
                        listEntries = true;
                        continue block6;
                    }
                    case 0: {
                        keepAsking = false;
                        continue block6;
                    }
                }
                StoreUtil.say("unknown option, try again (might need to exit this submenu first)");
                continue;
            }
            StoreUtil.say(((Identifiable)linkedList.get(choice)).toString());
        }
    }

    protected LinkedList<Identifiable> listAll() throws Exception {
        StoreUtil.say("select the number of the item below:");
        Set keys = this.getStore().keySet();
        LinkedList<Identifiable> linkedList = new LinkedList<Identifiable>();
        int i = 0;
        for (Object key : keys) {
            Identifiable x = (Identifiable)this.getStore().get(key);
            linkedList.add(x);
            StoreUtil.say(i++ + "." + x.getIdentifierString());
        }
        if (linkedList.isEmpty()) {
            StoreUtil.say("(no entries found)");
        }
        return linkedList;
    }

    protected void delete() throws Exception {
        LinkedList<Identifiable> linkedList = this.listAll();
        String inLine = this.readline();
        int choice = -1;
        try {
            choice = Integer.parseInt(inLine);
        }
        catch (NumberFormatException nfx) {
            // empty catch block
        }
        if (choice < 0 || linkedList.size() <= choice) {
            StoreUtil.say("unknown choice");
            return;
        }
        Identifiable x = linkedList.get(choice);
        this.getStore().remove(x.getIdentifier());
        StoreUtil.say("Done. object with id = " + x.getIdentifierString() + " has been removed from the store");
    }

    public abstract void update() throws Exception;

    public abstract void create() throws Exception;

    @Override
    public void help() {
        StoreUtil.say("A command line tool to manage stores");
        StoreUtil.say("usage: " + this.getClass().getSimpleName() + " options");
        StoreUtil.defaultHelp(true);
        StoreUtil.say("Where the options are given as -x (fnord) = short option, (long option), and [] = optional. Other options: ");
        StoreUtil.say("  [-name (-name) -- set the name of the configuration.]");
        StoreUtil.say("If the configuration name is omitted, it is assumed there is exactly one in the given file and that is to be used.");
    }

    protected int getAction(String input) {
        if (input.toUpperCase().equals(ACTION_KEY_CREATE)) {
            return 100;
        }
        if (input.toUpperCase().equals(ACTION_KEY_DELETE)) {
            return 400;
        }
        if (input.toUpperCase().equals(ACTION_KEY_READ)) {
            return 200;
        }
        if (input.toUpperCase().equals(ACTION_KEY_UPDATE)) {
            return 300;
        }
        if (input.toUpperCase().equals(ACTION_KEY_EXIT)) {
            return 0;
        }
        return -1;
    }
}

