/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Initializable;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.exceptions.UnregisteredObjectException;
import java.util.HashMap;

public class MemoryStore<V extends Identifiable>
extends HashMap<Identifier, V>
implements Store<V> {
    Initializable initializable;
    protected IdentifiableProvider<V> identifiableProvider;

    public MemoryStore(IdentifiableProvider<V> identifiableProvider) {
        this.identifiableProvider = identifiableProvider;
        this.initializable = new MSInitializer(this);
    }

    public Initializable getInitializer() {
        return this.initializable;
    }

    @Override
    public V create() {
        return (V)((Identifiable)this.identifiableProvider.get());
    }

    @Override
    public void update(V value) {
        if (!this.containsKey(value.getIdentifier())) {
            throw new UnregisteredObjectException("Error: the given item has not been added to the store yet:" + value);
        }
        this.realSave(value);
    }

    protected void realSave(V value) {
        if (value.getIdentifier() == null) {
            throw new UnsupportedOperationException("Error: null identifiers are not allowed");
        }
        this.put(value.getIdentifier(), value);
    }

    @Override
    public void register(V value) {
        this.realSave(value);
    }

    @Override
    public void save(V value) {
        this.realSave(value);
    }

    public static class MSInitializer
    implements Initializable {
        MemoryStore memoryStore;

        public MSInitializer(MemoryStore memoryStore) {
            this.memoryStore = memoryStore;
        }

        @Override
        public boolean createNew() {
            return this.destroy();
        }

        @Override
        public boolean destroy() {
            this.memoryStore.clear();
            return true;
        }

        @Override
        public boolean init() {
            return this.destroy();
        }

        @Override
        public boolean isCreated() {
            return true;
        }

        @Override
        public boolean isInitialized() {
            return true;
        }

        @Override
        public boolean isDestroyed() {
            return false;
        }
    }
}

