/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.storage;

import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Initializable;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.exceptions.UninitializedException;
import edu.uiuc.ncsa.security.storage.XMLMap;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.io.IOException;
import java.io.InputStream;
import java.io.ObjectInputStream;
import java.io.ObjectOutputStream;
import java.io.OutputStream;
import java.io.OutputStreamWriter;
import java.io.StreamCorruptedException;
import java.util.HashMap;
import org.apache.commons.codec.digest.DigestUtils;

public abstract class IndexedStreamStore<V extends Identifiable>
implements Store<V> {
    protected MapConverter<V> converter;
    protected IdentifiableProvider<V> identifiableProvider;
    protected Initializable initializer;
    HashMap<Identifier, V> createdItems;

    public HashMap<Identifier, V> getCreatedItems() {
        if (this.createdItems == null) {
            this.createdItems = new HashMap();
        }
        return this.createdItems;
    }

    protected void put(V t) {
        if (t.getIdentifier() == null) {
            throw new UninitializedException("Error: There is no identifier for this store entry");
        }
        this.put(t.getIdentifier(), t);
    }

    @Override
    public V put(Identifier key, V value) {
        Identifiable oldValue = null;
        if (!this.containsKey(value.getIdentifier())) {
            this.save(value);
        } else {
            oldValue = (Identifiable)this.get(value.getIdentifier());
            this.update(value);
        }
        return (V)oldValue;
    }

    protected String hashString(String identifier) {
        return this.getDigest(identifier);
    }

    String getDigest(String identifier) {
        return DigestUtils.shaHex((String)identifier);
    }

    protected void serializeObject(V obj, OutputStream outputStream) throws IOException {
        ObjectOutputStream oos = new ObjectOutputStream(outputStream);
        oos.writeObject(obj);
        oos.flush();
        oos.close();
    }

    protected V objectDeserialize(InputStream is) throws IOException, ClassNotFoundException {
        ObjectInputStream ois = new ObjectInputStream(is);
        Identifiable t = (Identifiable)ois.readObject();
        ois.close();
        return (V)t;
    }

    protected V loadStream(InputStream fis) {
        Identifiable t = null;
        try {
            if (this.converter != null) {
                try {
                    XMLMap map = new XMLMap();
                    map.fromXML(fis);
                    t = (Identifiable)this.identifiableProvider.get(false);
                    this.converter.fromMap(map, t);
                    fis.close();
                }
                catch (Throwable zzz) {
                    t = (Identifiable)this.objectDeserialize(fis);
                }
            } else {
                t = (Identifiable)this.objectDeserialize(fis);
            }
            return (V)t;
        }
        catch (StreamCorruptedException q) {
            throw new GeneralException("Error: Could not load stream. This exception usually means either that you have an out of date library for items you want to store or that the operating system could not find the something (e.g. a file). Is your file store configured correctly?", q);
        }
        catch (IOException x) {
            throw new GeneralException("Error: Could not load the stream. Is your store configured correctly?", x);
        }
        catch (ClassNotFoundException e2) {
            throw new GeneralException("Error: Cannot find the item's class");
        }
    }

    @Override
    public boolean isEmpty() {
        return this.size() == 0;
    }

    protected void createIndexEntry(String otherKey, String identifier, OutputStream outputStream) throws IOException {
        OutputStreamWriter osw = new OutputStreamWriter(outputStream);
        osw.write(this.hashString(identifier));
        osw.flush();
        osw.close();
    }

    @Override
    public V create() {
        return (V)((Identifiable)this.identifiableProvider.get());
    }
}

