/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.servlet;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.core.util.Pool;
import edu.uiuc.ncsa.security.servlet.ServiceClientHTTPException;
import edu.uiuc.ncsa.security.util.ssl.SSLConfiguration;
import edu.uiuc.ncsa.security.util.ssl.VerifyingHTTPClientFactory;
import java.io.IOException;
import java.io.UnsupportedEncodingException;
import java.net.URI;
import java.net.URLDecoder;
import java.net.URLEncoder;
import java.util.Map;
import org.apache.http.HttpEntity;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;
import org.apache.http.util.EntityUtils;

public class ServiceClient {
    SSLConfiguration sslConfiguration;
    boolean verbose = false;
    URI host;
    protected Pool<HttpClient> clientPool = new Pool<HttpClient>(){
        VerifyingHTTPClientFactory f;

        public VerifyingHTTPClientFactory getF() {
            if (this.f == null) {
                this.f = new VerifyingHTTPClientFactory(new MyLoggingFacade(this.getClass().getSimpleName()), ServiceClient.this.sslConfiguration);
            }
            return this.f;
        }

        @Override
        public HttpClient create() {
            try {
                return this.getF().getClient(ServiceClient.this.host.toString());
            }
            catch (IOException e2) {
                throw new GeneralException("Error getting https-aware client");
            }
        }

        @Override
        public void destroy(HttpClient HttpClient2) {
        }
    };
    public static String ENCODING = "UTF-8";

    public boolean isVerbose() {
        return this.verbose;
    }

    public void setVerbose(boolean verbose) {
        this.verbose = verbose;
    }

    public ServiceClient(URI host, SSLConfiguration sslConfiguration) {
        this.host = host;
        this.sslConfiguration = sslConfiguration;
    }

    public ServiceClient(URI host) {
        this.host = host;
        SSLConfiguration sslConfiguration1 = new SSLConfiguration();
        sslConfiguration1.setUseDefaultJavaTrustStore(true);
        this.sslConfiguration = sslConfiguration1;
    }

    public URI host(URI ... x) {
        if (0 < x.length) {
            this.host = x[0];
        }
        return this.host;
    }

    public static String encode(String x) throws UnsupportedEncodingException {
        if (x == null) {
            return "";
        }
        String xx = URLEncoder.encode(x, ENCODING);
        return xx;
    }

    public static String decode(String x) throws UnsupportedEncodingException {
        return URLDecoder.decode(x, ENCODING);
    }

    public static String convertToStringRequest(String host, Map m) {
        int size = m.size();
        int i = 0;
        String[][] strings = new String[size][2];
        for (Object o : m.keySet()) {
            Object v = m.get(o);
            if (v == null) continue;
            strings[i][0] = o.toString();
            strings[i++][1] = v.toString();
        }
        return ServiceClient.convertToStringRequest(host, strings);
    }

    public String getRawResponse(Map m) {
        return this.getRawResponse(ServiceClient.convertToStringRequest(this.host(new URI[0]).toString(), m));
    }

    public static String convertToStringRequest(String host, String[][] args) {
        String getString = host;
        boolean firstPass = true;
        if (args != null && args.length != 0) {
            for (int i = 0; i < args.length; ++i) {
                if (args[i].length == 0) continue;
                try {
                    getString = getString + (firstPass ? "?" : "&") + args[i][0] + "=" + ServiceClient.encode(args[i][1]);
                    if (!firstPass) continue;
                    firstPass = false;
                    continue;
                }
                catch (UnsupportedEncodingException e2) {
                    throw new GeneralException("Error encoding argument", e2);
                }
            }
        }
        return getString;
    }

    public String getRawResponse(String requestString) {
        HttpGet httpGet = new HttpGet(requestString);
        HttpClient client = this.clientPool.pop();
        HttpResponse response = null;
        try {
            response = client.execute(httpGet);
            if (response.getStatusLine().getStatusCode() == 204) {
                this.clientPool.push(client);
                return "";
            }
            HttpEntity entity1 = response.getEntity();
            String x = EntityUtils.toString(entity1);
            if (response.getStatusLine().getStatusCode() != 200) {
                ServiceClientHTTPException xx = new ServiceClientHTTPException("Error contacting server with code of  " + response.getStatusLine().getStatusCode());
                xx.setContent(x);
                xx.setStatus(response.getStatusLine().getStatusCode());
                this.clientPool.realDestroy(client);
                throw xx;
            }
            this.clientPool.push(client);
            return x;
        }
        catch (IOException e2) {
            throw new GeneralException("Error invoking http client", e2);
        }
    }
}

