/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.oauth_1_0a.server;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.delegation.server.issuers.AbstractIssuer;
import edu.uiuc.ncsa.security.delegation.server.issuers.PAIssuer;
import edu.uiuc.ncsa.security.delegation.server.request.PARequest;
import edu.uiuc.ncsa.security.delegation.server.request.PAResponse;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.oauth_1_0a.OAuthUtilities;
import edu.uiuc.ncsa.security.oauth_1_0a.client.OAClient;
import edu.uiuc.ncsa.security.oauth_1_0a.server.PARequestImpl;
import edu.uiuc.ncsa.security.oauth_1_0a.server.PAResponseImpl;
import edu.uiuc.ncsa.security.util.pkcs.KeyUtil;
import java.net.URI;
import java.security.PublicKey;
import javax.servlet.ServletException;
import net.oauth.OAuthAccessor;

public class PAIImpl
extends AbstractIssuer
implements PAIssuer {
    public PAIImpl(TokenForge tokenForge, URI address) {
        super(tokenForge, address);
    }

    @Override
    public PAResponse processProtectedAsset(PARequest paRequest) {
        try {
            AccessToken at;
            PARequestImpl protectedAssetRequest = null;
            protectedAssetRequest = !(paRequest instanceof PARequestImpl) ? new PARequestImpl(paRequest) : (PARequestImpl)paRequest;
            if (protectedAssetRequest.getParameters().get("oauth_token") == null) {
                throw new ServletException("Error: missing access token");
            }
            OAClient oaClient = (OAClient)protectedAssetRequest.getClient();
            OAuthAccessor accessor = OAuthUtilities.createOAuthAccessor(this, oaClient);
            if (oaClient.getSignatureMethod().equals("RSA-SHA1")) {
                PublicKey pk = KeyUtil.fromX509PEM(oaClient.getSecret());
                accessor.consumer.setProperty("RSA-SHA1.PublicKey", pk);
                accessor.setProperty("RSA-SHA1.PublicKey", pk);
            }
            if ((at = protectedAssetRequest.getAccessToken()) == null) {
                at = this.tokenForge.getAccessToken(protectedAssetRequest.getParameters());
            }
            accessor.tokenSecret = at.getSharedSecret();
            OAuthUtilities.validate(protectedAssetRequest.getMessage(), accessor);
            PAResponseImpl paResponse = new PAResponseImpl();
            paResponse.setAccessToken(at);
            paResponse.setParameters(OAuthUtilities.whittleMap(protectedAssetRequest.getParameters()));
            return paResponse;
        }
        catch (Exception x) {
            throw new GeneralException(x);
        }
    }
}

