/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.oauth_1_0a.server;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.delegation.server.issuers.AbstractIssuer;
import edu.uiuc.ncsa.security.delegation.server.issuers.CBIssuer;
import edu.uiuc.ncsa.security.delegation.server.request.CBRequest;
import edu.uiuc.ncsa.security.delegation.server.request.CBResponse;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.oauth_1_0a.server.CBResponseImpl;
import edu.uiuc.ncsa.security.util.ssl.VerifyingHTTPClientFactory;
import java.net.URI;
import java.util.List;
import javax.net.ssl.SSLPeerUnverifiedException;
import net.oauth.OAuth;
import org.apache.http.HttpResponse;
import org.apache.http.client.HttpClient;
import org.apache.http.client.methods.HttpGet;

public class CBIImpl
extends AbstractIssuer
implements CBIssuer {
    VerifyingHTTPClientFactory verifyingHTTPClientFactory;

    public CBIImpl(TokenForge tokenForge, URI address, VerifyingHTTPClientFactory verifyingHTTPClientFactory) {
        super(tokenForge, address);
        this.verifyingHTTPClientFactory = verifyingHTTPClientFactory;
    }

    public VerifyingHTTPClientFactory getVerifyingHTTPClientFactory() {
        return this.verifyingHTTPClientFactory;
    }

    @Override
    public CBResponse processCallbackRequest(CBRequest CBRequest2) {
        List<OAuth.Parameter> parameters = OAuth.newList("oauth_token", CBRequest2.getAuthorizationGrant().getToken(), "oauth_verifier", CBRequest2.getVerifier().getToken());
        HttpResponse response = null;
        try {
            String callback = OAuth.addParameters(CBRequest2.getCallbackUri().toString(), parameters);
            HttpGet httpget = new HttpGet(callback);
            HttpClient httpClient = this.getVerifyingHTTPClientFactory().getClient(this.getAddress().toString(), CBRequest2.getConnectionTimeout(), CBRequest2.getConnectionTimeout());
            response = httpClient.execute(httpget);
        }
        catch (Exception e2) {
            if (e2 instanceof SSLPeerUnverifiedException) {
                throw new GeneralException("Error verifying host. Is your trusted roots store up to date? Are you using the correct cert chain?", e2);
            }
            throw new GeneralException("Error processing callback request for token=\"" + CBRequest2.getAuthorizationGrant().getToken() + "\" and url =" + CBRequest2.getCallbackUri(), e2);
        }
        if (response.getStatusLine().getStatusCode() != 200) {
            throw new GeneralException("Error, bad status code of \"" + response.getStatusLine().getStatusCode() + "\" returned for token=\"" + CBRequest2.getAuthorizationGrant().getToken() + "\" and url =" + CBRequest2.getCallbackUri());
        }
        return new CBResponseImpl();
    }
}

