/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.oauth_1_0a.server;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.delegation.server.request.ATResponse;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import edu.uiuc.ncsa.security.delegation.token.Verifier;
import java.io.IOException;
import java.io.OutputStream;
import java.util.ArrayList;
import java.util.List;
import java.util.Map;
import javax.servlet.ServletOutputStream;
import javax.servlet.http.HttpServletResponse;
import net.oauth.OAuth;

public class ATResponseImpl
implements ATResponse {
    Map<String, String> parameters;
    AccessToken accessToken;
    Verifier verifier;

    @Override
    public Map<String, String> getParameters() {
        return this.parameters;
    }

    public void setParameters(Map<String, String> parameters) {
        this.parameters = parameters;
    }

    @Override
    public AccessToken getAccessToken() {
        return this.accessToken;
    }

    public void setAccessToken(AccessToken accessToken) {
        this.accessToken = accessToken;
    }

    @Override
    public Verifier getVerifier() {
        return this.verifier;
    }

    public void setVerifier(Verifier verifier) {
        this.verifier = verifier;
    }

    @Override
    public void write(HttpServletResponse response) {
        response.setContentType("application/x-www-form-urlencoded");
        try {
            ServletOutputStream out = response.getOutputStream();
            ArrayList<String> arrayList = new ArrayList<String>();
            arrayList.add("oauth_token");
            arrayList.add(this.getAccessToken().getToken());
            arrayList.add("oauth_token_secret");
            arrayList.add(this.getAccessToken().getSharedSecret());
            for (String k : this.getParameters().keySet()) {
                if (k.startsWith("oauth_")) continue;
                arrayList.add(k);
                arrayList.add(this.getParameters().get(k));
            }
            List<OAuth.Parameter> list = OAuth.newList(arrayList.toArray(new String[arrayList.size()]));
            OAuth.formEncode(list, (OutputStream)out);
            out.flush();
            out.close();
        }
        catch (IOException e2) {
            throw new GeneralException("Error writing to output stream", e2);
        }
    }
}

