/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.oauth_1_0a.client;

import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.MapUtilities;
import edu.uiuc.ncsa.security.delegation.client.request.PARequest;
import edu.uiuc.ncsa.security.delegation.client.request.PAResponse;
import edu.uiuc.ncsa.security.delegation.client.server.PAServer;
import edu.uiuc.ncsa.security.delegation.services.AddressableServer;
import edu.uiuc.ncsa.security.delegation.services.Request;
import edu.uiuc.ncsa.security.delegation.services.Response;
import edu.uiuc.ncsa.security.delegation.storage.Client;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import edu.uiuc.ncsa.security.delegation.token.MyX509Certificates;
import edu.uiuc.ncsa.security.delegation.token.impl.AccessTokenImpl;
import edu.uiuc.ncsa.security.oauth_1_0a.OAuthUtilities;
import edu.uiuc.ncsa.security.oauth_1_0a.client.OAClient;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import java.io.BufferedReader;
import java.io.InputStreamReader;
import java.net.URI;
import java.util.HashMap;
import java.util.Map;
import net.oauth.OAuthAccessor;
import net.oauth.OAuthMessage;
import net.oauth.client.OAuthClient;

public class PAServerImpl
implements AddressableServer,
PAServer {
    URI address;

    public PAServerImpl(URI address) {
        this.address = address;
    }

    @Override
    public URI getAddress() {
        return this.address;
    }

    @Override
    public Response process(Request request) {
        return request.process(this);
    }

    @Override
    public PAResponse processPARequest(PARequest request) {
        return this.getAsset(request);
    }

    protected PAResponse getAsset(PARequest request) {
        return this.getAsset(request.getClient(), request.getParameters(), request.getAccessToken());
    }

    protected PAResponse getAsset(Client client, Map props, AccessToken accessToken) {
        MyX509Certificates myX509Certificate = null;
        AccessTokenImpl atImpl = null;
        if (!(accessToken instanceof AccessTokenImpl)) {
            throw new GeneralException("Error: unsupported access token implementation");
        }
        atImpl = (AccessTokenImpl)accessToken;
        OAuthAccessor accessor = OAuthUtilities.createOAuthAccessor(this, (OAClient)client);
        accessor.accessToken = atImpl.getToken();
        accessor.tokenSecret = atImpl.getSharedSecret();
        try {
            OAuthClient oaClient = OAuthUtilities.newOAuthClient(this.getAddress());
            accessor.consumer.setProperty("RSA-SHA1.PrivateKey", client.getSecret());
            accessor.setProperty("RSA-SHA1.PrivateKey", client.getSecret());
            OAuthMessage message = oaClient.invoke(accessor, this.getAddress().toString(), MapUtilities.toList(props));
            InputStreamReader isr = new InputStreamReader(message.getBodyAsStream());
            BufferedReader br = new BufferedReader(isr);
            HashMap<String, String> additionalInfo = new HashMap<String, String>();
            String linein = br.readLine();
            while (linein != null && !linein.equals("-----BEGIN CERTIFICATE-----")) {
                int loc = linein.indexOf("=");
                if (loc != -1) {
                    additionalInfo.put(linein.substring(0, loc), linein.substring(loc + 1));
                }
                linein = br.readLine();
            }
            StringBuilder certString = new StringBuilder();
            while (linein != null) {
                certString.append(linein);
                linein = br.readLine();
                if (linein == null) continue;
                certString.append("\n");
            }
            myX509Certificate = new MyX509Certificates(CertUtil.fromX509PEM(certString.toString()));
            PAResponse par = new PAResponse(myX509Certificate);
            par.setAdditionalInformation(additionalInfo);
            HashMap m = OAuthUtilities.whittleParameters(message);
            par.setParameters(m);
            return par;
        }
        catch (Exception e2) {
            throw new GeneralException("Error invoking OAuthConstants client", e2);
        }
    }
}

