/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.token;

import edu.uiuc.ncsa.security.delegation.token.ProtectedAsset;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import java.security.cert.CertificateEncodingException;
import java.security.cert.X509Certificate;
import java.util.Collection;

public class MyX509Certificates
implements ProtectedAsset {
    public X509Certificate[] x509Certificates;

    public MyX509Certificates(Collection<X509Certificate> certs) {
        this.x509Certificates = certs.toArray(new X509Certificate[certs.size()]);
    }

    public MyX509Certificates(X509Certificate[] x509Certificates) {
        this.x509Certificates = x509Certificates;
    }

    public X509Certificate[] getX509Certificates() {
        return this.x509Certificates;
    }

    public String getX509CertificatesPEM() throws CertificateEncodingException {
        String pem = "";
        for (int i = 0; i < this.x509Certificates.length; ++i) {
            pem = pem + CertUtil.toPEM(this.x509Certificates[i]) + "\n";
        }
        return pem;
    }

    public void setX509Certificates(X509Certificate[] x509Certificates) {
        this.x509Certificates = x509Certificates;
    }

    public String toString() {
        String str2 = "MyX509Certificates[";
        for (int i = 0; i < this.x509Certificates.length; ++i) {
            str2 = str2 + "cert = " + (this.x509Certificates[i] == null ? "(null)" : this.x509Certificates[i]);
        }
        str2 = str2 + "]";
        return str2;
    }
}

