/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.storage.impl;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.delegation.storage.TransactionStore;
import edu.uiuc.ncsa.security.delegation.storage.impl.BasicTransaction;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.Verifier;
import edu.uiuc.ncsa.security.storage.MemoryStore;
import java.util.HashMap;

public class TransactionMemoryStore<V extends BasicTransaction>
extends MemoryStore<V>
implements TransactionStore<V> {
    TokenIndex agIndex;
    TokenIndex atIndex;
    TokenIndex vIndex;

    public TransactionMemoryStore(IdentifiableProvider<V> vIdentifiableProvider) {
        super(vIdentifiableProvider);
    }

    public TokenIndex getAgIndex() {
        if (this.agIndex == null) {
            this.agIndex = new TokenIndex();
        }
        return this.agIndex;
    }

    public TokenIndex getAtIndex() {
        if (this.atIndex == null) {
            this.atIndex = new TokenIndex();
        }
        return this.atIndex;
    }

    public TokenIndex getvIndex() {
        if (this.vIndex == null) {
            this.vIndex = new TokenIndex();
        }
        return this.vIndex;
    }

    @Override
    public V get(AuthorizationGrant authorizationGrant) {
        return (V)((BasicTransaction)this.getAgIndex().get(authorizationGrant.getToken()));
    }

    @Override
    public V get(AccessToken accessToken) {
        return (V)((BasicTransaction)this.getAtIndex().get(accessToken.getToken()));
    }

    @Override
    public V get(Verifier verifier) {
        return (V)((BasicTransaction)this.getvIndex().get(verifier.getToken()));
    }

    protected void updateIndices(V v) {
        if (((BasicTransaction)v).getAccessToken() != null) {
            this.getAtIndex().put(((BasicTransaction)v).getAccessToken().getToken(), v);
        }
        if (((BasicTransaction)v).getAuthorizationGrant() != null) {
            this.getAgIndex().put(((BasicTransaction)v).getAuthorizationGrant().getToken(), v);
        }
        if (((BasicTransaction)v).getVerifier() != null) {
            this.getvIndex().put(((BasicTransaction)v).getVerifier().getToken(), v);
        }
    }

    @Override
    public void register(V value) {
        super.register(value);
        this.updateIndices(value);
    }

    @Override
    public void save(V value) {
        super.save(value);
        this.updateIndices(value);
    }

    @Override
    public void update(V value) {
        super.update(value);
        this.updateIndices(value);
    }

    @Override
    public void clear() {
        super.clear();
        this.clearIndices();
    }

    protected void clearIndices() {
        this.agIndex = null;
        this.atIndex = null;
        this.vIndex = null;
    }

    protected void removeItem(V value) {
        this.getAgIndex().remove(((BasicTransaction)value).getAuthorizationGrant());
        this.getAtIndex().remove(((BasicTransaction)value).getAccessToken());
        this.getvIndex().remove(((BasicTransaction)value).getVerifier());
    }

    @Override
    public V remove(Object key) {
        BasicTransaction item = (BasicTransaction)super.remove(key);
        if (item != null) {
            this.removeItem(item);
        }
        return (V)item;
    }

    protected class TokenIndex
    extends HashMap<String, V> {
    }
}

