/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.storage.impl;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.IdentifiableImpl;
import edu.uiuc.ncsa.security.delegation.storage.TransactionStore;
import edu.uiuc.ncsa.security.delegation.storage.impl.BasicTransaction;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.delegation.token.Verifier;
import edu.uiuc.ncsa.security.storage.FileStore;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import java.io.File;
import java.io.IOException;

public abstract class FSTransactionStore<V extends BasicTransaction>
extends FileStore<V>
implements TransactionStore<V> {
    protected TokenForge tokenForge;

    protected FSTransactionStore(File storeDirectory, File indexDirectory, IdentifiableProvider<V> idp, TokenForge tokenForge, MapConverter<V> mp) {
        super(storeDirectory, indexDirectory, idp, mp);
        this.tokenForge = tokenForge;
    }

    public FSTransactionStore(File file, IdentifiableProvider<V> idp, TokenForge tokenForge, MapConverter<V> mp) {
        super(file, idp, mp);
        this.tokenForge = tokenForge;
    }

    @Override
    public void realSave(boolean checkExists, V t) {
        super.realSave(checkExists, t);
        try {
            if (((BasicTransaction)t).hasAuthorizationGrant()) {
                this.createIndexEntry(((BasicTransaction)t).getAuthorizationGrant().getToken(), ((IdentifiableImpl)t).getIdentifierString());
            }
            if (((BasicTransaction)t).hasAccessToken()) {
                this.createIndexEntry(((BasicTransaction)t).getAccessToken().getToken(), ((IdentifiableImpl)t).getIdentifierString());
            }
            if (((BasicTransaction)t).hasVerifier()) {
                this.createIndexEntry(((BasicTransaction)t).getVerifier().getToken(), ((IdentifiableImpl)t).getIdentifierString());
            }
        }
        catch (IOException e2) {
            throw new GeneralException("Error serializing item " + t + "to file ");
        }
    }

    @Override
    public V realRemove(V thingie) {
        super.realRemove(thingie);
        if (((BasicTransaction)thingie).getAccessToken() != null) {
            this.removeIndexEntry(((BasicTransaction)thingie).getAccessToken().getToken());
        }
        if (((BasicTransaction)thingie).getVerifier() != null) {
            this.removeIndexEntry(((BasicTransaction)thingie).getVerifier().getToken());
        }
        return thingie;
    }

    @Override
    public V get(AuthorizationGrant authorizationGrant) {
        return (V)((BasicTransaction)this.getIndexEntry(authorizationGrant.getToken()));
    }

    @Override
    public V get(AccessToken accessToken) {
        return (V)((BasicTransaction)this.getIndexEntry(accessToken.getToken()));
    }

    @Override
    public V get(Verifier verifier) {
        return (V)((BasicTransaction)this.getIndexEntry(verifier.getToken()));
    }
}

