/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.delegation.storage.impl;

import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.delegation.storage.impl.BasicTransaction;
import edu.uiuc.ncsa.security.delegation.storage.impl.BasicTransactionKeys;
import edu.uiuc.ncsa.security.delegation.token.AccessToken;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.TokenForge;
import edu.uiuc.ncsa.security.delegation.token.Verifier;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;

public class BasicTransactionConverter<V extends BasicTransaction>
extends MapConverter<V> {
    protected TokenForge tokenForge;

    public TokenForge getTokenForge() {
        return this.tokenForge;
    }

    protected BasicTransactionKeys getBTKeys() {
        return (BasicTransactionKeys)this.keys;
    }

    public BasicTransactionConverter(IdentifiableProvider<V> identifiableProvider, TokenForge tokenForge) {
        this(new BasicTransactionKeys(), identifiableProvider, tokenForge);
    }

    public BasicTransactionConverter(SerializationKeys keys, IdentifiableProvider<V> identifiableProvider, TokenForge tokenForge) {
        super(keys, identifiableProvider);
        this.tokenForge = tokenForge;
    }

    @Override
    public V fromMap(ConversionMap<String, Object> data, V v) {
        BasicTransaction b = (BasicTransaction)super.fromMap(data, v);
        Object token = data.get(this.getBTKeys().tempCred(new String[0]));
        if (token != null) {
            if (token instanceof AuthorizationGrant) {
                b.setAuthorizationGrant((AuthorizationGrant)token);
            } else {
                b.setAuthorizationGrant(this.tokenForge.getAuthorizationGrant(token.toString()));
            }
        }
        if ((token = data.get(this.getBTKeys().accessToken(new String[0]))) != null) {
            if (token instanceof AccessToken) {
                b.setAccessToken((AccessToken)token);
            } else {
                b.setAccessToken(this.tokenForge.getAccessToken(token.toString()));
            }
        }
        if ((token = data.get(this.getBTKeys().verifier(new String[0]))) != null) {
            if (token instanceof Verifier) {
                b.setVerifier((Verifier)token);
            } else {
                b.setVerifier(this.tokenForge.getVerifier(token.toString()));
            }
        }
        return (V)b;
    }

    @Override
    public void toMap(V value, ConversionMap<String, Object> data) {
        super.toMap(value, data);
        if (((BasicTransaction)value).hasAuthorizationGrant()) {
            data.put(this.getBTKeys().tempCred(new String[0]), ((BasicTransaction)value).getAuthorizationGrant().getToken());
        }
        if (((BasicTransaction)value).hasAccessToken()) {
            data.put(this.getBTKeys().accessToken(new String[0]), ((BasicTransaction)value).getAccessToken().getToken());
        }
        if (((BasicTransaction)value).hasVerifier()) {
            data.put(this.getBTKeys().verifier(new String[0]), ((BasicTransaction)value).getVerifier().getToken());
        }
    }
}

