/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.util;

import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.core.util.QueueWithSpare;

public abstract class QueuePopulationThread<E>
extends Thread {
    int maxQueueSize = 10;
    QueueWithSpare<E> q = new QueueWithSpare();
    MyLoggingFacade logger;
    long sleepInterval = 10000L;
    boolean stopThread;

    protected QueuePopulationThread(MyLoggingFacade logger) {
        this.logger = logger;
    }

    protected QueuePopulationThread(QueueWithSpare<E> q) {
        this.q = q;
    }

    protected QueuePopulationThread(int maxQueueSize, long sleepInterval, QueueWithSpare<E> q) {
        this.maxQueueSize = maxQueueSize;
        this.sleepInterval = sleepInterval;
        this.q = q;
    }

    public QueueWithSpare<E> getQ() {
        return this.q;
    }

    protected MyLoggingFacade getLogger() {
        if (this.logger == null) {
            this.logger = new MyLoggingFacade(this.getClass().getName(), false);
        }
        return this.logger;
    }

    public boolean isStopThread() {
        return this.stopThread;
    }

    public void setStopThread(boolean stopThread) {
        this.stopThread = stopThread;
    }

    protected abstract E createNew();

    protected void log(String x) {
        this.getLogger().info(x);
    }

    @Override
    public void run() {
        this.log("starting queue populator");
        while (!this.isStopThread()) {
            try {
                QueuePopulationThread.sleep(this.sleepInterval);
                if (!this.q.isEmpty() && this.q.size() >= this.maxQueueSize) continue;
                this.q.push(this.createNew());
            }
            catch (InterruptedException e2) {
                this.setStopThread(true);
                this.getLogger().warn("Cleanup interrupted, stopping thread...");
            }
        }
    }
}

