/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.util;

import edu.uiuc.ncsa.security.core.exceptions.InvalidTimestampException;
import java.net.URI;
import java.sql.Timestamp;
import java.util.Date;

public class DateUtils {
    public static long MAX_TIMEOUT = 900000L;

    public static Date getDate(URI token) {
        return DateUtils.getDate(token.toString());
    }

    public static Date getDate(String token) {
        token = token.substring(token.lastIndexOf("/") + 1);
        Date d = new Date();
        d.setTime(Long.parseLong(token));
        return d;
    }

    public static void checkTimestamp(String token, long maxTime) {
        Date rawTime;
        long issueTime;
        long targetTime;
        if (token == null || token.length() == 0) {
            throw new InvalidTimestampException("Error: no token found");
        }
        long now2 = System.currentTimeMillis();
        if (now2 < (targetTime = (issueTime = (rawTime = DateUtils.getDate(token)).getTime()) + maxTime)) {
            return;
        }
        Date d = new Date();
        d.setTime(targetTime);
        throw new InvalidTimestampException("Error: Time expired. The request was only valid between " + rawTime + " and " + d + ". Request rejected.");
    }

    public static void checkTimestamp(String token) {
        DateUtils.checkTimestamp(token, MAX_TIMEOUT);
    }

    public static Date sqlTSToDate(Timestamp timestamp) {
        return new Date(timestamp.getTime());
    }

    public static boolean compareDates(Date date0, Date date1) {
        long x1;
        long x0 = date0.getTime();
        return Math.abs(x0 - (x1 = date1.getTime())) < 1000L;
    }

    public static boolean equals(Date date1, Date date2) {
        if (date1 == null) {
            if (date2 != null) {
                return false;
            }
        } else {
            long time2;
            if (date2 == null) {
                return false;
            }
            long getRidOfTime = 86400000L;
            long time1 = date1.getTime() / getRidOfTime;
            if (time1 != (time2 = date2.getTime() / getRidOfTime)) {
                return false;
            }
        }
        return true;
    }
}

