/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.security.core.cache;

import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.Store;
import edu.uiuc.ncsa.security.core.cache.Cache;
import edu.uiuc.ncsa.security.core.cache.Cacheable;
import edu.uiuc.ncsa.security.core.cache.CachedObject;
import edu.uiuc.ncsa.security.core.cache.SimpleEntryImpl;
import java.util.Collection;
import java.util.HashSet;
import java.util.Map;
import java.util.Set;

public abstract class CachedMapFacade<V extends Cacheable>
implements Store<V> {
    Cache cache;
    Store<V> theStore;

    public CachedMapFacade(Store<V> theStore) {
        this.theStore = theStore;
    }

    public CachedMapFacade() {
    }

    public Cache getCache() {
        if (this.cache == null) {
            this.cache = new Cache();
        }
        return this.cache;
    }

    public void setCache(Cache cache) {
        this.cache = cache;
    }

    public Store<V> getTheStore() {
        return this.theStore;
    }

    public void setTheStore(Store<V> theStore) {
        this.theStore = theStore;
    }

    public boolean hasStore() {
        return this.theStore != null;
    }

    @Override
    public void clear() {
        this.getCache().clear();
        if (this.hasStore()) {
            this.getTheStore().clear();
        }
    }

    @Override
    public boolean isEmpty() {
        if (this.hasStore()) {
            return this.getTheStore().size() == 0;
        }
        return this.getCache().size() == 0;
    }

    @Override
    public boolean containsKey(Object key) {
        if (this.getCache().containsKey(key)) {
            return true;
        }
        if (this.hasStore()) {
            return this.getTheStore().containsKey(key);
        }
        return false;
    }

    @Override
    public boolean containsValue(Object value) {
        if (this.getCache().containsObject((Cacheable)value)) {
            return true;
        }
        if (this.hasStore()) {
            return this.getTheStore().containsValue(value);
        }
        return false;
    }

    @Override
    public V get(Object key) {
        if (this.getCache().containsKey(key)) {
            return (V)((Cacheable)this.getCache().get(key).getValue());
        }
        Cacheable it = null;
        if (this.hasStore() && (it = (Cacheable)this.getTheStore().get(key)) != null) {
            this.getCache().add(it);
        }
        return (V)it;
    }

    @Override
    public V put(Identifier key, V cacheable) {
        Cacheable it = null;
        if (this.getCache().containsKey(key)) {
            it = (Cacheable)this.getCache().get(key).getValue();
        }
        if (it == null && this.hasStore()) {
            it = (Cacheable)this.getTheStore().get(key);
        }
        this.getCache().add((Cacheable)cacheable);
        return (V)it;
    }

    @Override
    public V remove(Object key) {
        Cacheable it = null;
        CachedObject co = this.getCache().remove(key);
        if (co != null) {
            it = (Cacheable)co.getValue();
        }
        if (it == null && this.hasStore()) {
            it = (Cacheable)this.getTheStore().get(key);
        }
        if (this.hasStore()) {
            this.getTheStore().remove(key);
        }
        return (V)it;
    }

    @Override
    public void putAll(Map<? extends Identifier, ? extends V> m) {
        for (Map.Entry<Identifier, V> e2 : m.entrySet()) {
            this.getCache().add((Cacheable)e2.getValue());
        }
        if (this.hasStore()) {
            this.getTheStore().putAll(m);
        }
    }

    @Override
    public Set<Map.Entry<Identifier, V>> entrySet() {
        if (this.hasStore()) {
            return this.getTheStore().entrySet();
        }
        HashSet<Map.Entry<Identifier, V>> entries = new HashSet<Map.Entry<Identifier, V>>();
        for (Identifier key : this.keySet()) {
            entries.add(new SimpleEntryImpl<Identifier, Object>(key, this.get(key)));
        }
        return entries;
    }

    @Override
    public int size() {
        return this.keySet().size();
    }

    @Override
    public Set<Identifier> keySet() {
        if (this.hasStore()) {
            return this.getTheStore().keySet();
        }
        return this.getCache().keySet();
    }

    @Override
    public Collection<V> values() {
        if (this.hasStore()) {
            return this.getTheStore().values();
        }
        return this.getCache().objectValues();
    }
}

