/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client.storage;

import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetSerializationKeys;
import edu.uiuc.ncsa.security.core.IdentifiableProvider;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.storage.data.ConversionMap;
import edu.uiuc.ncsa.security.storage.data.MapConverter;
import edu.uiuc.ncsa.security.storage.data.SerializationKeys;
import edu.uiuc.ncsa.security.util.pkcs.CertUtil;
import edu.uiuc.ncsa.security.util.pkcs.KeyUtil;
import java.security.cert.CertificateException;

public class AssetConverter
extends MapConverter<Asset> {
    public AssetConverter(SerializationKeys keys, IdentifiableProvider<Asset> provider) {
        super(keys, provider);
    }

    protected AssetSerializationKeys getAR() {
        return (AssetSerializationKeys)this.keys;
    }

    @Override
    public Asset fromMap(ConversionMap<String, Object> map, Asset asset) {
        super.fromMap(map, asset);
        asset.setUsername(map.getString(this.getAR().username(new String[0])));
        try {
            String rawCert = map.getString(this.getAR().certificates(new String[0]));
            if (rawCert != null && 0 < rawCert.length()) {
                asset.setCertificates(CertUtil.fromX509PEM(rawCert));
            }
        }
        catch (CertificateException e2) {
            throw new GeneralException("Error: could not create certificate", e2);
        }
        String temp = map.getString(this.getAR().privateKey(new String[0]));
        if (temp != null) {
            asset.setPrivateKey(KeyUtil.fromPKCS8PEM(temp));
        }
        asset.setRedirect(map.getURI(this.getAR().redirect(new String[0])));
        asset.setCreationTime(map.getDate(this.getAR().creationTime(new String[0])));
        asset.setToken(map.getIdentifier(this.getAR().token(new String[0])));
        String rawCertReq = map.getString(this.getAR().certReq(new String[0]));
        if (rawCertReq != null) {
            asset.setCertReq(CertUtil.fromStringToCertReq(rawCertReq));
        }
        return asset;
    }

    @Override
    public void toMap(Asset asset, ConversionMap<String, Object> map) {
        super.toMap(asset, map);
        if (asset.getPrivateKey() != null) {
            map.put(this.getAR().privateKey(new String[0]), KeyUtil.toPKCS8PEM(asset.getPrivateKey()));
        }
        if (asset.getRedirect() != null) {
            map.put(this.getAR().redirect(new String[0]), asset.getRedirect().toString());
        }
        if (asset.getCertificates() != null) {
            map.put(this.getAR().certificates(new String[0]), CertUtil.toPEM(asset.getCertificates()));
        }
        if (asset.getUsername() != null && 0 < asset.getUsername().length()) {
            map.put(this.getAR().username(new String[0]), asset.getUsername());
        }
        if (asset.getCreationTime() != null) {
            map.put(this.getAR().creationTime(new String[0]), asset.getCreationTime());
        }
        if (asset.getCertReq() != null) {
            map.put(this.getAR().certReq(new String[0]), CertUtil.fromCertReqToString(asset.getCertReq()));
        }
        if (asset.getToken() != null) {
            map.put(this.getAR().token(new String[0]), asset.getToken());
        }
    }
}

