/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy.oa4mp.client;

import edu.uiuc.ncsa.myproxy.oa4mp.client.Asset;
import edu.uiuc.ncsa.myproxy.oa4mp.client.AssetResponse;
import edu.uiuc.ncsa.myproxy.oa4mp.client.ClientEnvironment;
import edu.uiuc.ncsa.myproxy.oa4mp.client.OA4MPResponse;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetProvider;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.AssetStore;
import edu.uiuc.ncsa.myproxy.oa4mp.client.storage.MemoryAssetStore;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.BasicIdentifier;
import edu.uiuc.ncsa.security.delegation.client.request.DelegatedAssetRequest;
import edu.uiuc.ncsa.security.delegation.client.request.DelegatedAssetResponse;
import edu.uiuc.ncsa.security.delegation.client.request.DelegationRequest;
import edu.uiuc.ncsa.security.delegation.client.request.DelegationResponse;
import edu.uiuc.ncsa.security.delegation.token.AuthorizationGrant;
import edu.uiuc.ncsa.security.delegation.token.MyX509Certificates;
import edu.uiuc.ncsa.security.delegation.token.Verifier;
import edu.uiuc.ncsa.security.util.pkcs.Base64String;
import edu.uiuc.ncsa.security.util.pkcs.KeyUtil;
import java.net.URI;
import java.security.KeyPair;
import java.security.NoSuchAlgorithmException;
import java.security.NoSuchProviderException;
import java.util.HashMap;
import java.util.Map;

public abstract class AbstractOA4MPService {
    AssetStore assetStore;
    public static final String SKIN_PARAMETER = "skin";
    ClientEnvironment environment;
    AssetProvider assetProvider;
    protected String BASE64_URI_CAPUT = "b64:";
    long keypairExpiration = 0L;
    KeyPair keyPair = null;

    protected AssetStore getAssetStore() {
        if (this.assetStore == null) {
            this.assetStore = this.getEnvironment().hasAssetStore() ? this.getEnvironment().getAssetStore() : new MemoryAssetStore(this.getAssetProvider());
        }
        return this.assetStore;
    }

    protected AbstractOA4MPService(ClientEnvironment environment) {
        this.environment = environment;
    }

    public ClientEnvironment getEnvironment() {
        return this.environment;
    }

    public abstract void preRequestCert(Asset var1, Map var2);

    public abstract void preGetCert(Asset var1, Map var2);

    public abstract void postRequestCert(Asset var1, OA4MPResponse var2);

    public abstract void postGetCert(Asset var1, AssetResponse var2);

    public OA4MPResponse requestCert() {
        return this.requestCert((Identifier)null);
    }

    public OA4MPResponse requestCert(Identifier identifier) {
        HashMap m = new HashMap();
        return this.requestCert(identifier, m);
    }

    public AssetProvider getAssetProvider() {
        return this.assetProvider;
    }

    public void setAssetProvider(AssetProvider assetProvider) {
        this.assetProvider = assetProvider;
    }

    public OA4MPResponse requestCert(Identifier identifier, Map additionalParameters) {
        if (additionalParameters == null) {
            additionalParameters = new HashMap();
        }
        AssetProvider assetProvider = this.getEnvironment().getAssetProvider();
        Object asset = null;
        asset = identifier == null ? assetProvider.get(false) : assetProvider.get(identifier);
        OA4MPResponse response = this.requestCert((Asset)asset, additionalParameters);
        ((Asset)asset).setPrivateKey(response.getPrivateKey());
        ((Asset)asset).setRedirect(response.getRedirect());
        this.getAssetStore().save(asset);
        return response;
    }

    public OA4MPResponse requestCert(Map additionalParameters) {
        return this.requestCert((Identifier)null, additionalParameters);
    }

    protected Identifier makeb64Uri(String x) {
        Base64String b64 = new Base64String(x.getBytes());
        Identifier id = BasicIdentifier.newID(this.BASE64_URI_CAPUT + b64);
        return id;
    }

    protected KeyPair getNextKeyPair() {
        if (this.keyPair == null || this.getEnvironment().getKeypairLifetime() <= 0L || this.keypairExpiration < System.currentTimeMillis()) {
            try {
                this.keyPair = KeyUtil.generateKeyPair();
            }
            catch (NoSuchProviderException e2) {
                e2.printStackTrace();
            }
            catch (NoSuchAlgorithmException e3) {
                e3.printStackTrace();
            }
            this.keypairExpiration = System.currentTimeMillis() + this.getEnvironment().getKeypairLifetime();
        }
        return this.keyPair;
    }

    protected OA4MPResponse requestCert(Asset asset, Map additionalParameters) {
        if (additionalParameters == null) {
            additionalParameters = new HashMap<String, String>();
        }
        try {
            this.preRequestCert(asset, additionalParameters);
            OA4MPResponse mpdsResponse = new OA4MPResponse();
            mpdsResponse.setPrivateKey(asset.getPrivateKey());
            DelegationRequest daReq = new DelegationRequest();
            daReq.setParameters(additionalParameters);
            daReq.setClient(this.getEnvironment().getClient());
            daReq.setBaseUri(this.getEnvironment().getAuthorizationUri());
            DelegationResponse daResp = (DelegationResponse)this.getEnvironment().getDelegationService().process(daReq);
            if (daResp.getAuthorizationGrant() != null) {
                asset.setToken(BasicIdentifier.newID(daResp.getAuthorizationGrant().getToken()));
                if (asset.getIdentifier() == null) {
                    asset.setIdentifier(this.makeb64Uri(daResp.getAuthorizationGrant().getToken().toString()));
                }
            }
            String skin = this.getEnvironment().getSkin();
            String r = daResp.getRedirectUri().toString();
            if (skin != null) {
                r = r + "&" + SKIN_PARAMETER + "=" + skin;
            }
            mpdsResponse.setRedirect(URI.create(r));
            this.getAssetStore().save(asset);
            this.postRequestCert(asset, mpdsResponse);
            return mpdsResponse;
        }
        catch (Throwable e2) {
            if (e2 instanceof RuntimeException) {
                throw (RuntimeException)e2;
            }
            throw new GeneralException("Error generating request", e2);
        }
    }

    public AssetResponse getCert(String tempToken, String verifier) {
        return this.getCert(tempToken, verifier, null);
    }

    public AssetResponse getCert(String tempToken, String verifier, Identifier identifier) {
        Asset asset = null;
        Identifier realId = null;
        realId = identifier == null ? this.makeb64Uri(tempToken) : identifier;
        if (realId == null) {
            throw new IllegalArgumentException("Error: no identifier found for this transaction. Cannot retrieve asset.");
        }
        asset = (Asset)this.getAssetStore().get(realId);
        if (asset == null && tempToken != null) {
            asset = this.getAssetStore().getByToken(BasicIdentifier.newID(tempToken));
        }
        if (asset == null) {
            String currentID = tempToken == null ? realId.toString() : tempToken;
            throw new IllegalArgumentException("Error:No asset with the given identifier \"" + currentID + "\" found. " + "You might need to clear your cookies and retry the entire request.");
        }
        AuthorizationGrant ag = this.getEnvironment().getTokenForge().getAuthorizationGrant(tempToken);
        Verifier v = null;
        if (verifier != null) {
            v = this.getEnvironment().getTokenForge().getVerifier(verifier);
        }
        return this.getCert(asset, ag, v);
    }

    protected Map<String, String> getATParameters(Asset asset, AuthorizationGrant ag, Verifier v) {
        HashMap<String, String> m = new HashMap<String, String>();
        m.put(this.getEnvironment().getConstants().get("oa4mp:callback_uri"), this.getEnvironment().getCallback().toString());
        return m;
    }

    protected Map<String, String> getAssetParameters(Asset asset) {
        HashMap<String, String> m1 = new HashMap<String, String>();
        m1.put(this.getEnvironment().getConstants().get("oa4mp:callback_uri"), this.getEnvironment().getCallback().toString());
        return m1;
    }

    protected AssetResponse getCert(Asset asset, AuthorizationGrant ag, Verifier v) {
        DelegatedAssetRequest dar = new DelegatedAssetRequest();
        dar.setAuthorizationGrant(ag);
        dar.setClient(this.getEnvironment().getClient());
        dar.setVerifier(v);
        dar.setParameters(this.getATParameters(asset, ag, v));
        Map<String, String> m1 = this.getAssetParameters(asset);
        this.preGetCert(asset, m1);
        dar.setAssetParameters(m1);
        DelegatedAssetResponse daResp = (DelegatedAssetResponse)this.getEnvironment().getDelegationService().process(dar);
        AssetResponse par = new AssetResponse();
        MyX509Certificates myX509Certificate = (MyX509Certificates)daResp.getProtectedAsset();
        par.setX509Certificates(myX509Certificate.getX509Certificates());
        par.setUsername(daResp.getAdditionalInformation().get("username"));
        this.postGetCert(asset, par);
        asset.setUsername(par.getUsername());
        asset.setCertificates(par.getX509Certificates());
        this.getEnvironment().getAssetStore().save(asset);
        return par;
    }
}

