/*
 * Decompiled with CFR 0.152.
 */
package edu.uiuc.ncsa.myproxy;

import edu.uiuc.ncsa.myproxy.MyProxyConnectable;
import edu.uiuc.ncsa.myproxy.MyProxyLogon;
import edu.uiuc.ncsa.myproxy.MyProxyServiceFacade;
import edu.uiuc.ncsa.security.core.Identifiable;
import edu.uiuc.ncsa.security.core.Identifier;
import edu.uiuc.ncsa.security.core.exceptions.ConnectionException;
import edu.uiuc.ncsa.security.core.exceptions.GeneralException;
import edu.uiuc.ncsa.security.core.util.MyLoggingFacade;
import edu.uiuc.ncsa.security.util.pkcs.MyPKCS10CertRequest;
import java.io.IOException;
import java.security.GeneralSecurityException;
import java.security.cert.X509Certificate;
import java.util.LinkedList;
import javax.inject.Provider;
import javax.net.ssl.KeyManagerFactory;

public class MPSingleConnectionProvider<T extends MyProxyConnectable>
implements Provider<T> {
    String username;
    String hostname;
    String password;
    int port;
    long socketTimeout = 0L;
    long lifetime;
    KeyManagerFactory keyManagerFactory;
    MyLoggingFacade facade;
    String serverDN;

    public MPSingleConnectionProvider(MyLoggingFacade logger, String username, String password, long lifetime, MyProxyServiceFacade facade) throws IOException, GeneralSecurityException {
        this(logger, username, password, null, lifetime, facade);
    }

    public MPSingleConnectionProvider(MyLoggingFacade logger, String username, String password, String loa, long lifetime, MyProxyServiceFacade facade) throws IOException, GeneralSecurityException {
        this(logger, username, password, facade.getFacadeConfiguration().getHostname(), facade.getLOAPort(loa), lifetime, facade.getFacadeConfiguration().getSocketTimeout(), facade.getKeyManagerFactory(), facade.getFacadeConfiguration().getServerDN());
    }

    public MPSingleConnectionProvider(MyLoggingFacade logger, String username, String password, String hostname, int port, long lifetime, long socketTimeout, KeyManagerFactory keyManagerFactory, String serverDN) {
        this.username = username;
        this.password = password == null ? "" : password;
        this.port = port;
        this.lifetime = lifetime;
        this.hostname = hostname;
        this.keyManagerFactory = keyManagerFactory;
        this.facade = logger;
        this.socketTimeout = socketTimeout;
        this.serverDN = serverDN;
    }

    @Override
    public T get() {
        MyProxyLogon myProxyLogon = null;
        myProxyLogon = this.facade == null ? new MyProxyLogon() : new MyProxyLogon(this.facade, this.serverDN);
        myProxyLogon.setHost(this.hostname);
        myProxyLogon.setLifetime((int)(this.lifetime / 1000L));
        myProxyLogon.setPort(this.port);
        myProxyLogon.setSocketTimeout(this.socketTimeout);
        myProxyLogon.setUsername(this.username);
        myProxyLogon.setPassphrase(this.password);
        myProxyLogon.setKeyManagerFactory(this.keyManagerFactory);
        return (T)new MyProxyLogonConnection(myProxyLogon);
    }

    public static class MyProxyLogonConnection
    implements MyProxyConnectable {
        MyProxyLogon myProxyLogon;
        Identifier identifier;

        public MyProxyLogonConnection(MyProxyLogon myProxyLogon) {
            this.myProxyLogon = myProxyLogon;
        }

        @Override
        public void setLifetime(long certLifetime) {
            if (this.myProxyLogon != null) {
                int newLifetime = (int)(certLifetime / 1000L);
                if (this.myProxyLogon.getLifetime() != newLifetime) {
                    this.myProxyLogon.setLifetime(newLifetime);
                    if (this.myProxyLogon.isConnected()) {
                        this.close();
                        this.open();
                    }
                }
            }
        }

        public MyProxyLogon getMyProxyLogon() {
            return this.myProxyLogon;
        }

        @Override
        public void close() {
            try {
                if (this.myProxyLogon.isConnected()) {
                    this.myProxyLogon.disconnect();
                }
            }
            catch (Throwable e2) {
                throw new ConnectionException("Error: disconnecting from myproxy", e2);
            }
        }

        @Override
        public void open() {
            try {
                this.myProxyLogon.connect();
                this.myProxyLogon.logon();
            }
            catch (Throwable e2) {
                throw new ConnectionException("Error: connecting to myproxy", e2);
            }
        }

        public String toString() {
            String out = this.getClass().getSimpleName() + "[";
            out = this.myProxyLogon == null ? out + "(no myproxy logon)" : out + "lifetime=" + this.myProxyLogon.getLifetime() + ", port=" + this.myProxyLogon.getPort() + ", host=" + this.myProxyLogon.getHost();
            return out + "]";
        }

        @Override
        public LinkedList<X509Certificate> getCerts(byte[] pkcs10CertRequest) {
            try {
                this.myProxyLogon.getCredentials(pkcs10CertRequest);
                LinkedList<X509Certificate> certList = new LinkedList<X509Certificate>();
                certList.addAll(this.myProxyLogon.getCertificates());
                return certList;
            }
            catch (Throwable e2) {
                throw new GeneralException("Error: getting certs from myproxy", e2);
            }
        }

        @Override
        public LinkedList<X509Certificate> getCerts(MyPKCS10CertRequest pkcs10CertRequest) {
            return this.getCerts(pkcs10CertRequest.getEncoded());
        }

        @Override
        public Identifier getIdentifier() {
            return this.identifier;
        }

        @Override
        public String getIdentifierString() {
            if (this.identifier == null) {
                return null;
            }
            return this.identifier.toString();
        }

        @Override
        public void setIdentifier(Identifier identifier) {
            this.identifier = identifier;
        }

        @Override
        public Identifiable clone() {
            return null;
        }
    }
}

