/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import com.nimbusds.jose.JWSAlgorithm;
import com.nimbusds.jose.crypto.BaseJWSProvider;
import java.security.InvalidAlgorithmParameterException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import java.security.Signature;
import java.security.spec.MGF1ParameterSpec;
import java.security.spec.PSSParameterSpec;
import java.util.Collections;
import java.util.HashSet;
import java.util.Set;

abstract class RSASSAProvider
extends BaseJWSProvider {
    public static final Set<JWSAlgorithm> SUPPORTED_ALGORITHMS;

    protected RSASSAProvider() {
        super(SUPPORTED_ALGORITHMS);
    }

    protected static Signature getRSASignerAndVerifier(JWSAlgorithm alg, Provider provider) throws JOSEException {
        Signature signature;
        String internalAlgName;
        PSSParameterSpec pssSpec = null;
        if (alg.equals(JWSAlgorithm.RS256)) {
            internalAlgName = "SHA256withRSA";
        } else if (alg.equals(JWSAlgorithm.RS384)) {
            internalAlgName = "SHA384withRSA";
        } else if (alg.equals(JWSAlgorithm.RS512)) {
            internalAlgName = "SHA512withRSA";
        } else if (alg.equals(JWSAlgorithm.PS256)) {
            internalAlgName = "SHA256withRSAandMGF1";
            pssSpec = new PSSParameterSpec("SHA256", "MGF1", MGF1ParameterSpec.SHA256, 32, 1);
        } else if (alg.equals(JWSAlgorithm.PS384)) {
            internalAlgName = "SHA384withRSAandMGF1";
            pssSpec = new PSSParameterSpec("SHA384", "MGF1", MGF1ParameterSpec.SHA384, 48, 1);
        } else if (alg.equals(JWSAlgorithm.PS512)) {
            internalAlgName = "SHA512withRSAandMGF1";
            pssSpec = new PSSParameterSpec("SHA512", "MGF1", MGF1ParameterSpec.SHA512, 64, 1);
        } else {
            throw new JOSEException("Unsupported RSASSA algorithm, must be RS256, RS384, RS512, PS256, PS384 or PS512");
        }
        try {
            signature = provider != null ? Signature.getInstance(internalAlgName, provider) : Signature.getInstance(internalAlgName);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new JOSEException("Unsupported RSASSA algorithm: " + e2.getMessage(), e2);
        }
        if (pssSpec != null) {
            try {
                signature.setParameter(pssSpec);
            }
            catch (InvalidAlgorithmParameterException e3) {
                throw new JOSEException("Invalid RSASSA-PSS salt length parameter: " + e3.getMessage(), e3);
            }
        }
        return signature;
    }

    static {
        HashSet<JWSAlgorithm> algs = new HashSet<JWSAlgorithm>();
        algs.add(JWSAlgorithm.RS256);
        algs.add(JWSAlgorithm.RS384);
        algs.add(JWSAlgorithm.RS512);
        algs.add(JWSAlgorithm.PS256);
        algs.add(JWSAlgorithm.PS384);
        algs.add(JWSAlgorithm.PS512);
        SUPPORTED_ALGORITHMS = Collections.unmodifiableSet(algs);
    }
}

