/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose.crypto;

import com.nimbusds.jose.JOSEException;
import java.security.InvalidKeyException;
import java.security.NoSuchAlgorithmException;
import java.security.Provider;
import javax.crypto.Mac;
import javax.crypto.SecretKey;
import javax.crypto.spec.SecretKeySpec;
import net.jcip.annotations.ThreadSafe;

@ThreadSafe
class HMAC {
    HMAC() {
    }

    public static byte[] compute(String alg, byte[] secret, byte[] message, Provider provider) throws JOSEException {
        return HMAC.compute(new SecretKeySpec(secret, alg), message, provider);
    }

    public static byte[] compute(SecretKey secretKey, byte[] message, Provider provider) throws JOSEException {
        Mac mac;
        try {
            mac = provider != null ? Mac.getInstance(secretKey.getAlgorithm(), provider) : Mac.getInstance(secretKey.getAlgorithm());
            mac.init(secretKey);
        }
        catch (NoSuchAlgorithmException e2) {
            throw new JOSEException("Unsupported HMAC algorithm: " + e2.getMessage(), e2);
        }
        catch (InvalidKeyException e3) {
            throw new JOSEException("Invalid HMAC key: " + e3.getMessage(), e3);
        }
        mac.update(message);
        return mac.doFinal();
    }
}

