/*
 * Decompiled with CFR 0.152.
 */
package com.nimbusds.jose;

import com.nimbusds.jose.util.Base64URL;
import com.nimbusds.jose.util.JSONObjectUtils;
import java.nio.charset.Charset;
import java.text.ParseException;
import net.jcip.annotations.Immutable;
import net.minidev.json.JSONObject;

@Immutable
public final class Payload {
    private static final Charset CHARSET = Charset.forName("UTF-8");
    private Origin origin;
    private JSONObject jsonView = null;
    private String stringView = null;
    private byte[] bytesView = null;
    private Base64URL base64URLView = null;

    private static String byteArrayToString(byte[] bytes) {
        if (bytes == null) {
            return null;
        }
        return new String(bytes, CHARSET);
    }

    private static byte[] stringToByteArray(String string) {
        if (string == null) {
            return null;
        }
        return string.getBytes(CHARSET);
    }

    public Payload(JSONObject json) {
        if (json == null) {
            throw new IllegalArgumentException("The JSON object must not be null");
        }
        this.jsonView = json;
        this.origin = Origin.JSON;
    }

    public Payload(String string) {
        if (string == null) {
            throw new IllegalArgumentException("The string must not be null");
        }
        this.stringView = string;
        this.origin = Origin.STRING;
    }

    public Payload(byte[] bytes) {
        if (bytes == null) {
            throw new IllegalArgumentException("The byte array must not be null");
        }
        this.bytesView = bytes;
        this.origin = Origin.BYTE_ARRAY;
    }

    public Payload(Base64URL base64URL) {
        if (base64URL == null) {
            throw new IllegalArgumentException("The Base64URL-encoded object must not be null");
        }
        this.base64URLView = base64URL;
        this.origin = Origin.BASE64URL;
    }

    public Origin getOrigin() {
        return this.origin;
    }

    public JSONObject toJSONObject() {
        if (this.jsonView != null) {
            return this.jsonView;
        }
        if (this.stringView != null) {
            try {
                this.jsonView = JSONObjectUtils.parseJSONObject(this.stringView);
            }
            catch (ParseException e2) {}
        } else if (this.bytesView != null) {
            this.stringView = Payload.byteArrayToString(this.bytesView);
            try {
                this.jsonView = JSONObjectUtils.parseJSONObject(this.stringView);
            }
            catch (ParseException e3) {}
        } else if (this.base64URLView != null) {
            this.stringView = this.base64URLView.decodeToString();
            try {
                this.jsonView = JSONObjectUtils.parseJSONObject(this.stringView);
            }
            catch (ParseException parseException) {
                // empty catch block
            }
        }
        return this.jsonView;
    }

    public String toString() {
        if (this.stringView != null) {
            return this.stringView;
        }
        if (this.jsonView != null) {
            this.stringView = this.jsonView.toString();
        } else if (this.bytesView != null) {
            this.stringView = Payload.byteArrayToString(this.bytesView);
        } else if (this.base64URLView != null) {
            this.stringView = this.base64URLView.decodeToString();
        }
        return this.stringView;
    }

    public byte[] toBytes() {
        if (this.bytesView != null) {
            return this.bytesView;
        }
        if (this.stringView != null) {
            this.bytesView = Payload.stringToByteArray(this.stringView);
        } else if (this.jsonView != null) {
            this.stringView = this.jsonView.toString();
            this.bytesView = Payload.stringToByteArray(this.stringView);
        } else if (this.base64URLView != null) {
            this.bytesView = this.base64URLView.decode();
        }
        return this.bytesView;
    }

    public Base64URL toBase64URL() {
        if (this.base64URLView != null) {
            return this.base64URLView;
        }
        if (this.stringView != null) {
            this.base64URLView = Base64URL.encode(this.stringView);
        } else if (this.bytesView != null) {
            this.base64URLView = Base64URL.encode(this.bytesView);
        } else if (this.jsonView != null) {
            this.stringView = this.jsonView.toString();
            this.base64URLView = Base64URL.encode(this.stringView);
        }
        return this.base64URLView;
    }

    public static enum Origin {
        JSON,
        STRING,
        BYTE_ARRAY,
        BASE64URL;

    }
}

