/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.rdf.model.Model;
import com.hp.hpl.jena.rdf.model.ModelFactory;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.rdf.model.test.ModelTestBase;
import com.hp.hpl.jena.reasoner.Reasoner;
import com.hp.hpl.jena.reasoner.ReasonerFactory;
import com.hp.hpl.jena.reasoner.rulesys.GenericRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.impl.WrappedReasonerFactory;
import java.util.ArrayList;
import java.util.Arrays;
import java.util.List;
import junit.framework.Assert;
import junit.framework.TestSuite;

public class TestSetRules
extends ModelTestBase {
    static final List rules = Rule.parseRules("[name: (?s owl:foo ?p) -> (?s ?p ?a)]");
    private static Resource emptyResource = ModelFactory.createDefaultModel().createResource();

    public TestSetRules(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestSetRules.class);
    }

    public void testRuleReasonerWrapper() {
        MockFactory mock = new MockFactory();
        ReasonerFactory wrapped = TestSetRules.wrap(mock);
        TestSetRules.assertEquals((Object)MockFactory.capabilities, (Object)wrapped.getCapabilities());
        TestSetRules.assertEquals((String)"eg:mockURI", (String)wrapped.getURI());
        TestSetRules.assertEquals((Object)MockFactory.reasoner, (Object)wrapped.create(null));
        TestSetRules.assertEquals(Arrays.asList("capabilities", "uri", "create"), (Object)mock.done);
    }

    private static ReasonerFactory wrap(ReasonerFactory rrf) {
        return new WrappedReasonerFactory(rrf, emptyResource);
    }

    private static class MockFactory
    implements ReasonerFactory {
        List done = new ArrayList();
        static final Model capabilities = ModelTestBase.modelWithStatements("this isA Capability");
        static final String uri = "eg:mockURI";
        static final Reasoner reasoner = new GenericRuleReasoner(rules);

        private MockFactory() {
        }

        public void addRules(List rules) {
            Assert.assertEquals((Object)TestSetRules.rules, (Object)rules);
            this.done.add("addRules");
        }

        public Reasoner create(Resource configuration) {
            this.done.add("create");
            return reasoner;
        }

        public Model getCapabilities() {
            this.done.add("capabilities");
            return capabilities;
        }

        public String getURI() {
            this.done.add("uri");
            return uri;
        }
    }
}

