/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.reasoner.rulesys.test;

import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.reasoner.InfGraph;
import com.hp.hpl.jena.reasoner.rulesys.BasicForwardRuleReasoner;
import com.hp.hpl.jena.reasoner.rulesys.Rule;
import com.hp.hpl.jena.reasoner.rulesys.Util;
import com.hp.hpl.jena.util.PrintUtil;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import java.io.IOException;
import java.util.List;

public class DebugRules {
    public static final String ruleFile = "etc/temp.rules";
    public List ruleset;

    public DebugRules(String rulefileName) throws IOException {
        this.ruleset = Rule.parseRules(Util.loadRuleParserFromResourceFile(rulefileName));
    }

    public void run() {
        BasicForwardRuleReasoner reasoner = new BasicForwardRuleReasoner(this.ruleset);
        InfGraph result = reasoner.bind(Factory.createGraphMem());
        System.out.println("Final graph state");
        ExtendedIterator i = result.find(null, null, null);
        while (i.hasNext()) {
            System.out.println(PrintUtil.print((Triple)i.next()));
        }
    }

    public static void main(String[] args) {
        try {
            DebugRules tester = new DebugRules(ruleFile);
            tester.run();
        }
        catch (Exception e2) {
            System.out.println("Problem: " + e2);
        }
    }
}

