/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.test;

import com.hp.hpl.jena.db.impl.DBReifier;
import com.hp.hpl.jena.graph.Factory;
import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Reifier;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.TripleMatch;
import com.hp.hpl.jena.graph.impl.GraphBase;
import com.hp.hpl.jena.graph.test.GraphTestBase;
import com.hp.hpl.jena.shared.AlreadyReifiedException;
import com.hp.hpl.jena.shared.CannotReifyException;
import com.hp.hpl.jena.shared.ReificationStyle;
import com.hp.hpl.jena.util.CollectionFactory;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.vocabulary.RDF;
import java.util.Collections;

public abstract class AbstractTestReifier
extends GraphTestBase {
    protected static final ReificationStyle Minimal = ReificationStyle.Minimal;
    protected static final ReificationStyle Standard = ReificationStyle.Standard;
    protected static final ReificationStyle Convenient = ReificationStyle.Convenient;
    protected static final Triple ALL = Triple.create("?? ?? ??");

    public AbstractTestReifier(String name) {
        super(name);
    }

    public abstract Graph getGraph();

    public abstract Graph getGraph(ReificationStyle var1);

    protected final Graph getGraphWith(String facts) {
        Graph result = this.getGraph();
        AbstractTestReifier.graphAdd(result, facts);
        return result;
    }

    protected final Graph graphWithUnless(boolean cond, String facts) {
        return AbstractTestReifier.graphWith(cond ? "" : facts);
    }

    protected final Graph graphWithIf(boolean cond, String facts) {
        return this.graphWithUnless(!cond, facts);
    }

    public void testStyle() {
        AbstractTestReifier.assertSame((Object)Minimal, (Object)this.getGraph(Minimal).getReifier().getStyle());
        AbstractTestReifier.assertSame((Object)Standard, (Object)this.getGraph(Standard).getReifier().getStyle());
        AbstractTestReifier.assertSame((Object)Convenient, (Object)this.getGraph(Convenient).getReifier().getStyle());
    }

    public void testEmptyReifiers() {
        AbstractTestReifier.assertFalse((boolean)this.getGraphWith("x R y").getReifier().findExposed(ALL).hasNext());
        AbstractTestReifier.assertFalse((boolean)this.getGraphWith("x R y; p S q").getReifier().findExposed(ALL).hasNext());
    }

    public void testSameReifier() {
        Graph G = this.getGraph();
        Reifier R1 = G.getReifier();
        G.add(AbstractTestReifier.triple("x R y"));
        AbstractTestReifier.assertTrue((String)"same reifier", (R1 == G.getReifier() ? (byte)1 : 0) != 0);
    }

    public void testReifierClosed() {
        Graph g = this.getGraph();
        Reifier r = g.getReifier();
        g.close();
    }

    public void testParent() {
        Graph G = this.getGraph();
        Graph H = this.getGraph();
        AbstractTestReifier.assertTrue((String)"correct reifier (G)", (G == G.getReifier().getParentGraph() ? (byte)1 : 0) != 0);
        AbstractTestReifier.assertTrue((String)"correct reifier (H)", (H == H.getReifier().getParentGraph() ? (byte)1 : 0) != 0);
    }

    public void testIntercept() {
        Graph g = this.getGraph(Convenient);
        Reifier r = g.getReifier();
        Node S = AbstractTestReifier.node("sub");
        Node O = AbstractTestReifier.node("obj");
        Node RS = AbstractTestReifier.node("http://example.org/type");
        AbstractTestReifier.assertFalse((String)"reifier must not intercept quadlet", (boolean)r.handledAdd(Triple.create(S, RDF.Nodes.type, RS)));
        AbstractTestReifier.assertFalse((String)"reifier must not intercept quadlet", (boolean)r.handledAdd(Triple.create(S, S, RDF.Nodes.subject)));
        AbstractTestReifier.assertFalse((String)"reifier must not intercept quadlet", (boolean)r.handledAdd(Triple.create(S, S, RDF.Nodes.type)));
        AbstractTestReifier.assertTrue((String)"reifier must intercept quadlet", (boolean)r.handledAdd(Triple.create(S, RDF.Nodes.predicate, O)));
        AbstractTestReifier.assertTrue((String)"reifier must intercept quadlet", (boolean)r.handledAdd(Triple.create(S, RDF.Nodes.type, RDF.Nodes.Statement)));
    }

    public void testStandard() {
        Graph g = this.getGraph(Standard);
        AbstractTestReifier.assertFalse((boolean)g.getReifier().hasTriple(AbstractTestReifier.triple("s p o")));
        g.add(Triple.create("x rdf:subject s"));
        AbstractTestReifier.assertEquals((int)1, (int)g.size());
        g.add(Triple.create("x rdf:predicate p"));
        AbstractTestReifier.assertEquals((int)2, (int)g.size());
        g.add(Triple.create("x rdf:object o"));
        AbstractTestReifier.assertEquals((int)3, (int)g.size());
        g.add(Triple.create("x rdf:type rdf:Statement"));
        AbstractTestReifier.assertEquals((int)4, (int)g.size());
        AbstractTestReifier.assertTrue((boolean)g.getReifier().hasTriple(AbstractTestReifier.triple("s p o")));
    }

    public void testStandardExplode() {
        Graph g = this.getGraph(Standard);
        g.getReifier().reifyAs(AbstractTestReifier.node("a"), AbstractTestReifier.triple("p Q r"));
        Graph r = Factory.createDefaultGraph(Minimal);
        AbstractTestReifier.graphAdd(r, "a rdf:type rdf:Statement; a rdf:subject p; a rdf:predicate Q; a rdf:object r");
        AbstractTestReifier.assertEquals((int)4, (int)g.size());
        AbstractTestReifier.assertIsomorphic(r, g);
    }

    public void testMinimalExplode() {
        Graph g = this.getGraph(Minimal);
        g.getReifier().reifyAs(AbstractTestReifier.node("a"), AbstractTestReifier.triple("p Q r"));
        AbstractTestReifier.assertEquals((int)0, (int)g.size());
    }

    public void testReificationTriplesConvenient() {
        this.testReificationTriples(Convenient);
    }

    public void testReificationTriplesStandard() {
        this.testReificationTriples(Standard);
    }

    public void testReificationQuadletsMinimal() {
        this.testReificationTriples(Minimal);
    }

    protected void testReificationTriples(ReificationStyle style) {
        Graph g = this.getGraph(style);
        Graph quadlets = AbstractTestReifier.getReificationTriples(g.getReifier());
        String S1 = "SSS rdf:predicate PPP";
        String S2 = "SSS rdf:subject SSS";
        g.add(AbstractTestReifier.triple(S1));
        AbstractTestReifier.assertIsomorphic(this.graphWithUnless(style == Minimal, S1), quadlets);
        g.add(AbstractTestReifier.triple(S2));
        AbstractTestReifier.assertIsomorphic(this.graphWithUnless(style == Minimal, S1 + "; " + S2), quadlets);
        AbstractTestReifier.assertEquals((String)"convenient hides quadlets", (style == Convenient ? (byte)1 : 0) != 0, (g.size() == 0 ? (byte)1 : 0) != 0);
    }

    public void testOverspecificationSuppressesReification() {
        block2: {
            Graph g = this.getGraph(Standard);
            Reifier r = g.getReifier();
            AbstractTestReifier.graphAdd(g, "x rdf:subject A; x rdf:predicate P; x rdf:object O; x rdf:type rdf:Statement");
            AbstractTestReifier.assertEquals((Object)AbstractTestReifier.triple("A P O"), (Object)r.getTriple(AbstractTestReifier.node("x")));
            try {
                AbstractTestReifier.graphAdd(g, "x rdf:subject BOOM");
                AbstractTestReifier.assertEquals(null, (Object)r.getTriple(AbstractTestReifier.node("x")));
            }
            catch (AlreadyReifiedException e2) {
                if (r instanceof DBReifier) break block2;
                throw e2;
            }
        }
    }

    public void testReificationSubjectClash() {
        this.testReificationClash("x rdf:subject SS");
    }

    public void testReificationPredicateClash() {
        this.testReificationClash("x rdf:predicate PP");
    }

    public void testReificationObjectClash() {
        this.testReificationClash("x rdf:object OO");
    }

    protected void testReificationClash(String clashingStatement) {
        block2: {
            Graph g = this.getGraph(Standard);
            Triple SPO = Triple.create("S P O");
            g.getReifier().reifyAs(AbstractTestReifier.node("x"), SPO);
            AbstractTestReifier.assertTrue((boolean)g.getReifier().hasTriple(SPO));
            try {
                AbstractTestReifier.graphAdd(g, clashingStatement);
                AbstractTestReifier.assertEquals(null, (Object)g.getReifier().getTriple(AbstractTestReifier.node("x")));
                AbstractTestReifier.assertFalse((boolean)g.getReifier().hasTriple(SPO));
            }
            catch (AlreadyReifiedException e2) {
                if (g.getReifier() instanceof DBReifier) break block2;
                throw e2;
            }
        }
    }

    public void testManifestQuadsStandard() {
        this.testManifestQuads(Standard);
    }

    public void testManifestQuadsConvenient() {
        this.testManifestQuads(Convenient);
    }

    public void testManifestQuadsMinimal() {
        this.testManifestQuads(Minimal);
    }

    public void testManifestQuads(ReificationStyle style) {
        Graph g = this.getGraph(style);
        Reifier r = g.getReifier();
        r.reifyAs(AbstractTestReifier.node("A"), AbstractTestReifier.triple("S P O"));
        String reified = "A rdf:type rdf:Statement; A rdf:subject S; A rdf:predicate P; A rdf:object O";
        AbstractTestReifier.assertIsomorphic(this.graphWithIf(style == Standard, reified), g);
    }

    public void testHiddenVsReificationMinimal() {
        this.testHiddenVsReification(Minimal);
    }

    public void testHiddenVsStandard() {
        this.testHiddenVsReification(Standard);
    }

    public void testHiddenVsReificationConvenient() {
        this.testHiddenVsReification(Convenient);
    }

    public void testHiddenVsReification(ReificationStyle style) {
        Graph g = this.getGraph(style);
        Reifier r = g.getReifier();
        r.reifyAs(AbstractTestReifier.node("A"), AbstractTestReifier.triple("S P O"));
        AbstractTestReifier.assertEquals((style == Standard ? (byte)1 : 0) != 0, (boolean)r.findEither(ALL, false).hasNext());
    }

    public void testRetrieveTriplesByNode() {
        Graph G = this.getGraph();
        Reifier R = G.getReifier();
        Node N = Node.createAnon();
        Node M = Node.createAnon();
        R.reifyAs(N, AbstractTestReifier.triple("x R y"));
        AbstractTestReifier.assertEquals((String)"gets correct triple", (Object)AbstractTestReifier.triple("x R y"), (Object)R.getTriple(N));
        R.reifyAs(M, AbstractTestReifier.triple("p S q"));
        AbstractTestReifier.assertDiffer("the anon nodes must be distinct", N, M);
        AbstractTestReifier.assertEquals((String)"gets correct triple", (Object)AbstractTestReifier.triple("p S q"), (Object)R.getTriple(M));
        AbstractTestReifier.assertTrue((String)"node is known bound", (boolean)R.hasTriple(M));
        AbstractTestReifier.assertTrue((String)"node is known bound", (boolean)R.hasTriple(N));
        AbstractTestReifier.assertFalse((String)"node is known unbound", (boolean)R.hasTriple(Node.createURI("any:thing")));
    }

    public void testRetrieveTriplesByTriple() {
        Graph G = this.getGraph();
        Reifier R = G.getReifier();
        Triple T = AbstractTestReifier.triple("x R y");
        Triple T2 = AbstractTestReifier.triple("y R x");
        Node N = AbstractTestReifier.node("someNode");
        R.reifyAs(N, T);
        AbstractTestReifier.assertTrue((String)"R must have T", (boolean)R.hasTriple(T));
        AbstractTestReifier.assertFalse((String)"R must not have T2", (boolean)R.hasTriple(T2));
    }

    public void testReifyAs() {
        Graph G = this.getGraph();
        Reifier R = G.getReifier();
        Node X = Node.createURI("some:uri");
        AbstractTestReifier.assertEquals((String)"node used", (Object)X, (Object)R.reifyAs(X, AbstractTestReifier.triple("x R y")));
        AbstractTestReifier.assertEquals((String)"retrieves correctly", (Object)AbstractTestReifier.triple("x R y"), (Object)R.getTriple(X));
    }

    public void testAllNodes() {
        Reifier R = this.getGraph().getReifier();
        R.reifyAs(AbstractTestReifier.node("x"), AbstractTestReifier.triple("cows eat grass"));
        R.reifyAs(AbstractTestReifier.node("y"), AbstractTestReifier.triple("pigs can fly"));
        R.reifyAs(AbstractTestReifier.node("z"), AbstractTestReifier.triple("dogs may bark"));
        AbstractTestReifier.assertEquals((String)"", (Object)this.nodeSet("z y x"), (Object)AbstractTestReifier.iteratorToSet(R.allNodes()));
    }

    public void testRemoveByNode() {
        Graph G = this.getGraph();
        Reifier R = G.getReifier();
        Node X = AbstractTestReifier.node("x");
        Node Y = AbstractTestReifier.node("y");
        R.reifyAs(X, AbstractTestReifier.triple("x R a"));
        R.reifyAs(Y, AbstractTestReifier.triple("y R a"));
        R.remove(X, AbstractTestReifier.triple("x R a"));
        AbstractTestReifier.assertFalse((String)"triple X has gone", (boolean)R.hasTriple(X));
        AbstractTestReifier.assertEquals((String)"triple Y still there", (Object)AbstractTestReifier.triple("y R a"), (Object)R.getTriple(Y));
    }

    public void testRemoveFromNothing() {
        Graph G = this.getGraph();
        Reifier R = G.getReifier();
        G.delete(AbstractTestReifier.triple("quint rdf:subject S"));
    }

    public void testException() {
        Graph G = this.getGraph();
        Reifier R = G.getReifier();
        Node X = AbstractTestReifier.node("x");
        R.reifyAs(X, AbstractTestReifier.triple("x R y"));
        R.reifyAs(X, AbstractTestReifier.triple("x R y"));
        try {
            R.reifyAs(X, AbstractTestReifier.triple("x R z"));
            AbstractTestReifier.fail((String)"did not detect already reified node");
        }
        catch (AlreadyReifiedException e2) {
            // empty catch block
        }
    }

    public void testKevinCaseA() {
        Graph G = this.getGraph(Standard);
        Node X = AbstractTestReifier.node("x");
        Node a = AbstractTestReifier.node("a");
        Node b = AbstractTestReifier.node("b");
        Node c = AbstractTestReifier.node("c");
        G.add(Triple.create(X, RDF.Nodes.type, RDF.Nodes.Statement));
        G.getReifier().reifyAs(X, Triple.create(a, b, c));
    }

    public void testKevinCaseB() {
        Graph G = this.getGraph(Standard);
        Node X = AbstractTestReifier.node("x");
        Node Y = AbstractTestReifier.node("y");
        Node a = AbstractTestReifier.node("a");
        Node b = AbstractTestReifier.node("b");
        Node c = AbstractTestReifier.node("c");
        G.add(Triple.create(X, RDF.Nodes.subject, Y));
        try {
            G.getReifier().reifyAs(X, Triple.create(a, b, c));
            AbstractTestReifier.fail((String)"X already has subject Y: cannot make it a");
        }
        catch (CannotReifyException e2) {
            AbstractTestReifier.pass();
        }
    }

    public void testDynamicHiddenTriples() {
        Graph g = this.getGraph(Minimal);
        Reifier r = g.getReifier();
        Graph h = this.getHiddenTriples(r);
        Graph wanted = AbstractTestReifier.graphWith("x rdf:type rdf:Statement; x rdf:subject a; x rdf:predicate B; x rdf:object c");
        AbstractTestReifier.assertTrue((boolean)h.isEmpty());
        r.reifyAs(AbstractTestReifier.node("x"), AbstractTestReifier.triple("a B c"));
        AbstractTestReifier.assertIsomorphic(wanted, h);
    }

    protected Graph getHiddenTriples(final Reifier r) {
        return new GraphBase(){

            public ExtendedIterator graphBaseFind(TripleMatch m) {
                return r.findEither(m, true);
            }
        };
    }

    public void testQuadRemove() {
        Graph g = this.getGraph(Standard);
        AbstractTestReifier.assertEquals((int)0, (int)g.size());
        Triple s = Triple.create("x rdf:subject s");
        Triple p = Triple.create("x rdf:predicate p");
        Triple o = Triple.create("x rdf:object o");
        Triple t = Triple.create("x rdf:type rdf:Statement");
        g.add(s);
        g.add(p);
        g.add(o);
        g.add(t);
        AbstractTestReifier.assertEquals((int)4, (int)g.size());
        g.delete(s);
        g.delete(p);
        g.delete(o);
        g.delete(t);
        AbstractTestReifier.assertEquals((int)0, (int)g.size());
    }

    public void testReifierSize() {
        Graph g = this.getGraph();
        Reifier r = g.getReifier();
        AbstractTestReifier.assertEquals((int)0, (int)r.size());
    }

    public void testEmpty() {
        Graph g = this.getGraph(Standard);
        AbstractTestReifier.assertTrue((boolean)g.isEmpty());
        AbstractTestReifier.graphAdd(g, "x rdf:type rdf:Statement");
        AbstractTestReifier.assertFalse((boolean)g.isEmpty());
        AbstractTestReifier.graphAdd(g, "x rdf:subject Deconstruction");
        AbstractTestReifier.assertFalse((boolean)g.isEmpty());
        AbstractTestReifier.graphAdd(g, "x rdf:predicate rdfs:subTypeOf");
        AbstractTestReifier.assertFalse((boolean)g.isEmpty());
        AbstractTestReifier.graphAdd(g, "x rdf:object LiteraryCriticism");
        AbstractTestReifier.assertFalse((boolean)g.isEmpty());
    }

    public void testReifierEmptyFind() {
        Graph g = this.getGraph(Standard);
        Reifier r = g.getReifier();
        AbstractTestReifier.assertEquals((Object)CollectionFactory.createHashedSet(), (Object)AbstractTestReifier.iteratorToSet(r.findExposed(AbstractTestReifier.triple("?? ?? ??"))));
    }

    public void testReifierFindSubject() {
        this.testReifierFind("x rdf:subject S");
    }

    public void testReifierFindObject() {
        this.testReifierFind("x rdf:object O");
    }

    public void testReifierFindPredicate() {
        this.testReifierFind("x rdf:predicate P");
    }

    public void testReifierFindComplete() {
        this.testReifierFind("x rdf:predicate P; x rdf:subject S; x rdf:object O; x rdf:type rdf:Statement");
    }

    public void testReifierFindFilter() {
        Graph g = this.getGraph(Standard);
        Reifier r = g.getReifier();
        AbstractTestReifier.graphAdd(g, "s rdf:subject S");
        AbstractTestReifier.assertEquals((Object)AbstractTestReifier.tripleSet(""), (Object)AbstractTestReifier.iteratorToSet(r.findExposed(AbstractTestReifier.triple("s otherPredicate S"))));
    }

    protected void testReifierFind(String triples) {
        this.testReifierFind(triples, "?? ?? ??");
    }

    protected void testReifierFind(String triples, String pattern) {
        Graph g = this.getGraph(Standard);
        Reifier r = g.getReifier();
        AbstractTestReifier.graphAdd(g, triples);
        AbstractTestReifier.assertEquals((Object)AbstractTestReifier.tripleSet(triples), (Object)AbstractTestReifier.iteratorToSet(r.findExposed(AbstractTestReifier.triple(pattern))));
    }

    public void testQuintetBug() {
        block2: {
            String spec = "rs rdf:type rdf:Statement; foo rdf:value rs; rs rdf:subject X; rs rdf:predicate P; rs rdf:object O1; rs rdf:object O2";
            Graph g = this.getGraph(Standard);
            Reifier r = g.getReifier();
            try {
                AbstractTestReifier.graphAdd(g, spec);
                Graph wanted = this.getGraph(Minimal);
                AbstractTestReifier.graphAdd(wanted, spec);
                AbstractTestReifier.assertIsomorphic(wanted, g);
            }
            catch (AlreadyReifiedException e2) {
                if (r instanceof DBReifier) break block2;
                throw e2;
            }
        }
    }

    public void testBulkClearReificationTriples() {
        Graph g = this.getGraphWith("x rdf:subject S");
        g.getBulkUpdateHandler().removeAll();
        AbstractTestReifier.assertEquals((String)("oops: " + g.getClass()), (Object)Collections.EMPTY_SET, (Object)g.find(Node.ANY, Node.ANY, Node.ANY).toSet());
    }

    public void testBulkClearReificationTriples2() {
        Graph g = this.getGraphWith("x rdf:subject S; x rdf:predicate P; x rdf:object O; x rdf:type rdf:Statement");
        g.getBulkUpdateHandler().removeAll();
        AbstractTestReifier.assertEquals((Object)Collections.EMPTY_SET, (Object)g.find(Node.ANY, Node.ANY, Node.ANY).toSet());
    }
}

