/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query.test;

import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.query.Domain;
import com.hp.hpl.jena.graph.query.test.QueryTestBase;
import java.util.ArrayList;
import junit.framework.TestSuite;

public class TestDomain
extends QueryTestBase {
    public TestDomain(String name) {
        super(name);
    }

    public static TestSuite suite() {
        return new TestSuite(TestDomain.class);
    }

    public void testDomainGet() {
        Domain d = this.domain("a 'b' 17 _x");
        TestDomain.assertEquals((Object)TestDomain.node("a"), (Object)d.get(0));
        TestDomain.assertEquals((Object)TestDomain.node("'b'"), (Object)d.get(1));
        TestDomain.assertEquals((Object)TestDomain.node("17"), (Object)d.get(2));
        TestDomain.assertEquals((Object)TestDomain.node("_x"), (Object)d.get(3));
    }

    public void testDomainGetElement() {
        Domain d = this.domain("X 'why' 42 _z9m9z");
        TestDomain.assertEquals((Object)TestDomain.node("X"), (Object)d.getElement(0));
        TestDomain.assertEquals((Object)TestDomain.node("'why'"), (Object)d.getElement(1));
        TestDomain.assertEquals((Object)TestDomain.node("42"), (Object)d.getElement(2));
        TestDomain.assertEquals((Object)TestDomain.node("_z9m9z"), (Object)d.getElement(3));
    }

    public void testSetElement() {
        Domain d = this.domain("A B C D");
        d.setElement(0, TestDomain.node("X"));
        TestDomain.assertEquals((Object)TestDomain.node("X"), (Object)d.getElement(0));
        d.setElement(2, TestDomain.node("Z"));
        TestDomain.assertEquals((Object)TestDomain.node("Z"), (Object)d.getElement(2));
        TestDomain.assertEquals((Object)TestDomain.node("X"), (Object)d.getElement(0));
    }

    public void testEqualsList() {
        Domain d = new Domain(2);
        ArrayList<Node> L = new ArrayList<Node>();
        d.setElement(0, TestDomain.node("a"));
        L.add(TestDomain.node("a"));
        d.setElement(1, TestDomain.node("b"));
        L.add(TestDomain.node("b"));
        TestDomain.assertEquals(L, (Object)d);
        TestDomain.assertEquals((Object)d, L);
    }

    public void testSize() {
        TestDomain.assertEquals((int)0, (int)this.domain("").size());
        TestDomain.assertEquals((int)1, (int)this.domain("X").size());
        TestDomain.assertEquals((int)5, (int)this.domain("a song in the wind").size());
    }

    public void testCopiesDistinctButEqual() {
        Domain d = this.domain("a lot of bottle");
        TestDomain.assertNotSame((Object)d, (Object)d.copy());
        TestDomain.assertEquals((Object)d, (Object)d.copy());
    }

    private Domain domain(String string) {
        return new Domain(TestDomain.nodeArray(string));
    }
}

