/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.graph.query;

import com.hp.hpl.jena.graph.Graph;
import com.hp.hpl.jena.graph.Node;
import com.hp.hpl.jena.graph.Triple;
import com.hp.hpl.jena.graph.query.BufferPipe;
import com.hp.hpl.jena.graph.query.ConstraintStage;
import com.hp.hpl.jena.graph.query.ExpressionSet;
import com.hp.hpl.jena.graph.query.Mapping;
import com.hp.hpl.jena.graph.query.NamedGraphMap;
import com.hp.hpl.jena.graph.query.NamedTripleBunches;
import com.hp.hpl.jena.graph.query.Pipe;
import com.hp.hpl.jena.graph.query.Stage;
import com.hp.hpl.jena.graph.query.TripleSorter;
import com.hp.hpl.jena.util.iterator.ExtendedIterator;
import com.hp.hpl.jena.util.iterator.NiceIterator;
import java.util.ArrayList;
import java.util.Iterator;
import java.util.List;
import java.util.Map;

public class SimpleQueryEngine {
    private ExpressionSet constraint;
    private NamedTripleBunches triples;
    private TripleSorter sortMethod;
    private int variableCount;

    public SimpleQueryEngine(NamedTripleBunches triples, TripleSorter ts, ExpressionSet constraint) {
        this.constraint = constraint;
        this.triples = triples;
        this.sortMethod = ts;
    }

    int getVariableCount() {
        return this.variableCount;
    }

    public ExtendedIterator executeBindings(List outStages, NamedGraphMap args, Node[] nodes) {
        Mapping map = new Mapping(nodes);
        ArrayList<ConstraintStage> stages = new ArrayList<ConstraintStage>();
        this.addStages(stages, args, map);
        if (this.constraint.isComplex()) {
            stages.add(new ConstraintStage(map, this.constraint));
        }
        outStages.addAll(stages);
        this.variableCount = map.size();
        return this.filter(this.connectStages(stages, this.variableCount));
    }

    private ExtendedIterator filter(final Stage allStages) {
        return new NiceIterator(){
            private Pipe complete;

            private void ensurePipe() {
                if (this.complete == null) {
                    this.complete = allStages.deliver(new BufferPipe());
                }
            }

            public void close() {
                allStages.close();
                this.clearPipe();
            }

            public Object next() {
                this.ensurePipe();
                return this.complete.get();
            }

            public boolean hasNext() {
                this.ensurePipe();
                return this.complete.hasNext();
            }

            private void clearPipe() {
                int count = 0;
                while (this.hasNext()) {
                    ++count;
                    this.next();
                }
            }
        };
    }

    public static Cons cons(Triple pattern, Object cons) {
        return new Cons(pattern, (Cons)cons);
    }

    private void addStages(ArrayList stages, NamedGraphMap arguments, Mapping map) {
        Iterator it2 = this.triples.entrySetIterator();
        while (it2.hasNext()) {
            int nBlocks;
            Map.Entry e2 = (Map.Entry)it2.next();
            String name = (String)e2.getKey();
            Cons nodeTriples = (Cons)e2.getValue();
            Graph g = arguments.get(name);
            int i = nBlocks = Cons.size(nodeTriples);
            Triple[] nodes = new Triple[nBlocks];
            while (nodeTriples != null) {
                nodes[--i] = nodeTriples.head;
                nodeTriples = nodeTriples.tail;
            }
            nodes = this.sortTriples(nodes);
            Stage next = g.queryHandler().patternStage(map, this.constraint, nodes);
            stages.add(next);
        }
    }

    private Triple[] sortTriples(Triple[] ts) {
        return this.sortMethod.sort(ts);
    }

    private Stage connectStages(ArrayList stages, int count) {
        Stage current = Stage.initial(count);
        for (int i = 0; i < stages.size(); ++i) {
            current = ((Stage)stages.get(i)).connectFrom(current);
        }
        return current;
    }

    public static class Cons {
        Triple head;
        Cons tail;

        Cons(Triple head, Cons tail) {
            this.head = head;
            this.tail = tail;
        }

        static int size(Cons L) {
            int n = 0;
            while (L != null) {
                ++n;
                L = L.tail;
            }
            return n;
        }
    }
}

