/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.BadObjectException;
import com.hp.hpl.jena.assembler.ConnectionDescription;
import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.assemblers.ConnectionAssembler;
import com.hp.hpl.jena.assembler.exceptions.CannotLoadClassException;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.Resource;
import com.hp.hpl.jena.shared.JenaException;
import java.util.StringTokenizer;
import junit.framework.Assert;

public class TestConnectionAssembler
extends AssemblerTestBase {
    public TestConnectionAssembler(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        return ConnectionAssembler.class;
    }

    public void testConnectionAssemblerType() {
        this.testDemandsMinimalType(new ConnectionAssembler(), JA.Connection);
    }

    public void testConnectionVocabulary() {
        this.assertRange(JA.Connection, JA.connection);
        this.assertDomain(JA.Connection, JA.dbClass);
        this.assertDomain(JA.Connection, JA.dbUser);
        this.assertDomain(JA.Connection, JA.dbPassword);
        this.assertDomain(JA.Connection, JA.dbType);
        this.assertDomain(JA.Connection, JA.dbURL);
        this.assertDomain(JA.Connection, JA.dbClassProperty);
        this.assertDomain(JA.Connection, JA.dbUserProperty);
        this.assertDomain(JA.Connection, JA.dbPasswordProperty);
        this.assertDomain(JA.Connection, JA.dbTypeProperty);
        this.assertDomain(JA.Connection, JA.dbURLProperty);
    }

    public void testConnectionDescriptionFailsOnMissingURL() {
        ConnectionDescription c = new ConnectionDescription("eh:/subject", null, null, null, "myType");
        try {
            c.getConnection();
            TestConnectionAssembler.fail((String)"should trap null URL");
        }
        catch (JenaException e2) {
            TestConnectionAssembler.assertTrue((boolean)e2.getMessage().endsWith("cannot be opened because no dbURL or dbType was specified"));
        }
    }

    public void testConnectionDescriptionFailsOnMissingType() {
        ConnectionDescription c = new ConnectionDescription("eh:/subject", "URL", null, null, null);
        try {
            c.getConnection();
            TestConnectionAssembler.fail((String)"should trap null type");
        }
        catch (JenaException e2) {
            TestConnectionAssembler.assertTrue((boolean)e2.getMessage().endsWith("cannot be opened because no dbURL or dbType was specified"));
        }
    }

    public void testConnectionInitDefaults() {
        Resource init = this.resourceInModel("x ja:dbUser 'USER'; x ja:dbPassword 'PASS'; x ja:dbURL URL:url; x ja:dbType 'TYPE'");
        ConnectionAssembler c = new ConnectionAssembler(init);
        TestConnectionAssembler.assertEquals((String)"USER", (String)c.defaultUser);
        TestConnectionAssembler.assertEquals((String)"PASS", (String)c.defaultPassword);
        TestConnectionAssembler.assertEquals((String)"URL:url", (String)c.defaultURL);
        TestConnectionAssembler.assertEquals((String)"TYPE", (String)c.defaultType);
    }

    public void testCannotLoadClass() {
        ConnectionAssembler a = new ConnectionAssembler();
        Resource root = this.resourceInModel("x rdf:type ja:Connection; x ja:dbClass 'no.such.class'");
        try {
            a.open(root);
            TestConnectionAssembler.fail((String)"should catch class load failure");
        }
        catch (CannotLoadClassException e2) {
            TestConnectionAssembler.assertEquals((Object)TestConnectionAssembler.resource("x"), (Object)e2.getRoot());
            TestConnectionAssembler.assertEquals((String)"no.such.class", (String)e2.getClassName());
            TestConnectionAssembler.assertInstanceOf(ClassNotFoundException.class, e2.getCause());
        }
    }

    public void testDefaultUser() {
        Resource init = this.resourceInModel("x ja:dbUser 'test'");
        Resource root = this.resourceInModel("x rdf:type JA.Connection");
        TestConnectionAssembler.assertEquals((String)"test", (String)new ConnectionAssembler(init).getUser(root));
    }

    public void testDefaultPassword() {
        Resource init = this.resourceInModel("x ja:dbPassword 'byzantium'");
        Resource root = this.resourceInModel("x rdf:type JA.Connection");
        TestConnectionAssembler.assertEquals((String)"byzantium", (String)new ConnectionAssembler(init).getPassword(root));
    }

    public void testDefaultURL() {
        Resource init = this.resourceInModel("x ja:dbURL URL:database");
        Resource root = this.resourceInModel("x rdf:type ja:Connection");
        TestConnectionAssembler.assertEquals((String)"URL:database", (String)new ConnectionAssembler(init).getURL(root));
    }

    public void testDefaultType() {
        Resource init = this.resourceInModel("x ja:dbType 'bodacious'");
        Resource root = this.resourceInModel("x rdf:type ja:Connection");
        TestConnectionAssembler.assertEquals((String)"bodacious", (String)new ConnectionAssembler(init).getType(root));
    }

    public void testFullySpecifiedConnection() {
        Resource root = this.resourceInModel("x rdf:type ja:Connection; x ja:dbUser 'test'; x ja:dbPassword ''; x ja:dbURL jdbc:mysql://localhost/test; x ja:dbType 'MySQL'");
        TestConnectionAssembler.assertEquals((String)"test", (String)new ConnectionAssembler().getUser(root));
        TestConnectionAssembler.assertEquals((String)"", (String)new ConnectionAssembler().getPassword(root));
        TestConnectionAssembler.assertEquals((String)"jdbc:mysql://localhost/test", (String)new ConnectionAssembler().getURL(root));
        TestConnectionAssembler.assertEquals((String)"MySQL", (String)new ConnectionAssembler().getType(root));
    }

    public void testTrapsNonStringObjects() {
        this.testTrapsNonStringObjects("ja:dbClass", "aResource");
        this.testTrapsNonStringObjects("ja:dbClass", "17");
        this.testTrapsNonStringObjects("ja:dbClass", "'tag'de");
        this.testTrapsNonStringObjects("ja:dbClassProperty", "aResource");
        this.testTrapsNonStringObjects("ja:dbClassProperty", "17");
        this.testTrapsNonStringObjects("ja:dbClassProperty", "'tag'de");
    }

    private void testTrapsNonStringObjects(String property, String value) {
        Resource root = this.resourceInModel("x rdf:type ja:Connection; x <property> <value>".replaceAll("<property>", property).replaceAll("<value>", value));
        try {
            new ConnectionAssembler().open(root);
            TestConnectionAssembler.fail((String)("should trap bad object " + value + " for property " + property));
        }
        catch (BadObjectException e2) {
            TestConnectionAssembler.assertEquals((Object)TestConnectionAssembler.resource("x"), (Object)e2.getRoot());
            TestConnectionAssembler.assertEquals((Object)TestConnectionAssembler.rdfNode(empty, value), (Object)e2.getObject());
        }
    }

    public void testOpenConnectionWIthLabels() {
        Resource root = this.resourceInModel("x rdf:type ja:Connection; x ja:dbUser 'X'; x ja:dbPassword 'P'; x ja:dbURL U:RL; x ja:dbType 'T'");
        ConnectionDescription fake = ConnectionDescription.create("eh:/x", "DD", "TT", "UU", "PP");
        CheckingConnectionAssembler x = new CheckingConnectionAssembler(fake, "eh:/x U:RL X P T");
        TestConnectionAssembler.assertSame((Object)fake, (Object)x.open(root));
        TestConnectionAssembler.assertTrue((String)"mock createConnection should have been called", (boolean)x.called);
    }

    public void testConnection() {
        ConnectionAssembler a = new ConnectionAssembler();
        Resource root = this.resourceInModel("x rdf:type ja:Connection; x ja:dbUser 'test'; x ja:dbPassword ''; x ja:dbURL jdbc:mysql://localhost/test; x ja:dbType 'MySQL'");
        Object x = a.open(root);
        TestConnectionAssembler.assertInstanceOf(ConnectionDescription.class, x);
        ConnectionDescription d = (ConnectionDescription)x;
        TestConnectionAssembler.assertEquals((String)"test", (String)d.dbUser);
        TestConnectionAssembler.assertEquals((String)"", (String)d.dbPassword);
        TestConnectionAssembler.assertEquals((String)"MySQL", (String)d.dbType);
        TestConnectionAssembler.assertEquals((String)"jdbc:mysql://localhost/test", (String)d.dbURL);
    }

    public void testIndirectURLConnection() {
        System.setProperty("test.url", "bbb");
        Resource root = this.resourceInModel("x rdf:type ja:Connection; x ja:dbURLProperty 'test.url'");
        ConnectionAssembler a = new ConnectionAssembler();
        ConnectionDescription d = (ConnectionDescription)a.open(root);
        TestConnectionAssembler.assertEquals((String)"bbb", (String)d.dbURL);
    }

    public void testIndirectUserConnection() {
        System.setProperty("test.user", "blenkinsop");
        Resource root = this.resourceInModel("x rdf:type ja:Connection; x ja:dbUserProperty 'test.user'");
        ConnectionAssembler a = new ConnectionAssembler();
        ConnectionDescription d = (ConnectionDescription)a.open(root);
        TestConnectionAssembler.assertEquals((String)"blenkinsop", (String)d.dbUser);
    }

    public void testIndirectPasswordConnection() {
        System.setProperty("test.password", "Top/Secret");
        Resource root = this.resourceInModel("x rdf:type ja:Connection; x ja:dbPasswordProperty 'test.password'");
        ConnectionAssembler a = new ConnectionAssembler();
        ConnectionDescription d = (ConnectionDescription)a.open(root);
        TestConnectionAssembler.assertEquals((String)"Top/Secret", (String)d.dbPassword);
    }

    public void testIndirectTypeConnection() {
        System.setProperty("test.type", "HisSQL");
        Resource root = this.resourceInModel("x rdf:type ja:Connection; x ja:dbTypeProperty 'test.type'");
        ConnectionAssembler a = new ConnectionAssembler();
        ConnectionDescription d = (ConnectionDescription)a.open(root);
        TestConnectionAssembler.assertEquals((String)"HisSQL", (String)d.dbType);
    }

    private static final class CheckingConnectionAssembler
    extends ConnectionAssembler {
        private final ConnectionDescription result;
        private final String expectSubject;
        private final String expectURL;
        private final String expectUser;
        private final String expectPassword;
        private final String expectType;
        private boolean called;

        private CheckingConnectionAssembler(ConnectionDescription result, String expected) {
            StringTokenizer st = new StringTokenizer(expected);
            this.expectSubject = st.nextToken();
            this.expectURL = st.nextToken();
            this.expectUser = st.nextToken();
            this.expectPassword = st.nextToken();
            this.expectType = st.nextToken();
            this.result = result;
        }

        public ConnectionDescription createConnection(String subject, String url, String type, String user, String pass) {
            Assert.assertEquals((String)this.expectSubject, (String)subject);
            Assert.assertEquals((String)this.expectURL, (String)url);
            Assert.assertEquals((String)this.expectUser, (String)user);
            Assert.assertEquals((String)this.expectPassword, (String)pass);
            Assert.assertEquals((String)this.expectType, (String)type);
            this.called = true;
            return this.result;
        }
    }
}

