/*
 * Decompiled with CFR 0.152.
 */
package com.hp.hpl.jena.assembler.test;

import com.hp.hpl.jena.assembler.JA;
import com.hp.hpl.jena.assembler.test.AssemblerTestBase;
import com.hp.hpl.jena.rdf.model.Resource;

public class TestAssemblerVocabulary
extends AssemblerTestBase {
    public TestAssemblerVocabulary(String name) {
        super(name);
    }

    protected Class getAssemblerClass() {
        return null;
    }

    public void testVocabulary() {
        TestAssemblerVocabulary.assertEquals((String)"http://jena.hpl.hp.com/2005/11/Assembler#", (String)JA.getURI());
        TestAssemblerVocabulary.assertEquals((String)"http://jena.hpl.hp.com/2005/11/Assembler#", (String)"http://jena.hpl.hp.com/2005/11/Assembler#");
        this.assertLocalname("this", JA.This);
        this.assertLocalname("Expanded", JA.Expanded);
        this.assertLocalname("Object", JA.Object);
        this.assertLocalname("Model", JA.Model);
        this.assertLocalname("MemoryModel", JA.MemoryModel);
        this.assertLocalname("DefaultModel", JA.DefaultModel);
        this.assertLocalname("InfModel", JA.InfModel);
        this.assertLocalname("OntModel", JA.OntModel);
        this.assertLocalname("NamedModel", JA.NamedModel);
        this.assertLocalname("RDBModel", JA.RDBModel);
        this.assertLocalname("FileModel", JA.FileModel);
        this.assertLocalname("OntModel", JA.OntModel);
        this.assertLocalname("OntModelSpec", JA.OntModelSpec);
        this.assertLocalname("Connection", JA.Connection);
        this.assertLocalname("PrefixMapping", JA.PrefixMapping);
        this.assertLocalname("ReasonerFactory", JA.ReasonerFactory);
        this.assertLocalname("Content", JA.Content);
        this.assertLocalname("LiteralContent", JA.LiteralContent);
        this.assertLocalname("ExternalContent", JA.ExternalContent);
        this.assertLocalname("rules", JA.rules);
        this.assertLocalname("reasoner", JA.reasoner);
        this.assertLocalname("reasonerURL", JA.reasonerURL);
        this.assertLocalname("baseModel", JA.baseModel);
        this.assertLocalname("literalContent", JA.literalContent);
        this.assertLocalname("externalContent", JA.externalContent);
        this.assertLocalname("ontModelSpec", JA.ontModelSpec);
        this.assertLocalname("assembler", JA.assembler);
        this.assertLocalname("loadClass", JA.loadClass);
        this.assertLocalname("prefix", JA.prefix);
        this.assertLocalname("namespace", JA.namespace);
        this.assertLocalname("includes", JA.includes);
        this.assertLocalname("directory", JA.directory);
        this.assertLocalname("mapName", JA.mapName);
        this.assertLocalname("documentManager", JA.documentManager);
        this.assertLocalname("ontModelSpec", JA.ontModelSpec);
        this.assertLocalname("ontLanguage", JA.ontLanguage);
        this.assertLocalname("true", JA.True);
        this.assertLocalname("false", JA.False);
    }

    protected void assertLocalname(String local, Resource resource) {
        TestAssemblerVocabulary.assertEquals((String)("http://jena.hpl.hp.com/2005/11/Assembler#" + local), (String)resource.getURI());
    }

    public void testObjectTypes() {
        this.assertSubclassOf(JA.Model, JA.Object);
        this.assertSubclassOf(JA.PrefixMapping, JA.Object);
        this.assertSubclassOf(JA.Content, JA.Object);
        this.assertSubclassOf(JA.Connection, JA.Object);
        this.assertSubclassOf(JA.OntModelSpec, JA.Object);
        this.assertSubclassOf(JA.ReasonerFactory, JA.Object);
    }

    public void testModelTypes() {
        this.assertSubclassOf(JA.MemoryModel, JA.Model);
        this.assertSubclassOf(JA.DefaultModel, JA.Model);
        this.assertSubclassOf(JA.InfModel, JA.Model);
        this.assertSubclassOf(JA.OntModel, JA.InfModel);
        this.assertSubclassOf(JA.NamedModel, JA.Model);
        this.assertSubclassOf(JA.RDBModel, JA.NamedModel);
        this.assertSubclassOf(JA.FileModel, JA.NamedModel);
        this.assertSubclassOf(JA.ModelSource, JA.Connectable);
    }

    public void testInfModelProperties() {
        this.assertDomain(JA.InfModel, JA.baseModel);
        this.assertDomain(JA.InfModel, JA.reasoner);
    }

    public void testOntModelProperties() {
        this.assertDomain(JA.OntModel, JA.ontModelSpec);
    }
}

