/*
 * Decompiled with CFR 0.152.
 */
package com.hazelcast.client;

import com.hazelcast.client.EntryHolder;
import com.hazelcast.core.IMap;
import com.hazelcast.core.Instance;
import java.util.Iterator;
import java.util.Map;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public class MapEntryIterator<K, V>
implements Iterator<Map.Entry<K, V>> {
    protected final Iterator<K> it;
    protected final EntryHolder<K, V> proxy;
    protected final Instance.InstanceType instanceType;
    protected volatile Map.Entry<K, V> lastEntry;
    K currentIteratedKey;
    V currentIteratedValue;
    boolean hasNextCalled = false;

    public MapEntryIterator(Iterator<K> it, EntryHolder<K, V> proxy, Instance.InstanceType instanceType) {
        this.it = it;
        this.proxy = proxy;
        this.instanceType = instanceType;
    }

    @Override
    public boolean hasNext() {
        this.hasNextCalled = true;
        if (!this.it.hasNext()) {
            return false;
        }
        this.currentIteratedKey = this.it.next();
        this.currentIteratedValue = this.proxy.get(this.currentIteratedKey);
        if (this.currentIteratedValue == null) {
            return this.hasNext();
        }
        return true;
    }

    @Override
    public Map.Entry<K, V> next() {
        if (!this.hasNextCalled) {
            this.hasNext();
        }
        this.hasNextCalled = false;
        K key = this.currentIteratedKey;
        V value = this.currentIteratedValue;
        this.lastEntry = new MapEntry(key, value, this.proxy);
        return this.lastEntry;
    }

    @Override
    public void remove() {
        this.it.remove();
        this.proxy.remove(this.lastEntry.getKey(), this.lastEntry.getValue());
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    protected class MapEntry
    implements Map.Entry<K, V> {
        private K key;
        private V value;
        private EntryHolder<K, V> proxy;

        public MapEntry(K key, V value, EntryHolder<K, V> proxy) {
            this.key = key;
            this.value = value;
            this.proxy = proxy;
        }

        @Override
        public K getKey() {
            return this.key;
        }

        @Override
        public V getValue() {
            return this.value;
        }

        @Override
        public V setValue(V arg0) {
            if (MapEntryIterator.this.instanceType.equals((Object)Instance.InstanceType.MULTIMAP)) {
                throw new UnsupportedOperationException();
            }
            return ((IMap)((Object)this.proxy)).put(this.key, arg0);
        }
    }
}

