/*
 * Decompiled with CFR 0.152.
 */
package com.gc.iotools.stream.os;

import com.gc.iotools.stream.base.ExecutionModel;
import com.gc.iotools.stream.base.ExecutorServiceFactory;
import com.gc.iotools.stream.utils.LogUtils;
import java.io.IOException;
import java.io.InputStream;
import java.io.OutputStream;
import java.io.PipedInputStream;
import java.io.PipedOutputStream;
import java.util.concurrent.Callable;
import java.util.concurrent.ExecutionException;
import java.util.concurrent.ExecutorService;
import java.util.concurrent.Future;
import java.util.concurrent.TimeUnit;
import java.util.concurrent.TimeoutException;
import org.apache.commons.io.input.CloseShieldInputStream;
import org.slf4j.Logger;
import org.slf4j.LoggerFactory;

/*
 * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
 */
public abstract class OutputStreamToInputStream<T>
extends OutputStream {
    private static final int DEFAULT_TIMEOUT = 900000;
    private static int defaultPipeSize = 4096;
    private static final Logger LOG = LoggerFactory.getLogger(OutputStreamToInputStream.class);
    private boolean abort = false;
    private boolean closeCalled = false;
    private final boolean joinOnClose;
    private final PipedOutputStream pipedOs;
    private final Future<T> writingResult;

    @Deprecated
    public static void setDefaultBufferSize(int defaultPipeSize) {
        OutputStreamToInputStream.defaultPipeSize = defaultPipeSize;
    }

    public static void setDefaultPipeSize(int defaultPipeSize) {
        OutputStreamToInputStream.defaultPipeSize = defaultPipeSize;
    }

    public OutputStreamToInputStream() {
        this(true, ExecutionModel.THREAD_PER_INSTANCE);
    }

    public OutputStreamToInputStream(boolean joinOnClose, ExecutionModel executionModel) {
        this(joinOnClose, ExecutorServiceFactory.getExecutor(executionModel));
    }

    public OutputStreamToInputStream(boolean joinOnClose, ExecutorService executorService) {
        this(joinOnClose, executorService, defaultPipeSize);
    }

    public OutputStreamToInputStream(boolean joinOnClose, ExecutorService executorService, int pipeBufferSize) {
        if (executorService == null) {
            throw new IllegalArgumentException("executor service can't be null");
        }
        String callerId = LogUtils.getCaller(this.getClass());
        this.pipedOs = new PipedOutputStream();
        MyPipedInputStream pipedIS = new MyPipedInputStream(pipeBufferSize);
        try {
            pipedIS.connect(this.pipedOs);
        }
        catch (IOException e2) {
            throw new IllegalStateException("Error during pipe creaton", e2);
        }
        DataConsumer executingProcess = new DataConsumer(pipedIS);
        this.joinOnClose = joinOnClose;
        LOG.debug("invoked by[{}] queued for start.", (Object)callerId);
        this.writingResult = executorService.submit(executingProcess);
    }

    protected void afterClose() {
    }

    @Override
    public final void close() throws IOException {
        this.internalClose(this.joinOnClose, TimeUnit.MILLISECONDS, 900000L);
    }

    public final void close(long timeout, TimeUnit tu) throws IOException {
        this.internalClose(true, tu, timeout);
    }

    protected abstract T doRead(InputStream var1) throws Exception;

    @Override
    public final void flush() throws IOException {
        if (this.abort) {
            this.internalClose(true, TimeUnit.SECONDS, 1L);
        } else {
            this.pipedOs.flush();
        }
    }

    public final T getResults() throws InterruptedException, ExecutionException {
        if (!this.closeCalled) {
            throw new IllegalStateException("Method close() must be called before getResults");
        }
        return this.writingResult.get();
    }

    private void internalClose(boolean join, TimeUnit timeUnit, long timeout) throws IOException {
        if (!this.closeCalled) {
            this.closeCalled = true;
            this.pipedOs.close();
            if (join) {
                try {
                    this.writingResult.get(timeout, timeUnit);
                }
                catch (ExecutionException e2) {
                    IOException e1 = new IOException("The doRead() threw exception. Use getCause() for details.");
                    e1.initCause(e2.getCause());
                    throw e1;
                }
                catch (InterruptedException e3) {
                    IOException e1 = new IOException("Waiting of the thread has been interrupted");
                    e1.initCause(e3);
                    throw e1;
                }
                catch (TimeoutException e4) {
                    if (!this.writingResult.isDone()) {
                        this.writingResult.cancel(true);
                    }
                    IOException e1 = new IOException("Waiting for the internal thread to finish took more than [" + timeout + "] " + (Object)((Object)timeUnit));
                    e1.initCause(e4);
                    throw e1;
                }
            }
            this.afterClose();
        }
    }

    @Override
    public final void write(byte[] bytes) throws IOException {
        if (this.abort) {
            this.internalClose(true, TimeUnit.SECONDS, 1L);
        } else {
            this.pipedOs.write(bytes);
        }
    }

    @Override
    public final void write(byte[] bytes, int offset, int length) throws IOException {
        if (this.abort) {
            this.internalClose(true, TimeUnit.SECONDS, 1L);
        } else {
            this.pipedOs.write(bytes, offset, length);
        }
    }

    @Override
    public final void write(int bytetowr) throws IOException {
        if (this.abort) {
            this.internalClose(true, TimeUnit.SECONDS, 1L);
        } else {
            this.pipedOs.write(bytetowr);
        }
    }

    private final class MyPipedInputStream
    extends PipedInputStream {
        MyPipedInputStream(int bufferSize) {
            this.buffer = new byte[bufferSize];
        }
    }

    /*
     * This class specifies class file version 49.0 but uses Java 6 signatures.  Assumed Java 6.
     */
    private final class DataConsumer
    implements Callable<T> {
        private final InputStream inputstream;

        DataConsumer(InputStream istream) {
            this.inputstream = istream;
        }

        @Override
        public synchronized T call() throws Exception {
            Object processResult;
            try {
                CloseShieldInputStream istream = new CloseShieldInputStream(this.inputstream);
                processResult = OutputStreamToInputStream.this.doRead((InputStream)istream);
            }
            catch (Exception e2) {
                OutputStreamToInputStream.this.abort = true;
                throw e2;
            }
            finally {
                this.emptyInputStream();
                this.inputstream.close();
            }
            return processResult;
        }

        private void emptyInputStream() {
            try {
                byte[] buffer = new byte[8192];
                while (this.inputstream.read(buffer) >= 0) {
                }
            }
            catch (IOException e2) {
                if (e2.getMessage() != null && e2.getMessage().indexOf("closed") > 0) {
                    LOG.debug("Stream already closed");
                } else {
                    LOG.error("IOException while empty InputStream a thread can be locked", e2);
                }
            }
            catch (Throwable e3) {
                LOG.error("IOException while empty InputStream a thread can be locked", e3);
            }
        }
    }
}

