/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.recovery;

import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LogException;
import com.sleepycat.je.log.LogReadable;
import com.sleepycat.je.log.LogUtils;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;
import java.sql.Timestamp;
import java.util.Calendar;

public class CheckpointEnd
implements LoggableObject,
LogReadable {
    private String invoker;
    private Timestamp endTime;
    private DbLsn checkpointStartLsn;
    private boolean rootLsnExists;
    private DbLsn rootLsn;
    private DbLsn firstActiveLsn;
    private long lastNodeId;
    private int lastDbId;
    private long lastTxnId;
    private long id;

    public CheckpointEnd(String invoker, DbLsn checkpointStartLsn, DbLsn rootLsn, DbLsn firstActiveLsn, long lastNodeId, int lastDbId, long lastTxnId, long id) {
        this.invoker = invoker == null ? "" : invoker;
        Calendar cal = Calendar.getInstance();
        this.endTime = new Timestamp(cal.getTime().getTime());
        this.checkpointStartLsn = checkpointStartLsn;
        this.rootLsn = rootLsn;
        this.rootLsnExists = rootLsn != null;
        this.firstActiveLsn = firstActiveLsn == null ? checkpointStartLsn : firstActiveLsn;
        this.lastNodeId = lastNodeId;
        this.lastDbId = lastDbId;
        this.lastTxnId = lastTxnId;
        this.id = id;
    }

    public CheckpointEnd() {
        this.checkpointStartLsn = new DbLsn();
        this.rootLsn = new DbLsn();
        this.firstActiveLsn = new DbLsn();
    }

    public LogEntryType getLogType() {
        return LogEntryType.LOG_CKPT_END;
    }

    public boolean marshallOutsideWriteLatch() {
        return true;
    }

    public void postLogWork(DbLsn justLoggedLsn) {
    }

    public int getLogSize() {
        int size = LogUtils.getStringLogSize(this.invoker) + LogUtils.getTimestampLogSize() + this.checkpointStartLsn.getLogSize() + LogUtils.getBooleanLogSize() + this.firstActiveLsn.getLogSize() + LogUtils.getLongLogSize() + LogUtils.getIntLogSize() + LogUtils.getLongLogSize() + LogUtils.getLongLogSize();
        if (this.rootLsnExists) {
            size += this.rootLsn.getLogSize();
        }
        return size;
    }

    public void writeToLog(ByteBuffer logBuffer) {
        LogUtils.writeString(logBuffer, this.invoker);
        LogUtils.writeTimestamp(logBuffer, this.endTime);
        this.checkpointStartLsn.writeToLog(logBuffer);
        LogUtils.writeBoolean(logBuffer, this.rootLsnExists);
        if (this.rootLsnExists) {
            this.rootLsn.writeToLog(logBuffer);
        }
        this.firstActiveLsn.writeToLog(logBuffer);
        LogUtils.writeLong(logBuffer, this.lastNodeId);
        LogUtils.writeInt(logBuffer, this.lastDbId);
        LogUtils.writeLong(logBuffer, this.lastTxnId);
        LogUtils.writeLong(logBuffer, this.id);
    }

    public void readFromLog(ByteBuffer logBuffer) throws LogException {
        this.invoker = LogUtils.readString(logBuffer);
        this.endTime = LogUtils.readTimestamp(logBuffer);
        this.checkpointStartLsn.readFromLog(logBuffer);
        this.rootLsnExists = LogUtils.readBoolean(logBuffer);
        if (this.rootLsnExists) {
            this.rootLsn.readFromLog(logBuffer);
        }
        this.firstActiveLsn.readFromLog(logBuffer);
        this.lastNodeId = LogUtils.readLong(logBuffer);
        this.lastDbId = LogUtils.readInt(logBuffer);
        this.lastTxnId = LogUtils.readLong(logBuffer);
        this.id = LogUtils.readLong(logBuffer);
    }

    public void dumpLog(StringBuffer sb, boolean verbose) {
        sb.append("<CkptEnd invoker=\"").append(this.invoker);
        sb.append("\" time=\"").append(this.endTime);
        sb.append("\" lastNodeId=\"").append(this.lastNodeId);
        sb.append("\" lastDbId=\"").append(this.lastDbId);
        sb.append("\" lastTxnId=\"").append(this.lastTxnId);
        sb.append("\" id=\"").append(this.id);
        sb.append("\" rootExists=\"").append(this.rootLsnExists);
        sb.append("\">");
        sb.append("<ckptStart>");
        this.checkpointStartLsn.dumpLog(sb, verbose);
        sb.append("</ckptStart>");
        if (this.rootLsnExists) {
            sb.append("<root>");
            this.rootLsn.dumpLog(sb, verbose);
            sb.append("</root>");
        }
        sb.append("<firstActive>");
        this.firstActiveLsn.dumpLog(sb, verbose);
        sb.append("</firstActive>");
        sb.append("</CkptEnd>");
    }

    public boolean logEntryIsTransactional() {
        return false;
    }

    public long getTransactionId() {
        return 0L;
    }

    public String toString() {
        StringBuffer sb = new StringBuffer();
        sb.append("time=").append(this.endTime);
        sb.append(" lastNodeId=").append(this.lastNodeId);
        sb.append(" lastDbId=").append(this.lastDbId);
        sb.append(" lastTxnId=").append(this.lastTxnId);
        sb.append(" id=").append(this.id);
        sb.append(" rootExists=").append(this.rootLsnExists);
        sb.append(" ckptStartLsn=").append(this.checkpointStartLsn.getNoFormatString());
        if (this.rootLsnExists) {
            sb.append(" root=").append(this.rootLsn.getNoFormatString());
        }
        sb.append(" firstActive=").append(this.firstActiveLsn.getNoFormatString());
        return sb.toString();
    }

    DbLsn getCheckpointStartLsn() {
        return this.checkpointStartLsn;
    }

    DbLsn getRootLsn() {
        return this.rootLsn;
    }

    DbLsn getFirstActiveLsn() {
        return this.firstActiveLsn;
    }

    long getLastNodeId() {
        return this.lastNodeId;
    }

    int getLastDbId() {
        return this.lastDbId;
    }

    long getLastTxnId() {
        return this.lastTxnId;
    }

    long getId() {
        return this.id;
    }
}

