/*
 * Decompiled with CFR 0.152.
 */
package com.sleepycat.je.log.entry;

import com.sleepycat.je.DatabaseException;
import com.sleepycat.je.dbi.DatabaseId;
import com.sleepycat.je.log.LogEntryType;
import com.sleepycat.je.log.LoggableObject;
import com.sleepycat.je.log.entry.LogEntry;
import com.sleepycat.je.tree.Key;
import com.sleepycat.je.tree.LN;
import com.sleepycat.je.txn.Txn;
import com.sleepycat.je.utilint.DbLsn;
import java.nio.ByteBuffer;

public class LNLogEntry
implements LogEntry,
LoggableObject {
    private LN ln;
    private DatabaseId dbId;
    private Key key;
    private DbLsn abortLsn;
    private boolean abortKnownDeleted;
    private Txn txn;
    private static final byte ABORT_KNOWN_DELETED_MASK = 1;
    private Class logClass;
    private LogEntryType entryType;
    private boolean isTransactional;

    public LNLogEntry(Class logClass, boolean isTransactional) {
        this.logClass = logClass;
        this.isTransactional = isTransactional;
    }

    public LNLogEntry(LogEntryType entryType, LN ln, DatabaseId dbId, Key key, DbLsn abortLsn, boolean abortKnownDeleted, Txn txn) {
        this.entryType = entryType;
        this.ln = ln;
        this.dbId = dbId;
        this.key = key;
        this.abortLsn = abortLsn;
        this.abortKnownDeleted = abortKnownDeleted;
        this.txn = txn;
        this.isTransactional = txn != null;
        this.logClass = ln.getClass();
    }

    public void readEntry(ByteBuffer entryBuffer) throws DatabaseException {
        try {
            this.ln = (LN)this.logClass.newInstance();
            this.ln.readFromLog(entryBuffer);
            this.dbId = new DatabaseId();
            this.dbId.readFromLog(entryBuffer);
            this.key = new Key();
            this.key.readFromLog(entryBuffer);
            if (this.isTransactional) {
                this.abortLsn = new DbLsn();
                this.abortLsn.readFromLog(entryBuffer);
                if (this.abortLsn.getFileNumber() == DbLsn.NULL_LSN.getFileNumber()) {
                    this.abortLsn = null;
                }
                this.abortKnownDeleted = (entryBuffer.get() & 1) != 0;
                this.txn = new Txn();
                this.txn.readFromLog(entryBuffer);
            }
        }
        catch (IllegalAccessException e) {
            throw new DatabaseException(e);
        }
        catch (InstantiationException e) {
            throw new DatabaseException(e);
        }
    }

    public StringBuffer dumpEntry(StringBuffer sb, boolean verbose) {
        this.ln.dumpLog(sb, verbose);
        this.dbId.dumpLog(sb, verbose);
        this.key.dumpLog(sb, verbose);
        if (this.isTransactional) {
            if (this.abortLsn != null) {
                this.abortLsn.dumpLog(sb, verbose);
            }
            sb.append("<knownDeleted val=\"");
            sb.append(this.abortKnownDeleted ? "true" : "false");
            sb.append("\"/>");
            this.txn.dumpLog(sb, verbose);
        }
        return sb;
    }

    public Object getMainItem() {
        return this.ln;
    }

    public Object clone() throws CloneNotSupportedException {
        return super.clone();
    }

    public boolean isTransactional() {
        return this.isTransactional;
    }

    public long getTransactionId() {
        if (this.isTransactional) {
            return this.txn.getId();
        }
        return 0L;
    }

    public LogEntryType getLogType() {
        return this.entryType;
    }

    public boolean marshallOutsideWriteLatch() {
        return this.ln.marshallOutsideWriteLatch();
    }

    public void postLogWork(DbLsn justLoggedLsn) throws DatabaseException {
        if (this.isTransactional) {
            this.txn.addLogInfo(this.ln.getNodeId(), justLoggedLsn);
        }
    }

    public int getLogSize() {
        int size = this.ln.getLogSize() + this.dbId.getLogSize() + this.key.getLogSize();
        if (this.isTransactional) {
            if (this.abortLsn != null) {
                size += this.abortLsn.getLogSize();
            }
            ++size;
            size += this.txn.getLogSize();
        }
        return size;
    }

    public void writeToLog(ByteBuffer destBuffer) {
        this.ln.writeToLog(destBuffer);
        this.dbId.writeToLog(destBuffer);
        this.key.writeToLog(destBuffer);
        if (this.isTransactional) {
            if (this.abortLsn == null) {
                DbLsn.NULL_LSN.writeToLog(destBuffer);
            } else {
                this.abortLsn.writeToLog(destBuffer);
            }
            byte aKD = 0;
            if (this.abortKnownDeleted) {
                aKD = (byte)(aKD | 1);
            }
            destBuffer.put(aKD);
            this.txn.writeToLog(destBuffer);
        }
    }

    public LN getLN() {
        return this.ln;
    }

    public DatabaseId getDbId() {
        return this.dbId;
    }

    public Key getKey() {
        return this.key;
    }

    public Key getDupKey() {
        if (this.ln.isDeleted()) {
            return null;
        }
        return new Key(this.ln.getData());
    }

    public DbLsn getAbortLsn() {
        return this.abortLsn;
    }

    public boolean getAbortKnownDeleted() {
        return this.abortKnownDeleted;
    }

    public Long getTxnId() {
        if (this.isTransactional) {
            return new Long(this.txn.getId());
        }
        return null;
    }

    public Txn getUserTxn() {
        if (this.isTransactional) {
            return this.txn;
        }
        return null;
    }
}

